/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Prefs {
    private static final Map CACHE = Collections.synchronizedMap(new HashMap());
    private static File configPath;

    private Prefs() {
    }

    public static void setConfigPath(File confPath) {
        configPath = confPath;
    }

    public static void flush() {
        CACHE.clear();
    }

    public static Properties getProperties(String file) throws IOException {
        return Prefs.getProperties(new File(configPath, file));
    }

    private static Properties getProperties(File file) throws IOException {
        Properties properties = (Properties)CACHE.get(file);
        if (properties == null) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                properties = new Properties();
                properties.load(in);
                CACHE.put(file, properties);
            }
            catch (IOException ex) {
                throw new IOException("Prefs: File not found: " + file.getAbsolutePath());
            }
            finally {
                if (null != in) {
                    in.close();
                }
            }
        }
        return properties;
    }
}

