/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import imcode.server.Imcms;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.NullArgumentException;

public class LocalizedMessage
implements Serializable {
    private final String languageKey;

    public LocalizedMessage(String languageKey) {
        if (null == languageKey) {
            throw new NullArgumentException("languageKey");
        }
        this.languageKey = languageKey;
    }

    public String toLocalizedString(HttpServletRequest request) {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        return this.toLocalizedString(user);
    }

    public String toLocalizedString(UserDomainObject user) {
        return Imcms.getServices().getLanguageProperties(user).getProperty(this.languageKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.languageKey.equals(((LocalizedMessage)o).languageKey);
    }

    public int hashCode() {
        return this.languageKey.hashCode();
    }
}

