/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.index;

import imcode.server.document.DocumentDomainObject;
import imcode.server.document.index.DefaultDirectoryIndex;
import imcode.server.document.index.IndexBuildingThread;
import imcode.server.document.index.IndexDocumentFactory;
import imcode.server.document.index.RebuildingDirectoryIndex;
import imcode.util.CounterStringFactory;
import imcode.util.ShouldNotBeThrownException;
import imcode.util.Utility;
import java.io.File;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ClassUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class BackgroundIndexBuilder {
    private static final Logger log = Logger.getLogger((Class)BackgroundIndexBuilder.class);
    private final File indexParentDirectory;
    private final RebuildingDirectoryIndex rebuildingDirectoryIndex;
    private IndexBuildingThread indexBuildingThread;
    private long previousIndexParentDirectoryLastModified;
    private IndexDocumentFactory indexDocumentFactory;

    public BackgroundIndexBuilder(File indexParentDirectory, RebuildingDirectoryIndex rebuildingDirectoryIndex, IndexDocumentFactory indexDocumentFactory) {
        this.indexParentDirectory = indexParentDirectory;
        this.rebuildingDirectoryIndex = rebuildingDirectoryIndex;
        indexParentDirectory.setLastModified(System.currentTimeMillis());
        this.previousIndexParentDirectoryLastModified = indexParentDirectory.lastModified();
        this.indexDocumentFactory = indexDocumentFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        try {
            NDC.push((String)(ClassUtils.getShortClassName(this.getClass()) + "-" + Utility.numberToAlphaNumerics(System.identityHashCode(this))));
            this.touchIndexParentDirectory();
            if (null != this.indexBuildingThread && this.indexBuildingThread.isAlive()) {
                log.debug((Object)"Ignoring request to build new index. Already in progress.");
                return;
            }
            File indexDirectory = BackgroundIndexBuilder.getNewIndexDirectory(this.indexParentDirectory);
            if (!indexDirectory.mkdirs()) {
                log.warn((Object)"Failed to create new index directory. Will try again next time.");
                return;
            }
            log.debug((Object)("Created directory " + indexDirectory));
            this.rememberIndexParentDirectoryLastModified();
            try {
                log.debug((Object)"Starting index rebuild thread.");
                this.indexBuildingThread = new IndexBuildingThread(this, indexDirectory, this.indexDocumentFactory);
                this.indexBuildingThread.start();
            }
            catch (IllegalThreadStateException itse) {
                throw new ShouldNotBeThrownException(itse);
            }
        }
        finally {
            NDC.pop();
        }
    }

    boolean otherProcessModifiedIndexDirectory() {
        long lastModified;
        if (this.previousIndexParentDirectoryLastModified != 0L && (lastModified = this.indexParentDirectory.lastModified()) > this.previousIndexParentDirectoryLastModified) {
            log.trace((Object)("Expected last modified " + this.previousIndexParentDirectoryLastModified + " but got " + lastModified));
            this.rememberIndexParentDirectoryLastModified();
            return true;
        }
        return false;
    }

    void touchIndexParentDirectory() {
        this.indexParentDirectory.setLastModified(System.currentTimeMillis());
        this.rememberIndexParentDirectoryLastModified();
    }

    public synchronized void addDocument(DocumentDomainObject document) {
        if (null != this.indexBuildingThread) {
            this.indexBuildingThread.addDocument(document);
        }
    }

    public synchronized void removeDocument(DocumentDomainObject document) {
        if (null != this.indexBuildingThread) {
            this.indexBuildingThread.removeDocument(document);
        }
    }

    private static File getNewIndexDirectory(File indexParentDirectory) {
        return (File)Utility.findMatch(new CounterFileFactory(indexParentDirectory), new UniqueFilePredicate());
    }

    public synchronized void notifyRebuildComplete(DefaultDirectoryIndex newIndex) {
        this.rebuildingDirectoryIndex.notifyRebuildComplete(newIndex);
        this.rememberIndexParentDirectoryLastModified();
    }

    private void rememberIndexParentDirectoryLastModified() {
        this.previousIndexParentDirectoryLastModified = this.indexParentDirectory.lastModified();
    }

    private static class UniqueFilePredicate
    implements Predicate {
        private UniqueFilePredicate() {
        }

        public boolean evaluate(Object object) {
            File file = (File)object;
            return !file.exists();
        }
    }

    private static class CounterFileFactory
    extends CounterStringFactory {
        private File parentDirectory;

        CounterFileFactory(File parentDirectory) {
            super(1);
            this.parentDirectory = parentDirectory;
        }

        public Object create() {
            return new File(this.parentDirectory, (String)super.create());
        }
    }
}

