/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.api.Document;
import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.DocumentPageFlow;
import com.imcode.imcms.flow.EditDocumentInformationPageFlow;
import com.imcode.imcms.flow.EditFileDocumentPageFlow;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.servlet.DocumentFinder;
import com.imcode.imcms.servlet.admin.ImageBrowser;
import com.imcode.imcms.servlet.superadmin.AdminManager;
import com.imcode.util.HumanReadable;
import com.imcode.util.ImageSize;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.ConcurrentDocumentModificationException;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.NoPermissionToCreateDocumentException;
import imcode.server.document.NoPermissionToEditDocumentException;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.index.DefaultQueryParser;
import imcode.server.document.index.QueryParser;
import imcode.server.document.textdocument.FileDocumentImageSource;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.ImageSource;
import imcode.server.document.textdocument.ImagesPathRelativePathImageSource;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.ImcmsImageUtils;
import imcode.util.LocalizedMessage;
import imcode.util.ShouldHaveCheckedPermissionsEarlierException;
import imcode.util.Utility;
import imcode.util.io.InputStreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class ChangeImage
extends HttpServlet {
    public static final String REQUEST_PARAMETER__IMAGE_URL = "imageref";
    public static final String REQUEST_PARAMETER__GO_TO_IMAGE_SEARCH_BUTTON = "goToImageSearch";
    public static final String REQUEST_PARAMETER__GO_TO_IMAGE_BROWSER_BUTTON = "goToImageBrowser";
    public static final String REQUEST_PARAMETER__GO_TO_ADD_RESTRICTED_IMAGE_BUTTON = "goToAddRestrictedImage";
    public static final String REQUEST_PARAMETER__OK_BUTTON = "ok";
    public static final String REQUEST_PARAMETER__PREVIEW_BUTTON = "show_img";
    public static final String REQUEST_PARAMETER__IMAGE_HEIGHT = "image_height";
    public static final String REQUEST_PARAMETER__IMAGE_WIDTH = "image_width";
    public static final String REQUEST_PARAMETER__IMAGE_BORDER = "image_border";
    public static final String REQUEST_PARAMETER__VERTICAL_SPACE = "v_space";
    public static final String REQUEST_PARAMETER__HORIZONTAL_SPACE = "h_space";
    public static final String REQUEST_PARAMETER__IMAGE_NAME = "image_name";
    public static final String REQUEST_PARAMETER__IMAGE_INDEX = "img";
    public static final String REQUEST_PARAMETER__CANCEL_BUTTON = "cancel";
    public static final String REQUEST_PARAMETER__DELETE_BUTTON = "delete";
    public static final String REQUEST_PARAMETER__IMAGE_ALIGN = "image_align";
    public static final String REQUEST_PARAMETER__IMAGE_ALT = "alt_text";
    public static final String REQUEST_PARAMETER__IMAGE_LOWSRC = "low_scr";
    public static final String REQUEST_PARAMETER__DOCUMENT_ID = "documentId";
    public static final String REQUEST_PARAMETER__LABEL = "label";
    public static final String REQUEST_PARAMETER__LINK_URL = "imageref_link";
    public static final String REQUEST_PARAMETER__LINK_TARGET = "target";
    private static final String[] IMAGE_MIME_TYPES = new String[]{"image/jpeg", "image/png", "image/gif"};
    static final LocalizedMessage ERROR_MESSAGE__ONLY_ALLOWED_TO_UPLOAD_IMAGES = new LocalizedMessage("error/servlet/images/only_allowed_to_upload_images");
    private static final Query QUERY__IMAGE_FILE_DOCUMENTS = ChangeImage.createImageFileDocumentsQuery();

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ImageDomainObject image = this.getImageFromRequest(request);
        UserDomainObject user = Utility.getLoggedOnUser(request);
        ImcmsServices imcref = Imcms.getServices();
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        TextDocumentDomainObject document = (TextDocumentDomainObject)documentMapper.getDocument(Integer.parseInt(request.getParameter(REQUEST_PARAMETER__DOCUMENT_ID)));
        int imageIndex = Integer.parseInt(request.getParameter(REQUEST_PARAMETER__IMAGE_INDEX));
        if (!this.userHasImagePermissionsOnDocument(user, document)) {
            this.goBack(document, response);
            return;
        }
        if (null != request.getParameter(REQUEST_PARAMETER__CANCEL_BUTTON)) {
            this.goBack(document, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__DELETE_BUTTON)) {
            image = new ImageDomainObject();
            this.goToImageEditPage(document, imageIndex, image, request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__PREVIEW_BUTTON)) {
            this.goToImageEditPage(document, imageIndex, image, request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__GO_TO_IMAGE_BROWSER_BUTTON)) {
            this.goToImageBrowser(document, imageIndex, image, request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__GO_TO_IMAGE_SEARCH_BUTTON)) {
            this.goToImageSearch(documentMapper, document, imageIndex, image, request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__GO_TO_ADD_RESTRICTED_IMAGE_BUTTON)) {
            this.goToImageAdder(documentMapper, document, user, image, imageIndex, request, response);
        } else {
            document.setImage(imageIndex, image);
            try {
                documentMapper.saveDocument(document, user);
            }
            catch (NoPermissionToEditDocumentException e) {
                throw new ShouldHaveCheckedPermissionsEarlierException(e);
            }
            catch (NoPermissionToAddDocumentToMenuException e) {
                throw new ConcurrentDocumentModificationException(e);
            }
            imcref.updateMainLog("ImageRef " + imageIndex + " =" + image.getUrlPathRelativeToContextPath() + " in  " + "[" + document.getId() + "] modified by user: [" + user.getFullName() + "]");
            this.goBack(document, response);
        }
    }

    private void goToImageAdder(final DocumentMapper documentMapper, final TextDocumentDomainObject document, UserDomainObject user, final ImageDomainObject image, final int imageIndex, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            FileDocumentDomainObject fileDocument = (FileDocumentDomainObject)documentMapper.createDocumentOfTypeFromParent(8, document, user);
            EditFileDocumentPageFlow.ArrayMimeTypeRestriction mimeTypeRestriction = new EditFileDocumentPageFlow.ArrayMimeTypeRestriction(IMAGE_MIME_TYPES, ERROR_MESSAGE__ONLY_ALLOWED_TO_UPLOAD_IMAGES);
            DocumentPageFlow.SaveDocumentCommand saveNewImageFileDocument = new DocumentPageFlow.SaveDocumentCommand(){

                public void saveDocument(DocumentDomainObject document, UserDomainObject user) throws NoPermissionToEditDocumentException, NoPermissionToAddDocumentToMenuException {
                    FileDocumentDomainObject fileDocument = (FileDocumentDomainObject)document;
                    Map files = fileDocument.getFiles();
                    Iterator iterator = files.values().iterator();
                    while (iterator.hasNext()) {
                        FileDocumentDomainObject.FileDocumentFile file = (FileDocumentDomainObject.FileDocumentFile)iterator.next();
                        file.setCreatedAsImage(true);
                    }
                    FileDocumentDomainObject.FileDocumentFile file = (FileDocumentDomainObject.FileDocumentFile)files.values().iterator().next();
                    if (null != file) {
                        fileDocument.setHeadline(file.getFilename());
                        fileDocument.setPublicationStatus(Document.PublicationStatus.APPROVED);
                        documentMapper.saveNewDocument(document, user);
                        image.setSourceAndClearSize(new FileDocumentImageSource(documentMapper.getDocumentReference(fileDocument)));
                    }
                }
            };
            DispatchCommand returnToImageEditPageCommand = new DispatchCommand(){

                public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    ChangeImage.this.goToImageEditPage(document, imageIndex, image, request, response);
                }
            };
            EditFileDocumentPageFlow pageFlow = new EditFileDocumentPageFlow(fileDocument, this.getServletContext(), returnToImageEditPageCommand, saveNewImageFileDocument, mimeTypeRestriction);
            pageFlow.dispatch(request, response);
        }
        catch (NoPermissionToCreateDocumentException e) {
            throw new ShouldHaveCheckedPermissionsEarlierException(e);
        }
    }

    private void goToImageBrowser(final TextDocumentDomainObject document, final int imageIndex, final ImageDomainObject image, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ImageBrowser imageBrowser = new ImageBrowser();
        imageBrowser.setCancelCommand(new DispatchCommand(){

            public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                ChangeImage.this.goToImageEditPage(document, imageIndex, image, request, response);
            }
        });
        imageBrowser.setSelectImageUrlCommand(new ImageBrowser.SelectImageUrlCommand(){

            public void selectImageUrl(String imageUrl, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                image.setSourceAndClearSize(new ImagesPathRelativePathImageSource(imageUrl));
                ChangeImage.this.goToImageEditPage(document, imageIndex, image, request, response);
            }
        });
        imageBrowser.forward(request, response);
    }

    private void goToImageSearch(final DocumentMapper documentMapper, final TextDocumentDomainObject document, final int imageIndex, final ImageDomainObject image, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DocumentFinder documentFinder = new DocumentFinder();
        documentFinder.setQueryParser(new HeadlineWildcardQueryParser());
        documentFinder.setCancelCommand(new DispatchCommand(){

            public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                ChangeImage.this.goToImageEditPage(document, imageIndex, image, request, response);
            }
        });
        documentFinder.setSelectDocumentCommand(new DocumentFinder.SelectDocumentCommand(){

            public void selectDocument(DocumentDomainObject documentFound, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                FileDocumentDomainObject imageFileDocument = (FileDocumentDomainObject)documentFound;
                if (null != imageFileDocument) {
                    image.setSourceAndClearSize(new FileDocumentImageSource(documentMapper.getDocumentReference(imageFileDocument)));
                }
                ChangeImage.this.goToImageEditPage(document, imageIndex, image, request, response);
            }
        });
        documentFinder.setRestrictingQuery(QUERY__IMAGE_FILE_DOCUMENTS);
        documentFinder.addExtraSearchResultColumn(new AdminManager.DatesSummarySearchResultColumn());
        documentFinder.addExtraSearchResultColumn(new ImageThumbnailSearchResultColumn());
        documentFinder.forward(request, response);
    }

    private static Query createImageFileDocumentsQuery() {
        BooleanQuery imageMimeTypeQuery = new BooleanQuery();
        for (int i = 0; i < IMAGE_MIME_TYPES.length; ++i) {
            String imageMimeType = IMAGE_MIME_TYPES[i];
            imageMimeTypeQuery.add((Query)new TermQuery(new Term("mime_type", imageMimeType)), false, false);
        }
        TermQuery fileDocumentQuery = new TermQuery(new Term("doc_type_id", "8"));
        BooleanQuery booleanQuery = new BooleanQuery();
        booleanQuery.add((Query)fileDocumentQuery, true, false);
        booleanQuery.add((Query)imageMimeTypeQuery, true, false);
        return booleanQuery;
    }

    private ImageDomainObject getImageFromRequest(HttpServletRequest req) {
        ImageDomainObject image = new ImageDomainObject();
        try {
            image.setWidth(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__IMAGE_WIDTH)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            image.setHeight(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__IMAGE_HEIGHT)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            image.setBorder(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__IMAGE_BORDER)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            image.setVerticalSpace(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__VERTICAL_SPACE)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            image.setHorizontalSpace(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__HORIZONTAL_SPACE)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        String imageUrl = req.getParameter(REQUEST_PARAMETER__IMAGE_URL);
        ImageSource imageSource = ImcmsImageUtils.createImageSourceFromString(imageUrl);
        image.setSource(imageSource);
        image.setName(req.getParameter(REQUEST_PARAMETER__IMAGE_NAME).trim());
        image.setAlign(req.getParameter(REQUEST_PARAMETER__IMAGE_ALIGN));
        image.setAlternateText(req.getParameter(REQUEST_PARAMETER__IMAGE_ALT));
        image.setLowResolutionUrl(req.getParameter(REQUEST_PARAMETER__IMAGE_LOWSRC));
        image.setTarget(EditDocumentInformationPageFlow.getTargetFromRequest(req));
        image.setLinkUrl(req.getParameter(REQUEST_PARAMETER__LINK_URL));
        return image;
    }

    private void goBack(TextDocumentDomainObject document, HttpServletResponse response) throws IOException {
        response.sendRedirect("AdminDoc?meta_id=" + document.getId() + "&flags=" + 131072);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        TextDocumentDomainObject document = (TextDocumentDomainObject)documentMapper.getDocument(Integer.parseInt(request.getParameter("meta_id")));
        ImageDomainObject image = document.getImage(this.getImageNumberParam(request));
        UserDomainObject user = Utility.getLoggedOnUser(request);
        if (!this.userHasImagePermissionsOnDocument(user, document)) {
            Utility.redirectToStartDocument(request, response);
            return;
        }
        this.goToImageEditPage(document, this.getImageNumberParam(request), image, request, response);
    }

    private boolean userHasImagePermissionsOnDocument(UserDomainObject user, TextDocumentDomainObject document) {
        TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)user.getPermissionSetFor(document);
        boolean imagePermission = textDocumentPermissionSet.getEditImages();
        return imagePermission;
    }

    private void goToImageEditPage(TextDocumentDomainObject document, int imageIndex, ImageDomainObject image, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String label = StringUtils.defaultString((String)request.getParameter(REQUEST_PARAMETER__LABEL));
        new ImageEditPage(document, imageIndex, image, label).forward(request, response);
    }

    private int getImageNumberParam(HttpServletRequest req) {
        return Integer.parseInt(req.getParameter(REQUEST_PARAMETER__IMAGE_INDEX));
    }

    private static class ImageThumbnailSearchResultColumn
    implements DocumentFinder.SearchResultColumn {
        private ImageThumbnailSearchResultColumn() {
        }

        public String render(DocumentDomainObject document, HttpServletRequest request, HttpServletResponse response) {
            long fileSize;
            UserDomainObject user = Utility.getLoggedOnUser(request);
            FileDocumentDomainObject imageFileDocument = (FileDocumentDomainObject)document;
            ImageSize imageSize = new ImageSize(0, 0);
            InputStreamSource inputStreamSource = imageFileDocument.getDefaultFile().getInputStreamSource();
            try {
                InputStream inputStream = inputStreamSource.getInputStream();
                fileSize = inputStreamSource.getSize();
                try {
                    imageSize = ImageSize.fromInputStream((InputStream)inputStream);
                }
                catch (IOException ignored) {}
            }
            catch (IOException ioe) {
                throw new UnhandledException((Throwable)ioe);
            }
            List<Object> values = Arrays.asList("imageUrl", "GetDoc?meta_id=" + document.getId(), "imageSize", imageSize, "fileSize", HumanReadable.getHumanReadableByteSize((long)fileSize).replaceAll(" ", "&nbsp;"));
            return Imcms.getServices().getAdminTemplate("images/thumbnail.frag", user, values);
        }

        public LocalizedMessage getName() {
            return new LocalizedMessage("server/src/com/imcode/imcms/servlet/admin/ChangeImage/search/image_thumbnail_label");
        }
    }

    private static class HeadlineWildcardQueryParser
    implements QueryParser {
        private HeadlineWildcardQueryParser() {
        }

        public Query parse(String queryString) {
            String[] queryStrings = StringUtils.split((String)queryString);
            BooleanQuery wildcardsQuery = new BooleanQuery();
            for (int i = 0; i < queryStrings.length; ++i) {
                String queryTerm = queryStrings[i];
                wildcardsQuery.add((Query)new WildcardQuery(new Term("meta_headline", "*" + queryTerm + "*")), true, false);
            }
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add((Query)wildcardsQuery, false, false);
            try {
                booleanQuery.add(new DefaultQueryParser().parse(queryString), false, false);
            }
            catch (ParseException e) {
                // empty catch block
            }
            return booleanQuery;
        }
    }

    public static class ImageEditPage {
        public static final String REQUEST_ATTRIBUTE__PAGE = "page";
        private TextDocumentDomainObject document;
        private int imageIndex;
        private ImageDomainObject image;
        private String label;

        public ImageEditPage(TextDocumentDomainObject document, int imageIndex, ImageDomainObject image, String label) {
            this.document = document;
            this.image = image;
            this.imageIndex = imageIndex;
            this.label = label;
        }

        public TextDocumentDomainObject getDocument() {
            return this.document;
        }

        public ImageDomainObject getImage() {
            return this.image;
        }

        public int getImageIndex() {
            return this.imageIndex;
        }

        private void forward(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            request.setAttribute(REQUEST_ATTRIBUTE__PAGE, (Object)this);
            UserDomainObject user = Utility.getLoggedOnUser(request);
            request.getRequestDispatcher("/imcms/" + user.getLanguageIso639_2() + "/jsp/change_img.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }

        public String getLabel() {
            return this.label;
        }
    }
}

