/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.servlet.GetDoc;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.NDC;

public class ImcmsSetupFilter
implements Filter {
    public static final String JSESSIONID_COOKIE_NAME = "JSESSIONID";
    static final /* synthetic */ boolean $assertionsDisabled;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        UserDomainObject user;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpSession session = httpServletRequest.getSession();
        ImcmsServices service = Imcms.getServices();
        if (session.isNew()) {
            service.incrementSessionCounter();
            this.setDomainSessionCookie(response, session);
        }
        if (null == (user = Utility.getLoggedOnUser(httpServletRequest))) {
            user = service.verifyUserByIpOrDefault(request.getRemoteAddr());
            if (!$assertionsDisabled && !user.isActive()) {
                throw new AssertionError();
            }
            Utility.makeUserLoggedIn(httpServletRequest, user);
        }
        Utility.initRequestWithApi(request, user);
        NDC.setMaxDepth((int)0);
        String contextPath = ((HttpServletRequest)request).getContextPath();
        if (!"".equals(contextPath)) {
            NDC.push((String)contextPath);
        }
        NDC.push((String)StringUtils.substringAfterLast((String)((HttpServletRequest)request).getRequestURI(), (String)"/"));
        this.handleDocumentUri(httpServletRequest, service, request, response, chain);
        NDC.setMaxDepth((int)0);
    }

    private void handleDocumentUri(HttpServletRequest httpServletRequest, ImcmsServices service, ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        String path = httpServletRequest.getRequestURI();
        path = StringUtils.substringAfter((String)path, (String)httpServletRequest.getContextPath());
        String documentPathPrefix = service.getConfig().getDocumentPathPrefix();
        String documentIdString = null;
        if (StringUtils.isNotBlank((String)documentPathPrefix) && path.startsWith(documentPathPrefix)) {
            documentIdString = path.substring(documentPathPrefix.length());
        }
        if (null != documentIdString && NumberUtils.isDigits(documentIdString)) {
            try {
                int documentId = Integer.parseInt(documentIdString);
                GetDoc.output(documentId, httpServletRequest, (HttpServletResponse)response);
            }
            catch (NumberFormatException nfe) {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private void setDomainSessionCookie(ServletResponse response, HttpSession session) {
        String domain = Imcms.getServices().getConfig().getSessionCookieDomain();
        if (StringUtils.isNotBlank((String)domain)) {
            Cookie cookie = new Cookie(JSESSIONID_COOKIE_NAME, session.getId());
            cookie.setDomain(domain);
            cookie.setPath("/");
            ((HttpServletResponse)response).addCookie(cookie);
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    static {
        $assertionsDisabled = !ImcmsSetupFilter.class.desiredAssertionStatus();
    }
}

