/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.servlet.SearchDocumentsPage;
import com.imcode.imcms.servlet.WebComponent;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.index.DefaultQueryParser;
import imcode.server.document.index.DocumentIndex;
import imcode.server.document.index.QueryParser;
import imcode.util.LocalizedMessage;
import imcode.util.Utility;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.SetUtils;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class DocumentFinder
extends WebComponent {
    private SelectDocumentCommand selectDocumentCommand;
    private Query restrictingQuery;
    private QueryParser queryParser = new DefaultQueryParser();
    private Set extraSearchResultColumns = SetUtils.orderedSet(new HashSet());
    private SearchDocumentsPage page;
    private Comparator documentComparator;

    public DocumentFinder() {
        this(new SearchDocumentsPage());
    }

    public DocumentFinder(SearchDocumentsPage page) {
        this.page = page;
        page.setDocumentFinder(this);
    }

    public void selectDocument(DocumentDomainObject selectedDocument, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.selectDocumentCommand.selectDocument(selectedDocument, request, response);
    }

    public void forward(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.forwardWithPage(request, response, this.page);
    }

    void forwardWithPage(HttpServletRequest request, HttpServletResponse response, SearchDocumentsPage page) throws IOException, ServletException {
        ImcmsServices service = Imcms.getServices();
        DocumentIndex index = service.getDocumentMapper().getDocumentIndex();
        BooleanQuery booleanQuery = new BooleanQuery();
        if (null != page.getQuery()) {
            booleanQuery.add(page.getQuery(), true, false);
        }
        if (null != this.restrictingQuery) {
            booleanQuery.add(this.restrictingQuery, true, false);
        }
        if (booleanQuery.getClauses().length > 0) {
            List documentsFound = index.search((Query)booleanQuery, null, Utility.getLoggedOnUser(request));
            if (null != this.documentComparator) {
                Collections.sort(documentsFound, this.documentComparator);
            }
            page.setDocumentsFound(documentsFound);
        }
        page.forward(request, response);
    }

    public boolean isDocumentsSelectable() {
        return null != this.selectDocumentCommand;
    }

    public void setSelectDocumentCommand(SelectDocumentCommand selectDocumentCommand) {
        this.selectDocumentCommand = selectDocumentCommand;
    }

    public void setRestrictingQuery(Query restrictingQuery) {
        this.restrictingQuery = restrictingQuery;
    }

    public void setQueryParser(QueryParser queryParser) {
        this.queryParser = queryParser;
    }

    public Query parse(String queryString) throws ParseException {
        return this.queryParser.parse(queryString);
    }

    public void addExtraSearchResultColumn(SearchResultColumn searchResultColumn) {
        this.extraSearchResultColumns.add(searchResultColumn);
    }

    public SearchResultColumn[] getExtraSearchResultColumns() {
        return this.extraSearchResultColumns.toArray(new SearchResultColumn[this.extraSearchResultColumns.size()]);
    }

    public void setDocumentComparator(Comparator documentComparator) {
        this.documentComparator = documentComparator;
    }

    public static interface SearchResultColumn
    extends Serializable {
        public String render(DocumentDomainObject var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException, ServletException;

        public LocalizedMessage getName();
    }

    public static interface SelectDocumentCommand
    extends Serializable {
        public void selectDocument(DocumentDomainObject var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException, ServletException;
    }
}

