/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.mock.MockDatabase;
import com.imcode.db.mock.MockResultSet;
import com.imcode.imcms.mapping.MapDocumentGetter;
import com.imcode.imcms.mapping.TextDocumentInitializer;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class TestTextDocumentInitializer
extends TestCase {
    public void testInitDocumentsMenuItems() throws Exception {
        List<Integer> documentIds = Arrays.asList(new Integer(1001), new Integer(1002));
        MockDatabase database = new MockDatabase();
        database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.StartsWithSqlCallPredicate("SELECT meta_id, menus.menu_id, menu_index, sort_order, to_meta_id, manual_sort_order, tree_sort_index FROM menus,childs WHERE menus.menu_id = childs.menu_id AND meta_id "), (Object)new MockResultSet((Object[][])new Object[][]{{new Integer(1001), new Integer(1), new Integer(1), new Integer(1), new Integer(1002), new Integer(500), ""}, {new Integer(1001), new Integer(1), new Integer(1), new Integer(1), new Integer(1003), new Integer(510), ""}, {new Integer(1001), new Integer(1), new Integer(1), new Integer(1), new Integer(1005), new Integer(500), ""}, {new Integer(1001), new Integer(2), new Integer(2), new Integer(1), new Integer(1002), new Integer(500), ""}}));
        MapDocumentGetter documentGetter = new MapDocumentGetter(new DocumentDomainObject[]{new TextDocumentDomainObject(1001), new TextDocumentDomainObject(1002), new TextDocumentDomainObject(1003), new TextDocumentDomainObject(1004)});
        TextDocumentInitializer initializer = new TextDocumentInitializer((Database)database, documentGetter, documentIds);
        TextDocumentDomainObject textDocument = (TextDocumentDomainObject)documentGetter.getDocument(new Integer(1001));
        initializer.initialize(textDocument);
        TestTextDocumentInitializer.assertEquals((int)2, (int)textDocument.getMenus().size());
        MenuDomainObject menu1 = textDocument.getMenu(1);
        TestTextDocumentInitializer.assertEquals((int)2, (int)menu1.getMenuItems().length);
        MenuDomainObject menu2 = textDocument.getMenu(2);
        TestTextDocumentInitializer.assertEquals((int)1, (int)menu2.getMenuItems().length);
    }
}

