/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.mock.MockDatabase;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.SaveException;
import com.imcode.imcms.mapping.AbstractDocumentGetter;
import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentPermissionSetMapper;
import com.imcode.imcms.mapping.DocumentSaver;
import com.imcode.imcms.mapping.MapDocumentGetter;
import imcode.server.MockImcmsServices;
import imcode.server.document.DirectDocumentReference;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.NoPermissionToEditDocumentException;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import imcode.util.SystemClock;
import java.util.Collection;
import java.util.Set;
import junit.framework.TestCase;

public class TestDocumentSaver
extends TestCase {
    private DocumentMapper documentMapper;
    private DocumentSaver documentSaver;

    protected void setUp() throws Exception {
        super.setUp();
        MockDatabase database = new MockDatabase();
        this.documentMapper = new DocumentMapper(new MockImcmsServices(), (Database)database){

            public void invalidateDocument(DocumentDomainObject document) {
            }
        };
        this.documentMapper.setDocumentPermissionSetMapper(new DocumentPermissionSetMapper((Database)database));
        this.documentMapper.setClock(new SystemClock());
        this.documentSaver = new DocumentSaver(this.documentMapper);
    }

    public void testRemoveOwnPermissionsFromDocument() throws SaveException, NoPermissionException {
        final TextDocumentDomainObject oldDocument = this.createDocument(1001);
        this.documentMapper.setDocumentGetter(new AbstractDocumentGetter(){

            public DocumentDomainObject getDocument(Integer documentId) {
                return oldDocument;
            }
        });
        TextDocumentDomainObject document = this.createDocument(1001);
        try {
            this.documentSaver.saveDocument(document, oldDocument, new UserDomainObject());
            TestDocumentSaver.fail((String)"Expected exception.");
        }
        catch (NoPermissionToEditDocumentException noPermissionToEditDocumentException) {
            // empty catch block
        }
        oldDocument.setDocumentPermissionSetTypeForRoleId(RoleId.USERS, DocumentPermissionSetTypeDomainObject.FULL);
        this.documentSaver.saveDocument(document, oldDocument, new UserDomainObject());
    }

    private TextDocumentDomainObject createDocument(int documentId) {
        TextDocumentDomainObject document = new TextDocumentDomainObject();
        this.documentMapper.makeDocumentLookNew(document, new UserDomainObject());
        document.setId(documentId);
        document.setTemplateId(1);
        return document;
    }

    public void testDocumentAddedWithoutPermission() {
        TextDocumentDomainObject document1001 = this.createTextDocument(1001);
        TextDocumentDomainObject document1002 = this.createTextDocument(1002);
        MapDocumentGetter documentGetter = new MapDocumentGetter(new DocumentDomainObject[]{document1001, document1002});
        this.documentMapper.setDocumentGetter(documentGetter);
        TextDocumentDomainObject oldDocument = document1001;
        TextDocumentDomainObject addedDocument = document1002;
        UserDomainObject testedUser = new UserDomainObject();
        TextDocumentDomainObject document = (TextDocumentDomainObject)this.documentMapper.getDocument(1001);
        document.getMenu(1).addMenuItem(new MenuItemDomainObject(new DirectDocumentReference(addedDocument)));
        document1002.setLinkableByOtherUsers(true);
        this.assertDocumentsAddedWithPermission(document, null, testedUser, documentGetter);
        document1002.setLinkableByOtherUsers(false);
        this.assertDocumentsAddedWithoutPermission(document, null, testedUser, documentGetter);
        this.assertDocumentsAddedWithoutPermission(document, oldDocument, testedUser, documentGetter);
        document1002.setLinkableByOtherUsers(true);
        this.assertDocumentsAddedWithPermission(document, oldDocument, testedUser, documentGetter);
        document1002.setLinkableByOtherUsers(false);
        this.assertDocumentsAddedWithoutPermission(document, oldDocument, testedUser, documentGetter);
        document1002.setDocumentPermissionSetTypeForRoleId(RoleId.USERS, DocumentPermissionSetTypeDomainObject.FULL);
        this.assertDocumentsAddedWithPermission(document, oldDocument, testedUser, documentGetter);
        document1002.setDocumentPermissionSetTypeForRoleId(RoleId.USERS, DocumentPermissionSetTypeDomainObject.NONE);
        this.assertDocumentsAddedWithoutPermission(document, oldDocument, testedUser, documentGetter);
        testedUser.addRoleId(RoleId.SUPERADMIN);
        this.assertDocumentsAddedWithPermission(document, oldDocument, testedUser, documentGetter);
        testedUser.removeRoleId(RoleId.SUPERADMIN);
        this.assertDocumentsAddedWithoutPermission(document, oldDocument, testedUser, documentGetter);
        try {
            this.documentMapper.getDocumentSaver().checkDocumentsAddedWithoutPermission(document, oldDocument, testedUser);
            TestDocumentSaver.fail((String)"Expected exception.");
        }
        catch (NoPermissionToAddDocumentToMenuException e) {
            // empty catch block
        }
    }

    private void assertDocumentsAddedWithPermission(TextDocumentDomainObject document, TextDocumentDomainObject oldDocument, UserDomainObject user, DocumentGetter documentGetter) {
        Set documentsAddedWithoutPermission = this.documentSaver.getDocumentsAddedWithoutPermission(document, oldDocument, user, documentGetter);
        this.assertEmpty(documentsAddedWithoutPermission);
    }

    private void assertDocumentsAddedWithoutPermission(TextDocumentDomainObject document, TextDocumentDomainObject oldDocument, UserDomainObject user, DocumentGetter documentGetter) {
        Set documentsAddedWithoutPermission = this.documentSaver.getDocumentsAddedWithoutPermission(document, oldDocument, user, documentGetter);
        this.assertNotEmpty(documentsAddedWithoutPermission);
    }

    private void assertEmpty(Collection collection) {
        TestDocumentSaver.assertTrue((boolean)collection.isEmpty());
    }

    private void assertNotEmpty(Collection collection) {
        TestDocumentSaver.assertFalse((boolean)collection.isEmpty());
    }

    private TextDocumentDomainObject createTextDocument(int documentId) {
        TextDocumentDomainObject newTextDocument = new TextDocumentDomainObject();
        newTextDocument.setId(documentId);
        return newTextDocument;
    }
}

