/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.commands.TransactionDatabaseCommand;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;

public class DocumentPermissionSetMapper {
    private Database database;
    public static final String TABLE_NEW_DOC_PERMISSION_SETS = "new_doc_permission_sets";
    public static final String TABLE_DOC_PERMISSION_SETS = "doc_permission_sets";

    public DocumentPermissionSetMapper(Database database) {
        this.database = database;
    }

    public void saveRestrictedDocumentPermissionSets(DocumentDomainObject document, UserDomainObject user, DocumentDomainObject oldDocument) {
        if (null == oldDocument || user.canDefineRestrictedOneFor(oldDocument)) {
            this.saveRestrictedDocumentPermissionSet(document, document.getPermissionSets().getRestricted1(), false);
            this.saveRestrictedDocumentPermissionSet(document, document.getPermissionSetsForNewDocuments().getRestricted1(), true);
        }
        if (null == oldDocument || user.canDefineRestrictedTwoFor(oldDocument)) {
            this.saveRestrictedDocumentPermissionSet(document, document.getPermissionSets().getRestricted2(), false);
            this.saveRestrictedDocumentPermissionSet(document, document.getPermissionSetsForNewDocuments().getRestricted2(), true);
        }
    }

    void saveRestrictedDocumentPermissionSet(final DocumentDomainObject document, final DocumentPermissionSetDomainObject documentPermissionSet, final boolean forNewDocuments) {
        ArrayList<PermissionPair> permissionPairs = new ArrayList<PermissionPair>(Arrays.asList(new PermissionPair(1, documentPermissionSet.getEditDocumentInformation()), new PermissionPair(4, documentPermissionSet.getEditPermissions())));
        if (document instanceof TextDocumentDomainObject) {
            TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)documentPermissionSet;
            permissionPairs.add(new PermissionPair(65536, textDocumentPermissionSet.getEditTexts()));
            permissionPairs.add(new PermissionPair(131072, textDocumentPermissionSet.getEditImages()));
            permissionPairs.add(new PermissionPair(262144, textDocumentPermissionSet.getEditMenus()));
            permissionPairs.add(new PermissionPair(524288, textDocumentPermissionSet.getEditTemplates()));
            permissionPairs.add(new PermissionPair(0x100000, textDocumentPermissionSet.getEditIncludes()));
        } else {
            permissionPairs.add(new PermissionPair(65536, documentPermissionSet.getEdit()));
        }
        int permissionBits = 0;
        Iterator iterator = permissionPairs.iterator();
        while (iterator.hasNext()) {
            PermissionPair permissionPair = (PermissionPair)iterator.next();
            if (!permissionPair.hasPermission) continue;
            permissionBits |= permissionPair.bit;
        }
        final int permissionBits1 = permissionBits;
        this.database.execute((DatabaseCommand)new TransactionDatabaseCommand(){

            public Object executeInTransaction(DatabaseConnection connection) throws DatabaseException {
                DocumentPermissionSetMapper.this.sqlDeleteFromExtendedPermissionsTable(document, documentPermissionSet, forNewDocuments, connection);
                String tableName = forNewDocuments ? DocumentPermissionSetMapper.TABLE_NEW_DOC_PERMISSION_SETS : DocumentPermissionSetMapper.TABLE_DOC_PERMISSION_SETS;
                connection.executeUpdate("DELETE FROM " + tableName + "\n" + "WHERE meta_id = ?\n" + "AND  set_id = ?", (Object[])new String[]{"" + document.getId(), "" + documentPermissionSet.getType()});
                connection.executeUpdate("INSERT INTO " + tableName + " (meta_id, set_id, permission_id)\n" + "VALUES (?,?,?)", (Object[])new String[]{"" + document.getId(), "" + documentPermissionSet.getType(), "" + permissionBits1});
                return null;
            }
        });
        if (document instanceof TextDocumentDomainObject) {
            TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)documentPermissionSet;
            this.sqlSaveAllowedTemplateGroups(document, textDocumentPermissionSet, forNewDocuments);
            this.sqlSaveAllowedDocumentTypes(document, textDocumentPermissionSet, forNewDocuments);
        }
    }

    private void sqlSaveAllowedTemplateGroups(DocumentDomainObject document, TextDocumentPermissionSetDomainObject textDocumentPermissionSet, boolean forNewDocuments) {
        String table = this.getExtendedPermissionsTable(forNewDocuments);
        Set allowedTemplateGroupIds = textDocumentPermissionSet.getAllowedTemplateGroupIds();
        String sqlInsertAllowedTemplateGroupId = "INSERT INTO " + table + " VALUES(?,?," + 524288 + ",?)";
        Iterator iterator = allowedTemplateGroupIds.iterator();
        while (iterator.hasNext()) {
            Integer allowedTemplateGroupId = (Integer)iterator.next();
            Object[] parameters = new String[]{"" + document.getId(), "" + textDocumentPermissionSet.getType(), "" + allowedTemplateGroupId};
            ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlInsertAllowedTemplateGroupId, parameters))).intValue();
        }
    }

    private void sqlDeleteFromExtendedPermissionsTable(DocumentDomainObject document, DocumentPermissionSetDomainObject documentPermissionSet, boolean forNewDocuments, DatabaseConnection connection) throws DatabaseException {
        String table = this.getExtendedPermissionsTable(forNewDocuments);
        String sqlDelete = "DELETE FROM " + table + " WHERE meta_id = ? AND set_id = ?";
        connection.executeUpdate(sqlDelete, (Object[])new String[]{"" + document.getId(), "" + documentPermissionSet.getType()});
    }

    private void sqlSaveAllowedDocumentTypes(DocumentDomainObject document, TextDocumentPermissionSetDomainObject textDocumentPermissionSet, boolean forNewDocuments) {
        String table = this.getExtendedPermissionsTable(forNewDocuments);
        Set allowedDocumentTypeIds = textDocumentPermissionSet.getAllowedDocumentTypeIds();
        String sqlInsertCreatableDocumentTypeId = "INSERT INTO " + table + " VALUES(?,?," + 8 + ",?)";
        Iterator iterator = allowedDocumentTypeIds.iterator();
        while (iterator.hasNext()) {
            Integer allowedDocumentTypeId = (Integer)iterator.next();
            Object[] parameters = new String[]{"" + document.getId(), "" + textDocumentPermissionSet.getType(), "" + allowedDocumentTypeId};
            ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlInsertCreatableDocumentTypeId, parameters))).intValue();
        }
    }

    private String getExtendedPermissionsTable(boolean forNewDocuments) {
        String table = "doc_permission_sets_ex";
        if (forNewDocuments) {
            table = "new_" + table;
        }
        return table;
    }

    private static class PermissionPair {
        int bit;
        boolean hasPermission;

        private PermissionPair(int bit, boolean hasPermission) {
            this.hasPermission = hasPermission;
            this.bit = bit;
        }
    }
}

