/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.InsertIntoTableDatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.commands.UpdateTableWhereColumnEqualsDatabaseCommand;
import com.imcode.db.handlers.ObjectArrayHandler;
import com.imcode.db.handlers.RowTransformer;
import com.imcode.db.handlers.SingleObjectHandler;
import com.imcode.imcms.api.CategoryAlreadyExistsException;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.CategoryTypeDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.MaxCategoryDomainObjectsOfTypeExceededException;
import imcode.util.Utility;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.dbutils.ResultSetHandler;

public class CategoryMapper {
    private Database database;
    private static final int UNLIMITED_MAX_CATEGORY_CHOICES = 0;
    private static final String SQL__CATEGORY__COLUMNS = "categories.category_id, categories.name, categories.description, categories.image";
    public static final String SQL__CATEGORY_TYPE__COLUMNS = "category_types.category_type_id, category_types.name, category_types.max_choices, category_types.inherited";
    public static final String SQL_GET_ALL_CATEGORIES_OF_TYPE = "SELECT categories.category_id, categories.name, categories.description, categories.image\nFROM categories\nJOIN category_types ON categories.category_type_id = category_types.category_type_id\nWHERE categories.category_type_id = ?\nORDER BY categories.name";
    public static final String SQL__GET_CATEGORY_BY_NAME_AND_CATEGORY_TYPE_ID = "SELECT categories.category_id, categories.name, categories.description, categories.image, category_types.category_type_id, category_types.name, category_types.max_choices, category_types.inherited\nFROM categories\nJOIN category_types\nON categories.category_type_id = category_types.category_type_id\nWHERE categories.name = ?\nAND category_types.category_type_id = ?";
    private static final String SQL__GET_ALL_CATEGORY_TYPES = "SELECT category_types.category_type_id, category_types.name, category_types.max_choices, category_types.inherited FROM category_types ORDER BY name";
    private static final String SQL__GET_CATEGORY_TYPE_BY_NAME = "SELECT category_types.category_type_id, category_types.name, category_types.max_choices, category_types.inherited\nFROM category_types\nWHERE category_types.name = ?";
    private static final String SQL__GET_CATEGORY_TYPE_BY_ID = "select category_types.category_type_id, category_types.name, category_types.max_choices, category_types.inherited from category_types where category_type_id = ? ";
    private static final String SQL__GET_CATEGORY_BY_ID = "SELECT categories.category_id, categories.name, categories.description, categories.image, category_types.category_type_id, category_types.name, category_types.max_choices, category_types.inherited\nFROM categories\nJOIN category_types ON categories.category_type_id = category_types.category_type_id\nWHERE categories.category_id = ?";
    static final String SQL__GET_DOCUMENT_CATEGORIES = "SELECT meta_id, category_id FROM document_categories WHERE meta_id ";
    private static final SingleObjectHandler SINGLE_CATEGORY_TYPE_HANDLER = new SingleObjectHandler((RowTransformer)new CategoryTypeFromRowFactory());
    private static final SingleObjectHandler SINGLE_CATEGORY_HANDLER = new SingleObjectHandler((RowTransformer)new CategoryFromRowFactory());
    private static final ObjectArrayHandler CATEGORY_TYPE_ARRAY_HANDLER = new ObjectArrayHandler((RowTransformer)new CategoryTypeFromRowFactory());
    static /* synthetic */ Class class$imcode$server$document$CategoryTypeDomainObject;
    static /* synthetic */ Class class$imcode$server$document$CategoryDomainObject;

    public CategoryMapper(Database database) {
        this.database = database;
    }

    public CategoryDomainObject[] getAllCategoriesOfType(CategoryTypeDomainObject categoryType) {
        String sqlQuery = SQL_GET_ALL_CATEGORIES_OF_TYPE;
        Object[] parameters = new String[]{"" + categoryType.getId()};
        String[][] sqlResult = (String[][])this.database.execute((DatabaseCommand)new SqlQueryCommand(sqlQuery, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
        CategoryDomainObject[] categoryDomainObjects = new CategoryDomainObject[sqlResult.length];
        for (int i = 0; i < sqlResult.length; ++i) {
            int categoryId = Integer.parseInt(sqlResult[i][0]);
            String categoryName = sqlResult[i][1];
            String categoryDescription = sqlResult[i][2];
            String categoryImage = sqlResult[i][3];
            categoryDomainObjects[i] = new CategoryDomainObject(categoryId, categoryName, categoryDescription, categoryImage, categoryType);
        }
        return categoryDomainObjects;
    }

    public boolean isUniqueCategoryTypeName(String categoryTypeName) {
        CategoryTypeDomainObject[] categoryTypes = this.getAllCategoryTypes();
        for (int i = 0; i < categoryTypes.length; ++i) {
            CategoryTypeDomainObject categoryType = categoryTypes[i];
            if (!categoryType.getName().equalsIgnoreCase(categoryTypeName)) continue;
            return false;
        }
        return true;
    }

    public CategoryTypeDomainObject[] getAllCategoryTypes() {
        Object[] parameters = new String[]{};
        return (CategoryTypeDomainObject[])this.database.execute((DatabaseCommand)new SqlQueryCommand(SQL__GET_ALL_CATEGORY_TYPES, parameters, (ResultSetHandler)CATEGORY_TYPE_ARRAY_HANDLER));
    }

    public CategoryDomainObject getCategoryByTypeAndName(CategoryTypeDomainObject categoryType, String categoryName) {
        Object[] parameters = new String[]{categoryName, "" + categoryType.getId()};
        return (CategoryDomainObject)this.database.execute((DatabaseCommand)new SqlQueryCommand(SQL__GET_CATEGORY_BY_NAME_AND_CATEGORY_TYPE_ID, parameters, (ResultSetHandler)SINGLE_CATEGORY_HANDLER));
    }

    public CategoryDomainObject getCategoryById(int categoryId) {
        Object[] parameters = new String[]{"" + categoryId};
        return (CategoryDomainObject)this.database.execute((DatabaseCommand)new SqlQueryCommand(SQL__GET_CATEGORY_BY_ID, parameters, (ResultSetHandler)SINGLE_CATEGORY_HANDLER));
    }

    public CategoryTypeDomainObject getCategoryTypeByName(String categoryTypeName) {
        Object[] parameters = new String[]{categoryTypeName};
        return (CategoryTypeDomainObject)this.database.execute((DatabaseCommand)new SqlQueryCommand(SQL__GET_CATEGORY_TYPE_BY_NAME, parameters, (ResultSetHandler)SINGLE_CATEGORY_TYPE_HANDLER));
    }

    public CategoryTypeDomainObject getCategoryTypeById(int categoryTypeId) {
        Object[] parameters = new String[]{"" + categoryTypeId};
        return (CategoryTypeDomainObject)this.database.execute((DatabaseCommand)new SqlQueryCommand(SQL__GET_CATEGORY_TYPE_BY_ID, parameters, (ResultSetHandler)SINGLE_CATEGORY_TYPE_HANDLER));
    }

    public void deleteCategoryTypeFromDb(CategoryTypeDomainObject categoryType) {
        String sqlstr = "delete from category_types where category_type_id = ?";
        Object[] params = new String[]{categoryType.getId() + ""};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlstr, params))).intValue();
    }

    public CategoryTypeDomainObject addCategoryTypeToDb(CategoryTypeDomainObject categoryType) {
        Number newId = (Number)this.database.execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("category_types", this.getColumnNamesAndValuesForCategoryType(categoryType)));
        return this.getCategoryTypeById(newId.intValue());
    }

    private Object[][] getColumnNamesAndValuesForCategoryType(CategoryTypeDomainObject categoryType) {
        return new Object[][]{{"name", categoryType.getName()}, {"max_choices", new Integer(categoryType.getMaxChoices())}, {"inherited", new Integer(categoryType.isInherited() ? 1 : 0)}};
    }

    public void updateCategoryType(CategoryTypeDomainObject categoryType) {
        this.database.execute((DatabaseCommand)new UpdateTableWhereColumnEqualsDatabaseCommand("category_types", "category_type_id", (Object)new Integer(categoryType.getId()), this.getColumnNamesAndValuesForCategoryType(categoryType)));
    }

    public CategoryDomainObject addCategory(CategoryDomainObject category) throws CategoryAlreadyExistsException {
        Number newId = (Number)this.database.execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("categories", this.getColumnNamesAndValuesForCategory(category)));
        int categoryId = newId.intValue();
        category.setId(categoryId);
        return this.getCategoryById(categoryId);
    }

    private Object[][] getColumnNamesAndValuesForCategory(CategoryDomainObject category) {
        return new Object[][]{{"category_type_id", new Integer(category.getType().getId())}, {"name", category.getName()}, {"description", category.getDescription()}, {"image", category.getImageUrl()}};
    }

    public void updateCategory(CategoryDomainObject category) {
        this.database.execute((DatabaseCommand)new UpdateTableWhereColumnEqualsDatabaseCommand("categories", "category_id", (Object)new Integer(category.getId()), this.getColumnNamesAndValuesForCategory(category)));
    }

    public void deleteCategoryFromDb(CategoryDomainObject category) {
        String sqlstr = "delete from categories where category_id = ?";
        Object[] params = new String[]{category.getId() + ""};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlstr, params))).intValue();
    }

    void updateDocumentCategories(DocumentDomainObject document) {
        Set categoryIds = document.getCategoryIds();
        this.removeAllCategoriesFromDocument(document);
        Iterator iterator = categoryIds.iterator();
        while (iterator.hasNext()) {
            Integer categoryId = (Integer)iterator.next();
            this.addCategoryToDocument(categoryId, document);
        }
    }

    private void addCategoryToDocument(int categoryId, DocumentDomainObject document) {
        Object[] params = new String[]{"" + document.getId(), "" + categoryId};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand("INSERT INTO document_categories (meta_id, category_id) VALUES(?,?)", params))).intValue();
    }

    public String[] getAllDocumentsOfOneCategory(CategoryDomainObject category) {
        String sqlstr = "select meta_id from document_categories where category_id = ? ";
        Object[] params = new String[]{category.getId() + ""};
        return (String[])this.database.execute((DatabaseCommand)new SqlQueryCommand(sqlstr, params, Utility.STRING_ARRAY_HANDLER));
    }

    private void removeAllCategoriesFromDocument(DocumentDomainObject document) {
        Object[] params = new String[]{"" + document.getId()};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand("DELETE FROM document_categories WHERE meta_id = ?", params))).intValue();
    }

    public void deleteOneCategoryFromDocument(DocumentDomainObject document, CategoryDomainObject category) {
        Object[] params = new String[]{document.getId() + "", category.getId() + ""};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand("DELETE FROM document_categories WHERE meta_id = ? and category_id = ?", params))).intValue();
    }

    void checkMaxDocumentCategoriesOfType(DocumentDomainObject document) throws MaxCategoryDomainObjectsOfTypeExceededException {
        CategoryTypeDomainObject[] categoryTypes = this.getAllCategoryTypes();
        for (int i = 0; i < categoryTypes.length; ++i) {
            CategoryTypeDomainObject categoryType = categoryTypes[i];
            int maxChoices = categoryType.getMaxChoices();
            Set documentCategoriesOfType = this.getCategoriesOfType(categoryType, document.getCategoryIds());
            if (0 == maxChoices || documentCategoriesOfType.size() <= maxChoices) continue;
            throw new MaxCategoryDomainObjectsOfTypeExceededException("Document may have at most " + maxChoices + " categories of type '" + categoryType.getName() + "'");
        }
    }

    public void saveCategory(CategoryDomainObject category) throws CategoryAlreadyExistsException {
        if (0 == category.getId()) {
            CategoryDomainObject categoryInDb = this.getCategoryByTypeAndName(category.getType(), category.getName());
            if (null != categoryInDb) {
                throw new CategoryAlreadyExistsException("A category with name \"" + category.getName() + "\" already exists in category type \"" + category.getType().getName() + "\".");
            }
            this.addCategory(category);
        } else {
            this.updateCategory(category);
        }
    }

    public Set getCategories(Collection categoryIds) {
        HashSet<CategoryDomainObject> categories = new HashSet<CategoryDomainObject>();
        Iterator iterator = categoryIds.iterator();
        while (iterator.hasNext()) {
            Integer categoryId = (Integer)iterator.next();
            CategoryDomainObject category = this.getCategoryById(categoryId);
            if (null == category) continue;
            categories.add(category);
        }
        return categories;
    }

    public Set getCategoriesOfType(CategoryTypeDomainObject categoryType, Set categoryIds) {
        Set categories = this.getCategories(categoryIds);
        HashSet<CategoryDomainObject> categoriesOfType = new HashSet<CategoryDomainObject>();
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            CategoryDomainObject category = (CategoryDomainObject)iterator.next();
            if (!categoryType.equals(category.getType())) continue;
            categoriesOfType.add(category);
        }
        return categoriesOfType;
    }

    private static class CategoryFromRowFactory
    implements RowTransformer {
        private CategoryFromRowFactory() {
        }

        public Object createObjectFromResultSetRow(ResultSet resultSet) throws SQLException {
            int categoryId = resultSet.getInt(1);
            String categoryName = resultSet.getString(2);
            String categoryDescription = resultSet.getString(3);
            String categoryImage = resultSet.getString(4);
            CategoryTypeDomainObject categoryType = (CategoryTypeDomainObject)new CategoryTypeFromRowFactory(4).createObjectFromResultSetRow(resultSet);
            return new CategoryDomainObject(categoryId, categoryName, categoryDescription, categoryImage, categoryType);
        }

        public Class getClassOfCreatedObjects() {
            return class$imcode$server$document$CategoryDomainObject == null ? (class$imcode$server$document$CategoryDomainObject = CategoryMapper.class$("imcode.server.document.CategoryDomainObject")) : class$imcode$server$document$CategoryDomainObject;
        }
    }

    private static class CategoryTypeFromRowFactory
    implements RowTransformer {
        private final int offset;

        CategoryTypeFromRowFactory() {
            this(0);
        }

        CategoryTypeFromRowFactory(int offset) {
            this.offset = offset;
        }

        public Object createObjectFromResultSetRow(ResultSet resultSet) throws SQLException {
            int id = resultSet.getInt(this.offset + 1);
            String name = resultSet.getString(this.offset + 2);
            int maxChoices = resultSet.getInt(this.offset + 3);
            boolean inherited = 0 != resultSet.getInt(this.offset + 4);
            return new CategoryTypeDomainObject(id, name, maxChoices, inherited);
        }

        public Class getClassOfCreatedObjects() {
            return class$imcode$server$document$CategoryTypeDomainObject == null ? (class$imcode$server$document$CategoryTypeDomainObject = CategoryMapper.class$("imcode.server.document.CategoryTypeDomainObject")) : class$imcode$server$document$CategoryTypeDomainObject;
        }
    }
}

