/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.SecurityChecker;
import com.imcode.imcms.api.Template;
import com.imcode.imcms.api.TemplateGroup;
import com.imcode.imcms.api.TextDocument;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.document.TemplateMapper;
import imcode.server.user.UserDomainObject;
import java.util.ArrayList;
import java.util.Arrays;

public class TemplateService {
    private ContentManagementSystem contentManagementSystem;

    TemplateService(ContentManagementSystem contentManagementSystem) {
        this.contentManagementSystem = contentManagementSystem;
    }

    public TemplateGroup[] getTemplatesGroups(TextDocument textDocument) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(textDocument);
        UserDomainObject user = this.contentManagementSystem.getCurrentUser().getInternal();
        TemplateGroupDomainObject[] internalTemplates = this.getTemplateMapper().getAllTemplateGroupsAvailableForUserOnDocument(user, textDocument.getId());
        return this.createTemplateGroupArray(internalTemplates);
    }

    private TemplateMapper getTemplateMapper() {
        return this.contentManagementSystem.getInternal().getTemplateMapper();
    }

    private SecurityChecker getSecurityChecker() {
        return this.contentManagementSystem.getSecurityChecker();
    }

    public TemplateGroup[] getAllTemplateGroups() {
        TemplateGroupDomainObject[] templateGroupDomainObject = this.getTemplateMapper().getAllTemplateGroups();
        return this.createTemplateGroupArray(templateGroupDomainObject);
    }

    private TemplateGroup[] createTemplateGroupArray(TemplateGroupDomainObject[] internalTemplates) {
        TemplateGroup[] result = new TemplateGroup[internalTemplates.length];
        for (int i = 0; i < internalTemplates.length; ++i) {
            result[i] = new TemplateGroup(internalTemplates[i]);
        }
        return result;
    }

    public Template[] getTemplates(TemplateGroup templateGroup) throws NoPermissionException {
        TemplateDomainObject[] templates = this.getTemplateMapper().getTemplatesInGroup(templateGroup.getInternal());
        Template[] result = new Template[templates.length];
        for (int i = 0; i < templates.length; ++i) {
            TemplateDomainObject domainObject = templates[i];
            result[i] = new Template(domainObject);
        }
        return result;
    }

    public Template[] getPossibleTemplates(TextDocument textDocument) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(textDocument);
        TemplateGroup[] groups = this.getTemplatesGroups(textDocument);
        ArrayList<Template> temp = new ArrayList<Template>();
        for (int i = 0; i < groups.length; ++i) {
            Template[] templates = this.getTemplates(groups[i]);
            temp.addAll(Arrays.asList(templates));
        }
        Template[] result = temp.toArray(new Template[temp.size()]);
        return result;
    }

    public Template getTemplate(String templateName) {
        TemplateDomainObject template = this.getTemplateMapper().getTemplateByName(templateName);
        return null != template ? new Template(template) : null;
    }

    public Template getTemplateById(int templateId) {
        TemplateDomainObject template = this.getTemplateMapper().getTemplateById(templateId);
        return null != template ? new Template(template) : null;
    }

    public TemplateGroup getTemplateGroupById(int templateGroupId) {
        TemplateGroupDomainObject template = this.getTemplateMapper().getTemplateGroupById(templateGroupId);
        return null != template ? new TemplateGroup(template) : null;
    }
}

