/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import imcode.util.FrequencyOrderedBag;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.AbstractMapDecorator;

public class LfuMap
extends AbstractMapDecorator {
    private final FrequencyOrderedBag requestsInMap = new FrequencyOrderedBag();
    private final FrequencyOrderedBag requestsOutsideMap = new FrequencyOrderedBag();
    private final int maxSize;

    public LfuMap(Map map, int maxSize) {
        super(map);
        this.maxSize = maxSize;
    }

    public Object get(Object key) {
        Object result = this.map.get(key);
        if (null != result) {
            this.requestsInMap.add(key);
        } else {
            this.requestsOutsideMap.add(key);
        }
        return result;
    }

    public Object put(Object key, Object value) {
        if (!this.map.containsKey(key) && this.map.size() == this.maxSize && this.requestsInMap.size() >= this.maxSize) {
            int lfuKeyFrequency;
            List list = this.requestsInMap.asList();
            Object lfuKey = list.get(this.maxSize - 1);
            int keyFrequency = this.requestsOutsideMap.getFrequency(key);
            if (keyFrequency > (lfuKeyFrequency = this.requestsInMap.getFrequency(lfuKey))) {
                this.remove(lfuKey);
            }
        }
        if (this.map.size() < this.maxSize) {
            Object result = this.map.put(key, value);
            if (null == result) {
                int frequency = this.requestsOutsideMap.remove(key);
                this.requestsInMap.add(key, frequency);
            }
            return result;
        }
        return null;
    }

    public Object remove(Object key) {
        int frequency = this.requestsInMap.remove(key);
        this.requestsOutsideMap.add(key, frequency);
        return this.map.remove(key);
    }
}

