/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import com.imcode.imcms.mapping.MapDocumentGetter;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.GetterDocumentReference;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.varia.NullAppender;

public class TestMenuDomainObject
extends TestCase {
    private MenuDomainObject menu;
    private UserDomainObject user;

    protected void setUp() throws Exception {
        super.setUp();
        BasicConfigurator.configure((Appender)new NullAppender());
        this.user = new UserDomainObject();
        this.user.addRoleId(RoleId.SUPERADMIN);
        this.menu = new MenuDomainObject();
        MapDocumentGetter documentGetter = new MapDocumentGetter(new DocumentDomainObject[]{new TextDocumentDomainObject(1001), new TextDocumentDomainObject(1002), new TextDocumentDomainObject(1003)});
        this.menu.addMenuItem(new MenuItemDomainObject(new GetterDocumentReference(1001, documentGetter)));
        this.menu.addMenuItem(new MenuItemDomainObject(new GetterDocumentReference(1002, documentGetter)));
        this.menu.addMenuItem(new MenuItemDomainObject(new GetterDocumentReference(1003, documentGetter)));
        this.menu.addMenuItem(new MenuItemDomainObject(new GetterDocumentReference(1004, documentGetter)));
    }

    public void testGetMenuItems() {
        MenuItemDomainObject[] menuItems = this.menu.getMenuItems();
        TestMenuDomainObject.assertEquals((int)3, (int)menuItems.length);
    }

    public void testGetMenuItemsVisibleToUser() {
        List menuItemsVisibleToUser = this.menu.getMenuItemsVisibleToUser(this.user);
        TestMenuDomainObject.assertEquals((int)3, (int)menuItemsVisibleToUser.size());
    }

    public void testGetMenuItemsUnsorted() throws Exception {
        Set menuItems = this.menu.getMenuItemsUnsorted();
        TestMenuDomainObject.assertEquals((int)3, (int)menuItems.size());
    }
}

