/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.index;

import imcode.server.document.index.StreamTextsExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

class MicrosoftExcelTextExtractor
implements StreamTextsExtractor {
    MicrosoftExcelTextExtractor() {
    }

    public String[] extractTexts(InputStream in) throws IOException {
        ArrayList<String> texts = new ArrayList<String>();
        HSSFWorkbook workbook = new HSSFWorkbook(in);
        int sheetCount = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetCount; ++i) {
            HSSFSheet sheet = workbook.getSheetAt(i);
            Iterator rowIterator = sheet.rowIterator();
            while (rowIterator.hasNext()) {
                HSSFRow row = (HSSFRow)rowIterator.next();
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    HSSFCell cell = (HSSFCell)cellIterator.next();
                    int cellType = cell.getCellType();
                    if (cellType != 1) continue;
                    texts.add(cell.getStringCellValue());
                }
            }
        }
        return texts.toArray(new String[texts.size()]);
    }
}

