/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.index;

import com.imcode.imcms.mapping.CategoryMapper;
import com.imcode.imcms.mapping.DocumentMapper;
import imcode.server.Imcms;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.CategoryTypeDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.SectionDomainObject;
import imcode.server.document.index.IndexDocumentAdaptingVisitor;
import imcode.util.Utility;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class IndexDocumentFactory {
    private CategoryMapper categoryMapper;
    private static final Logger log = Logger.getLogger((String)IndexDocumentFactory.class.getName());

    public IndexDocumentFactory(CategoryMapper categoryMapper) {
        this.categoryMapper = categoryMapper;
    }

    public Document createIndexDocument(DocumentDomainObject document) {
        log.trace((Object)("Indexing document " + document.getId()));
        Document indexDocument = new Document();
        int documentId = document.getId();
        indexDocument.add(Field.Keyword((String)"meta_id", (String)("" + documentId)));
        indexDocument.add(Field.UnStored((String)"meta_headline", (String)document.getHeadline()));
        indexDocument.add(IndexDocumentFactory.unStoredKeyword("meta_headline_keyword", document.getHeadline()));
        indexDocument.add(Field.UnStored((String)"meta_text", (String)document.getMenuText()));
        indexDocument.add(IndexDocumentFactory.unStoredKeyword("doc_type_id", "" + document.getDocumentTypeId()));
        indexDocument.add(IndexDocumentFactory.unStoredKeyword("creator_id", "" + document.getCreatorId()));
        if (null != document.getPublisherId()) {
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("publisher_id", "" + document.getPublisherId()));
        }
        Set sectionIds = document.getSectionIds();
        Iterator iterator = sectionIds.iterator();
        while (iterator.hasNext()) {
            Integer sectionId = (Integer)iterator.next();
            SectionDomainObject section = Imcms.getServices().getDocumentMapper().getSectionById(sectionId);
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("section", section.getName()));
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("section_id", sectionId.toString()));
        }
        this.addDateFieldToIndexDocument(documentId, indexDocument, "created_datetime", document.getCreatedDatetime());
        this.addDateFieldToIndexDocument(documentId, indexDocument, "modified_datetime", document.getModifiedDatetime());
        this.addDateFieldToIndexDocument(documentId, indexDocument, "activated_datetime", document.getPublicationStartDatetime());
        this.addDateFieldToIndexDocument(documentId, indexDocument, "publication_start_datetime", document.getPublicationStartDatetime());
        this.addDateFieldToIndexDocument(documentId, indexDocument, "publication_end_datetime", document.getPublicationEndDatetime());
        this.addDateFieldToIndexDocument(documentId, indexDocument, "archived_datetime", document.getArchivedDatetime());
        indexDocument.add(IndexDocumentFactory.unStoredKeyword("status", "" + document.getPublicationStatus()));
        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
        try {
            document.accept(new IndexDocumentAdaptingVisitor(indexDocument));
        }
        catch (RuntimeException re) {
            log.error((Object)("Error indexing document-type-specific data of document " + document.getId()), (Throwable)re);
        }
        Set categories = this.categoryMapper.getCategories(document.getCategoryIds());
        Iterator iterator2 = categories.iterator();
        while (iterator2.hasNext()) {
            CategoryDomainObject category = (CategoryDomainObject)iterator2.next();
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("category", category.getName()));
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("category_id", "" + category.getId()));
            CategoryTypeDomainObject categoryType = category.getType();
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("category_type", categoryType.getName()));
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("category_type_id", "" + categoryType.getId()));
        }
        Set documentKeywords = document.getKeywords();
        Iterator iterator3 = documentKeywords.iterator();
        while (iterator3.hasNext()) {
            String documentKeyword = (String)iterator3.next();
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("keyword", documentKeyword));
        }
        String[][] parentDocumentAndMenuIds = documentMapper.getParentDocumentAndMenuIdsForDocument(document);
        for (int i = 0; i < parentDocumentAndMenuIds.length; ++i) {
            String parentId = parentDocumentAndMenuIds[i][0];
            String menuId = parentDocumentAndMenuIds[i][1];
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("parent_id", parentId));
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("parent_menu_id", parentId + "_" + menuId));
        }
        return indexDocument;
    }

    private void addDateFieldToIndexDocument(int documentId, Document indexDocument, String fieldName, Date date) {
        if (null != date) {
            try {
                indexDocument.add(IndexDocumentFactory.unStoredKeyword(fieldName, date));
                return;
            }
            catch (RuntimeException re) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                log.warn((Object)("Failed to index datetime '" + dateFormat.format(date) + "' in field '" + fieldName + "' of document " + documentId), (Throwable)re);
            }
        }
        indexDocument.add(IndexDocumentFactory.unStoredKeyword(fieldName, ""));
    }

    static Field unStoredKeyword(String fieldName, String fieldValue) {
        return new Field(fieldName, fieldValue.toLowerCase(), false, true, false);
    }

    private static Field unStoredKeyword(String fieldName, Date fieldValue) {
        Date truncatedDate = Utility.truncateDateToMinutePrecision(fieldValue);
        return new Field(fieldName, DateField.dateToString((Date)truncatedDate), false, true, false);
    }
}

