/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.document.DocumentPermission;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TextDocumentPermissionSetDomainObject
extends DocumentPermissionSetDomainObject {
    private HashSet allowedTemplateGroupIds = new HashSet();
    private HashSet allowedDocumentTypeIds = new HashSet();
    public static final DocumentPermission EDIT_TEXTS = new DocumentPermission("editTexts");
    public static final DocumentPermission EDIT_MENUS = new DocumentPermission("editMenus");
    public static final DocumentPermission EDIT_TEMPLATE = new DocumentPermission("editTemplates");
    public static final DocumentPermission EDIT_INCLUDES = new DocumentPermission("editIncludes");
    public static final DocumentPermission EDIT_IMAGES = new DocumentPermission("editImages");
    public static final int EDIT_TEXT_DOCUMENT_TEXTS_PERMISSION_ID = 65536;
    public static final int EDIT_TEXT_DOCUMENT_IMAGES_PERMISSION_ID = 131072;
    public static final int EDIT_TEXT_DOCUMENT_MENUS_PERMISSION_ID = 262144;
    public static final int EDIT_TEXT_DOCUMENT_TEMPLATE_PERMISSION_ID = 524288;
    public static final int EDIT_TEXT_DOCUMENT_INCLUDES_PERMISSION_ID = 0x100000;

    public TextDocumentPermissionSetDomainObject(DocumentPermissionSetTypeDomainObject typeId) {
        super(typeId);
    }

    public boolean getEditTexts() {
        return this.hasPermission(EDIT_TEXTS);
    }

    public void setEditTexts(boolean editTexts) {
        this.setPermission(EDIT_TEXTS, editTexts);
    }

    public boolean getEditMenus() {
        return this.hasPermission(EDIT_MENUS);
    }

    public void setEditMenus(boolean editMenus) {
        this.setPermission(EDIT_MENUS, editMenus);
    }

    public boolean getEditTemplates() {
        return this.hasPermission(EDIT_TEMPLATE);
    }

    public void setEditTemplates(boolean editTemplates) {
        this.setPermission(EDIT_TEMPLATE, editTemplates);
    }

    public boolean getEditIncludes() {
        return this.hasPermission(EDIT_INCLUDES);
    }

    public void setEditIncludes(boolean editIncludes) {
        this.setPermission(EDIT_INCLUDES, editIncludes);
    }

    public boolean getEditImages() {
        return this.hasPermission(EDIT_IMAGES);
    }

    public void setEditImages(boolean editImages) {
        this.setPermission(EDIT_IMAGES, editImages);
    }

    public void setFromBits(int permissionBits) {
        this.setEditDocumentInformation(0 != (permissionBits & 1));
        this.setEditPermissions(0 != (permissionBits & 4));
        this.setEdit(0 != (permissionBits & 0x10000));
        this.setEditTexts(0 != (permissionBits & 0x10000));
        this.setEditImages(0 != (permissionBits & 0x20000));
        this.setEditMenus(0 != (permissionBits & 0x40000));
        this.setEditIncludes(0 != (permissionBits & 0x100000));
        this.setEditTemplates(0 != (permissionBits & 0x80000));
    }

    public void setAllowedTemplateGroupIds(Set allowedTemplateGroupIds) {
        this.allowedTemplateGroupIds = new HashSet(allowedTemplateGroupIds);
    }

    public Set getAllowedTemplateGroupIds() {
        return Collections.unmodifiableSet(this.allowedTemplateGroupIds);
    }

    public void setAllowedDocumentTypeIds(Set allowedDocumentTypeIds) {
        this.allowedDocumentTypeIds = new HashSet(allowedDocumentTypeIds);
    }

    public Set getAllowedDocumentTypeIds() {
        return Collections.unmodifiableSet(this.allowedDocumentTypeIds);
    }

    public void addAllowedTemplateGroupId(int templateGroupId) {
        this.allowedTemplateGroupIds.add(new Integer(templateGroupId));
    }

    public void addAllowedDocumentTypeId(int documentTypeId) {
        this.allowedDocumentTypeIds.add(new Integer(documentTypeId));
    }

    protected Object clone() throws CloneNotSupportedException {
        TextDocumentPermissionSetDomainObject clone = (TextDocumentPermissionSetDomainObject)super.clone();
        clone.allowedDocumentTypeIds = (HashSet)this.allowedDocumentTypeIds.clone();
        clone.allowedTemplateGroupIds = (HashSet)this.allowedTemplateGroupIds.clone();
        return clone;
    }
}

