/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.document.DocumentVisitor;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class BrowserDocumentDomainObject
extends DocumentDomainObject {
    private Map browserDocumentIdMap = MapUtils.typedMap(new HashMap(), (Class)Browser.class, (Class)Integer.class);

    public Map getBrowserDocumentIdMap() {
        return Collections.unmodifiableMap(this.browserDocumentIdMap);
    }

    public DocumentTypeDomainObject getDocumentType() {
        return DocumentTypeDomainObject.BROWSER;
    }

    public void accept(DocumentVisitor documentVisitor) {
        documentVisitor.visitBrowserDocument(this);
    }

    public void setBrowserDocumentId(Browser browser, int documentId) {
        this.browserDocumentIdMap.put(browser, new Integer(documentId));
    }

    public void setBrowserDocuments(Map browserDocuments) {
        this.browserDocumentIdMap.clear();
        this.browserDocumentIdMap.putAll(browserDocuments);
    }

    public static class Browser
    implements Comparable,
    Serializable {
        public static final Browser DEFAULT = new Browser(0, "", 0);
        private int id;
        private String name;
        private int specificity;

        public Browser(int id, String name, int specificity) {
            this.id = id;
            this.name = name;
            this.specificity = specificity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Browser)) {
                return false;
            }
            Browser browser = (Browser)o;
            return this.id == browser.id;
        }

        public int hashCode() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public int compareTo(Object o) {
            Browser browser = (Browser)o;
            int comparison = browser.specificity - this.specificity;
            if (0 == comparison) {
                comparison = this.name.compareTo(browser.name);
            }
            return comparison;
        }
    }
}

