/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.db.StringArrayArrayResultSetHandler;
import com.imcode.imcms.servlet.superadmin.AdminRoles;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.Utility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ClassUtils;
import org.apache.log4j.Logger;

public class AdminIpAccess
extends HttpServlet {
    private static final Logger log = Logger.getLogger((Class)AdminIpAccess.class);
    private static final String HTML_TEMPLATE = "AdminIpAccess.htm";
    private static final String HTML_IP_SNIPPET = "AdminIpAccessList.htm";
    private static final String ADD_IP_TEMPLATE = "AdminIpAccess_Add.htm";
    private static final String WARN_DEL_IP_TEMPLATE = "AdminIpAccess_Delete2.htm";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        Object[] parameters = new String[]{};
        String[][] multi = (String[][])imcref.getProcedureExecutor().executeProcedure("IPAccessesGetAll", parameters, new StringArrayArrayResultSetHandler());
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("IP_ACCESS_ID");
        tags.add("USER_ID");
        tags.add("LOGIN_NAME");
        tags.add("IP_START");
        tags.add("IP_END");
        String recs = "";
        int nbrOfRows = multi.length;
        for (int counter = 0; counter < nbrOfRows; ++counter) {
            ArrayList<String> aRecV = new ArrayList<String>(Arrays.asList(multi[counter]));
            HashMap<Object, Object> vmRec = new HashMap<Object, Object>();
            aRecV.set(3, Utility.ipLongToString(Long.parseLong((String)aRecV.get(3))));
            aRecV.set(4, Utility.ipLongToString(Long.parseLong((String)aRecV.get(4))));
            for (int i = 0; i < tags.size(); ++i) {
                vmRec.put(tags.get(i), aRecV.get(i));
            }
            vmRec.put("RECORD_COUNTER", "" + counter);
            recs = recs + AdminRoles.createHtml(req, vmRec, HTML_IP_SNIPPET);
        }
        HashMap<String, String> vm = new HashMap<String, String>();
        vm.put("ALL_IP_ACCESSES", recs);
        AdminRoles.sendHtml(req, res, vm, HTML_TEMPLATE);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            AdminIpAccess.printNonAdminError(imcref, user, req, res, ((Object)((Object)this)).getClass());
        } else if (req.getParameter("ADD_IP_ACCESS") != null) {
            String usersOption = Html.createUsersOptionList(imcref);
            HashMap<String, String> vm = new HashMap<String, String>();
            vm.put("USERS_LIST", usersOption);
            AdminRoles.sendHtml(req, res, vm, ADD_IP_TEMPLATE);
        } else if (req.getParameter("CANCEL_ADD_IP") != null || req.getParameter("IP_CANCEL_DELETE") != null) {
            res.sendRedirect("AdminIpAccess?action=start");
        } else if (req.getParameter("ADD_NEW_IP_ACCESS") != null) {
            log.debug((Object)"Now's ADD_IP_ACCESS running");
            Properties params = this.getAddParameters(req);
            params = this.validateParameters(params, req, res, imcref, user);
            if (params == null) {
                return;
            }
            Object[] parameters = new String[]{params.getProperty("USER_ID"), params.getProperty("IP_START"), params.getProperty("IP_END")};
            imcref.getProcedureExecutor().executeUpdateProcedure("IPAccessAdd", parameters);
            res.sendRedirect("AdminIpAccess?action=start");
        } else if (req.getParameter("RESAVE_IP_ACCESS") != null) {
            String[] reSavesIds = this.getEditedIpAccesses(req);
            if (reSavesIds != null) {
                for (int i = 0; i < reSavesIds.length; ++i) {
                    log.debug((Object)("ResaveId: " + reSavesIds[i]));
                    String tmpId = reSavesIds[i];
                    String ipAccessId = req.getParameter("IP_ACCESS_ID_" + tmpId);
                    String ipUserId = req.getParameter("IP_USER_ID_" + tmpId);
                    String ipStart = req.getParameter("IP_START_" + tmpId);
                    String ipEnd = req.getParameter("IP_END_" + tmpId);
                    long ipStartInt = Utility.ipStringToLong(ipStart);
                    long ipEndInt = Utility.ipStringToLong(ipEnd);
                    Object[] parameters = new String[]{ipAccessId, ipUserId, "" + ipStartInt, "" + ipEndInt};
                    imcref.getProcedureExecutor().executeUpdateProcedure("IPAccessUpdate", parameters);
                }
            }
            this.doGet(req, res);
        } else if (req.getParameter("IP_WARN_DELETE") != null) {
            HttpSession session = req.getSession(false);
            if (session != null) {
                Enumeration enumNames = req.getParameterNames();
                while (enumNames.hasMoreElements()) {
                    String paramName = (String)enumNames.nextElement();
                    String[] arr = req.getParameterValues(paramName);
                    session.setAttribute("IP." + paramName, (Object)arr);
                }
            } else {
                String header = "Error in AdminIpAccess, delete. ";
                Properties langproperties = imcref.getLanguageProperties(user);
                String msg = langproperties.getProperty("error/servlet/AdminIpAccess/no_session") + "<br>";
                log.debug((Object)(header + "- session could not be created"));
                AdminRoles.printErrorMessage(req, res, header, msg);
                return;
            }
            HashMap vm = new HashMap();
            AdminRoles.sendHtml(req, res, vm, WARN_DEL_IP_TEMPLATE);
        } else if (req.getParameter("DEL_IP_ACCESS") != null) {
            HttpSession session = req.getSession(false);
            if (session != null) {
                log.debug((Object)("Ok, ta bort en Ip-access: " + session.toString()));
                String[] deleteIds = (String[])session.getAttribute("IP.EDIT_IP_ACCESS");
                if (deleteIds != null) {
                    for (int i = 0; i < deleteIds.length; ++i) {
                        String tmpId = "IP.IP_ACCESS_ID_" + deleteIds[i];
                        String[] tmpArr = (String[])session.getAttribute(tmpId);
                        String ipAccessId = tmpArr[0];
                        Object[] parameters = new String[]{ipAccessId};
                        imcref.getProcedureExecutor().executeUpdateProcedure("IPAccessDelete", parameters);
                    }
                }
            } else {
                String header = "Error in AdminIpAccess, delete.";
                Properties langproperties = imcref.getLanguageProperties(user);
                String msg = langproperties.getProperty("error/servlet/AdminIpAccess/no_session") + "<br>";
                log.debug((Object)(header + "- session could not be created"));
                AdminRoles.printErrorMessage(req, res, header, msg);
                return;
            }
            this.doGet(req, res);
        }
    }

    static void printNonAdminError(ImcmsServices imcref, UserDomainObject user, HttpServletRequest req, HttpServletResponse res, Class clazz) throws IOException {
        Properties langproperties = imcref.getLanguageProperties(user);
        String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
        String header = "Error in " + ClassUtils.getShortClassName((Class)clazz) + ".";
        log.debug((Object)(header + "- user is not an administrator"));
        AdminRoles.printErrorMessage(req, res, header, msg);
    }

    private Properties getAddParameters(HttpServletRequest req) {
        Properties ipInfo = new Properties();
        String user_id = req.getParameter("USER_ID") == null ? "" : req.getParameter("USER_ID").trim();
        String ipStart = req.getParameter("IP_START") == null ? "" : req.getParameter("IP_START").trim();
        String ipEnd = req.getParameter("IP_END") == null ? "" : req.getParameter("IP_END").trim();
        long ipStartInt = Utility.ipStringToLong(ipStart);
        long ipEndInt = Utility.ipStringToLong(ipEnd);
        ipInfo.setProperty("USER_ID", user_id);
        ipInfo.setProperty("IP_START", String.valueOf(ipStartInt));
        ipInfo.setProperty("IP_END", String.valueOf(ipEndInt));
        return ipInfo;
    }

    private String[] getEditedIpAccesses(HttpServletRequest req) {
        return req.getParameterValues("EDIT_IP_ACCESS");
    }

    private Properties validateParameters(Properties aPropObj, HttpServletRequest req, HttpServletResponse res, ImcmsServices imcref, UserDomainObject user) throws IOException {
        if (aPropObj.values().contains("")) {
            String header = "Error in AdminIpAccess, assertNoEmptyStringsInPropertyValues.";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/AdminIpAccess/vaidate_form_parameters") + "<br>";
            log.debug((Object)(header + "- values is missing for some parameters"));
            AdminRoles.printErrorMessage(req, res, header, msg);
            return null;
        }
        return aPropObj;
    }
}

