/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.mapping.DocumentMapper;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.ConcurrentDocumentModificationException;
import imcode.server.document.DirectDocumentReference;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.NoPermissionToEditDocumentException;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.index.DefaultQueryParser;
import imcode.server.document.index.DocumentIndex;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.LocalizedMessage;
import imcode.util.Parser;
import imcode.util.ShouldHaveCheckedPermissionsEarlierException;
import imcode.util.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.document.DateField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;

public class GetExistingDoc
extends HttpServlet {
    private static final Logger log = Logger.getLogger((String)GetExistingDoc.class.getName());
    private static final String ONE_SEARCH_HIT = "existing_doc_hit.html";
    private static final String SEARCH_RESULTS = "existing_doc_res.html";
    private static final String ADMIN_TEMPLATE_EXISTING_DOC = "existing_doc.html";
    private static final String SORT_BY_LANGUAGE_KEY_PREFIX = "templates/sv/existing_doc.html/sort_by/";
    private static final Object[][] SORT_ORDERS_ARRAY = new Object[][]{{"meta_headline", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/headline")}, {"meta_id", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/id")}, {"doc_type", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/type")}, {"date_modified", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/modified_datetime")}, {"date_created", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/created_datetime")}, {"archived_datetime", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/archived_datetime")}, {"publication_start_datetime", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/published_datetime")}};
    static final Map SORT_ORDERS_MAP = Utility.getMapViewOfObjectPairArray(SORT_ORDERS_ARRAY);

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        TextDocumentDomainObject parentDocument = (TextDocumentDomainObject)documentMapper.getDocument(Integer.parseInt(req.getParameter("meta_id_value")));
        int menuIndex = Integer.parseInt(req.getParameter("doc_menu_no"));
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (req.getParameter("cancel") != null || req.getParameter("cancel.x") != null) {
            res.sendRedirect("AdminDoc?meta_id=" + parentDocument.getId() + "&flags=" + 262144 + "&editmenu=" + menuIndex);
            return;
        }
        if (req.getParameter("search") != null || req.getParameter("search.x") != null) {
            DocumentIndex index = documentMapper.getDocumentIndex();
            BooleanQuery query = new BooleanQuery();
            String searchString = req.getParameter("searchstring");
            String searchPrep = req.getParameter("search_prep");
            try {
                if ("or".equalsIgnoreCase(searchPrep)) {
                    this.addStringToQuery(index, searchString, query);
                } else {
                    String[] searchStrings = searchString.split("\\s+");
                    for (int i = 0; i < searchStrings.length; ++i) {
                        String string = searchStrings[i];
                        this.addStringToQuery(index, string, query);
                    }
                }
            }
            catch (ParseException pe) {
                log.debug((Object)("Bad query: " + searchString), (Throwable)pe);
            }
            String[] docTypes = req.getParameterValues("doc_type");
            this.addDocTypesToQuery(docTypes, query);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date startDate = null;
            Date endDate = null;
            try {
                String startDateString = req.getParameter("start_date");
                startDate = dateFormat.parse(startDateString);
            }
            catch (java.text.ParseException ignored) {
                // empty catch block
            }
            try {
                String endDateString = req.getParameter("end_date");
                endDate = dateFormat.parse(endDateString);
            }
            catch (java.text.ParseException ignored) {
                // empty catch block
            }
            this.addDateRangesToQuery(startDate, endDate, req, query);
            String sortBy = req.getParameter("sortBy");
            String langPrefix = user.getLanguageIso639_2();
            Set sortOrderSet = SORT_ORDERS_MAP.keySet();
            if (!sortOrderSet.contains(sortBy)) {
                sortBy = "meta_id";
            }
            ArrayList<Object> sortOrderV = new ArrayList<Object>();
            for (int i = 0; i < SORT_ORDERS_ARRAY.length; ++i) {
                sortOrderV.add(SORT_ORDERS_ARRAY[i][0]);
                sortOrderV.add(((LocalizedMessage)SORT_ORDERS_ARRAY[i][1]).toLocalizedString(user));
            }
            log.debug((Object)("Query: " + query));
            List searchResultDocuments = index.search((Query)query, null, user);
            if (0 == searchResultDocuments.size()) {
                int documentId;
                DocumentDomainObject document;
                if (StringUtils.isNumeric((String)searchString) && this.canAddToMenu(user, parentDocument, document = documentMapper.getDocument(documentId = Integer.parseInt(searchString)))) {
                    this.addDocumentToMenu(document, parentDocument, menuIndex, user);
                    this.redirectBackToMenu(res, parentDocument, menuIndex);
                    return;
                }
            } else if (1 == searchResultDocuments.size()) {
                DocumentDomainObject onlyDocumentFound = (DocumentDomainObject)searchResultDocuments.get(0);
                if (searchString.equals("" + onlyDocumentFound.getId()) && this.canAddToMenu(user, parentDocument, onlyDocumentFound)) {
                    this.addDocumentToMenu(onlyDocumentFound, parentDocument, menuIndex, user);
                    this.redirectBackToMenu(res, parentDocument, menuIndex);
                    return;
                }
            }
            this.createSearchResultsPage(imcref, user, langPrefix, searchResultDocuments, parentDocument, menuIndex, req, startDate, dateFormat, endDate, docTypes, sortBy, sortOrderV, out);
        } else {
            this.addDocumentsFromRequestToMenu(user, req, imcref, parentDocument, menuIndex);
            this.redirectBackToMenu(res, parentDocument, menuIndex);
        }
    }

    private void addDocumentsFromRequestToMenu(UserDomainObject user, HttpServletRequest req, ImcmsServices imcref, TextDocumentDomainObject parentDocument, int menuIndex) {
        req.getSession().setAttribute("flags", (Object)new Integer(262144));
        String[] values = req.getParameterValues("existing_meta_id");
        if (values == null) {
            values = new String[]{};
        }
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        for (int m = 0; m < values.length; ++m) {
            int existingDocumentId = Integer.parseInt(values[m]);
            DocumentDomainObject existingDocument = documentMapper.getDocument(existingDocumentId);
            this.addDocumentToMenu(existingDocument, parentDocument, menuIndex, user);
        }
    }

    private void redirectBackToMenu(HttpServletResponse res, TextDocumentDomainObject parentDocument, int menuIndex) throws IOException {
        res.sendRedirect("AdminDoc?meta_id=" + parentDocument.getId() + "&flags=" + 262144 + "&editmenu=" + menuIndex);
    }

    private void addDocumentToMenu(DocumentDomainObject document, TextDocumentDomainObject parentDocument, int menuIndex, UserDomainObject user) {
        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
        boolean canAddToMenu = this.canAddToMenu(user, parentDocument, document);
        if (canAddToMenu) {
            MenuDomainObject parentMenu = parentDocument.getMenu(menuIndex);
            parentMenu.addMenuItem(new MenuItemDomainObject(new DirectDocumentReference(document)));
            try {
                documentMapper.saveDocument(parentDocument, user);
            }
            catch (NoPermissionToEditDocumentException e) {
                throw new ShouldHaveCheckedPermissionsEarlierException(e);
            }
            catch (NoPermissionToAddDocumentToMenuException e) {
                throw new ConcurrentDocumentModificationException(e);
            }
        }
    }

    private boolean canAddToMenu(UserDomainObject user, TextDocumentDomainObject parentDocument, DocumentDomainObject document) {
        Set allowedDocumentTypeIds = ((TextDocumentPermissionSetDomainObject)user.getPermissionSetFor(parentDocument)).getAllowedDocumentTypeIds();
        boolean sharePermission = user.canAddDocumentToAnyMenu(document);
        return sharePermission && allowedDocumentTypeIds.contains(new Integer(document.getDocumentTypeId()));
    }

    private void createSearchResultsPage(ImcmsServices imcref, UserDomainObject user, String langPrefix, List searchResultDocuments, TextDocumentDomainObject parentDocument, int doc_menu_no, HttpServletRequest req, Date startDate, DateFormat dateFormat, Date endDate, String[] docTypes, String sortBy, List sortOrderV, Writer out) throws IOException {
        String[] includeDocs;
        DocumentDomainObjectComparator searchResultsComparator = new DocumentDomainObjectComparator(sortBy);
        Collections.sort(searchResultDocuments, searchResultsComparator);
        ArrayList<String> outVector = new ArrayList<String>();
        String oneRecHtmlSrc = imcref.getAdminTemplate(ONE_SEARCH_HIT, user, null);
        String[][] allDocTypesArray = imcref.getAllDocumentTypes(langPrefix);
        Hashtable allDocTypesHash = GetExistingDoc.convertToSet(allDocTypesArray);
        StringBuffer searchResults = GetExistingDoc.parseSearchResults(oneRecHtmlSrc, searchResultDocuments, allDocTypesHash);
        ArrayList<String> tmpV = new ArrayList<String>();
        tmpV.add("#searchResults#");
        tmpV.add(searchResults.toString());
        searchResults.replace(0, searchResults.length(), imcref.getAdminTemplate(SEARCH_RESULTS, user, tmpV));
        outVector.add("#meta_id#");
        outVector.add("" + parentDocument.getId());
        outVector.add("#doc_menu_no#");
        outVector.add("" + doc_menu_no);
        outVector.add("#searchstring#");
        String searchStr = req.getParameter("searchstring") == null ? "" : req.getParameter("searchstring");
        outVector.add(searchStr);
        outVector.add("#start_date#");
        if (startDate == null) {
            outVector.add("");
        } else {
            outVector.add(dateFormat.format(startDate));
        }
        outVector.add("#end_date#");
        outVector.add(dateFormat.format(endDate));
        if (docTypes != null) {
            int i;
            HashMap<String, String> selectedDocTypes = new HashMap<String, String>(docTypes.length);
            for (i = 0; i < docTypes.length; ++i) {
                selectedDocTypes.put(docTypes[i], docTypes[i]);
            }
            for (i = 0; i < allDocTypesArray.length; ++i) {
                outVector.add("#checked_" + allDocTypesArray[i][0] + "#");
                if (selectedDocTypes.containsKey(allDocTypesArray[i][0])) {
                    outVector.add("checked");
                    continue;
                }
                outVector.add("");
            }
        }
        if ((includeDocs = req.getParameterValues("include_doc")) == null) {
            includeDocs = new String[]{};
        }
        HashSet<String> selectedIncludeDocs = new HashSet<String>(includeDocs.length);
        for (int i = 0; i < includeDocs.length; ++i) {
            selectedIncludeDocs.add(includeDocs[i]);
        }
        String[] allPossibleIncludeDocsValues = new String[]{"created", "changed"};
        for (int i = 0; i < allPossibleIncludeDocsValues.length; ++i) {
            outVector.add("#include_check_" + allPossibleIncludeDocsValues[i] + "#");
            if (selectedIncludeDocs.contains(allPossibleIncludeDocsValues[i])) {
                outVector.add("checked");
                continue;
            }
            outVector.add("");
        }
        String[] searchPrepArr = req.getParameterValues("search_prep");
        if (searchPrepArr == null) {
            searchPrepArr = new String[]{};
        }
        Hashtable<String, String> selectedsearchPrep = new Hashtable<String, String>(searchPrepArr.length);
        for (int i = 0; i < searchPrepArr.length; ++i) {
            selectedsearchPrep.put(searchPrepArr[i], searchPrepArr[i]);
        }
        String[] allPossibleSearchPreps = new String[]{"and", "or"};
        for (int i = 0; i < allPossibleSearchPreps.length; ++i) {
            outVector.add("#search_prep_check_" + allPossibleSearchPreps[i] + "#");
            if (selectedsearchPrep.containsKey(allPossibleSearchPreps[i])) {
                outVector.add("checked");
                continue;
            }
            outVector.add("");
        }
        String sortOrderStr = Html.createOptionList(sortOrderV, sortBy);
        outVector.add("#sortBy#");
        outVector.add(sortOrderStr);
        outVector.add("#searchResults#");
        outVector.add(searchResults.toString());
        String htmlOut = imcref.getAdminTemplate(ADMIN_TEMPLATE_EXISTING_DOC, user, outVector);
        out.write(htmlOut);
    }

    private void addDocTypesToQuery(String[] docTypes, BooleanQuery query) {
        BooleanQuery docTypesQuery = new BooleanQuery();
        for (int i = 0; null != docTypes && i < docTypes.length; ++i) {
            String docType = docTypes[i];
            docTypesQuery.add((Query)new TermQuery(new Term("doc_type_id", docType)), false, false);
        }
        query.add((Query)docTypesQuery, true, false);
    }

    private void addDateRangesToQuery(Date startDate, Date endDate, HttpServletRequest req, BooleanQuery query) {
        if (null != startDate || null != endDate) {
            String[] wantedDateFields = req.getParameterValues("include_doc");
            for (int i = 0; null != wantedDateFields && i < wantedDateFields.length; ++i) {
                String wantedIndexDateField;
                String wantedDateField = wantedDateFields[i];
                if ("created".equalsIgnoreCase(wantedDateField)) {
                    wantedIndexDateField = "created_datetime";
                } else {
                    if (!"changed".equalsIgnoreCase(wantedDateField)) continue;
                    wantedIndexDateField = "modified_datetime";
                }
                Term startDateTerm = null != startDate ? new Term(wantedIndexDateField, DateField.dateToString((Date)startDate)) : null;
                Term endDateTerm = null != endDate ? new Term(wantedIndexDateField, DateField.dateToString((Date)this.addOneDayToDate(endDate))) : null;
                RangeQuery dateRangeQuery = new RangeQuery(startDateTerm, endDateTerm, true);
                query.add((Query)dateRangeQuery, true, false);
            }
        }
    }

    private Date addOneDayToDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    private void addStringToQuery(DocumentIndex index, String string, BooleanQuery query) throws ParseException {
        Query textQuery = new DefaultQueryParser().parse(string);
        query.add(textQuery, true, false);
    }

    private static Hashtable convertToSet(String[][] arr) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        for (int i = 0; i < arr.length; ++i) {
            h.put(arr[i][0], arr[i][1]);
        }
        return h;
    }

    private static StringBuffer parseSearchResults(String oneRecHtmlSrc, List searchResultDocuments, Map docTypesHash) {
        StringBuffer searchResults = new StringBuffer(1024);
        Iterator iterator = searchResultDocuments.iterator();
        while (iterator.hasNext()) {
            DocumentDomainObject document = (DocumentDomainObject)iterator.next();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String[] data = new String[]{"#meta_id#", String.valueOf(document.getId()), "#doc_type#", (String)docTypesHash.get("" + document.getDocumentTypeId()), "#meta_headline#", document.getHeadline(), "#meta_text#", document.getMenuText(), "#date_created#", GetExistingDoc.formatDate(dateFormat, document.getCreatedDatetime()), "#date_modified#", GetExistingDoc.formatDate(dateFormat, document.getModifiedDatetime()), "#date_activated#", GetExistingDoc.formatDate(dateFormat, document.getPublicationStartDatetime()), "#date_archived#", GetExistingDoc.formatDate(dateFormat, document.getArchivedDatetime()), "#archive#", document.isArchived() ? "1" : "0"};
            searchResults.append(Parser.parseDoc(oneRecHtmlSrc, data));
        }
        return searchResults;
    }

    private static String formatDate(DateFormat dateFormat, Date datetime) {
        return null != datetime ? dateFormat.format(datetime) : "&nbsp;";
    }

    private class DocumentDomainObjectComparator
    implements Comparator {
        private String sortBy;

        private DocumentDomainObjectComparator(String sortBy) {
            this.sortBy = sortBy;
        }

        public int compare(Object o1, Object o2) {
            DocumentDomainObject d1 = (DocumentDomainObject)o1;
            DocumentDomainObject d2 = (DocumentDomainObject)o2;
            if ("meta_headline".equalsIgnoreCase(this.sortBy)) {
                return d1.getHeadline().compareToIgnoreCase(d2.getHeadline());
            }
            if ("doc_type".equalsIgnoreCase(this.sortBy)) {
                return d1.getDocumentTypeId() - d2.getDocumentTypeId();
            }
            if ("date_modified".equalsIgnoreCase(this.sortBy)) {
                return Utility.compareDatesWithNullFirst(d1.getModifiedDatetime(), d2.getModifiedDatetime());
            }
            if ("date_created".equalsIgnoreCase(this.sortBy)) {
                return Utility.compareDatesWithNullFirst(d1.getCreatedDatetime(), d2.getCreatedDatetime());
            }
            if ("date_archived".equalsIgnoreCase(this.sortBy)) {
                return Utility.compareDatesWithNullFirst(d1.getArchivedDatetime(), d2.getArchivedDatetime());
            }
            if ("date_activated".equalsIgnoreCase(this.sortBy)) {
                return Utility.compareDatesWithNullFirst(d1.getPublicationStartDatetime(), d2.getPublicationStartDatetime());
            }
            return d1.getId() - d2.getId();
        }
    }
}

