/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.InsertIntoTableDatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.commands.SqlUpdateDatabaseCommand;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.mapping.DocumentCreatingVisitor;
import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentSavingVisitor;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.NoPermissionToEditDocumentException;
import imcode.server.document.RoleIdToDocumentPermissionSetTypeMappings;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;

class DocumentSaver {
    private final DocumentMapper documentMapper;
    private static final int META_HEADLINE_MAX_LENGTH = 255;
    private static final int META_TEXT_MAX_LENGTH = 1000;
    public static final String SQL_DELETE_ROLE_DOCUMENT_PERMISSION_SET_ID = "DELETE FROM roles_rights WHERE role_id = ? AND meta_id = ?";
    public static final String SQL_SET_ROLE_DOCUMENT_PERMISSION_SET_ID = "INSERT INTO roles_rights (role_id, meta_id, set_id) VALUES(?,?,?)";

    DocumentSaver(DocumentMapper documentMapper) {
        this.documentMapper = documentMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDocument(DocumentDomainObject document, DocumentDomainObject oldDocument, UserDomainObject user) throws NoPermissionToEditDocumentException, NoPermissionToAddDocumentToMenuException {
        if (!user.canEdit(oldDocument)) {
            throw new NoPermissionToEditDocumentException("No permission to edit document " + oldDocument.getId());
        }
        this.checkDocumentForSave(document, oldDocument, user);
        document.loadAllLazilyLoaded();
        try {
            Date lastModifiedDatetime = Utility.truncateDateToMinutePrecision(document.getActualModifiedDatetime());
            Date modifiedDatetime = Utility.truncateDateToMinutePrecision(document.getModifiedDatetime());
            boolean modifiedDatetimeUnchanged = lastModifiedDatetime.equals(modifiedDatetime);
            if (modifiedDatetimeUnchanged) {
                document.setModifiedDatetime(this.documentMapper.getClock().getCurrentDate());
            }
            this.sqlUpdateMeta(document);
            this.updateDocumentSectionsCategoriesKeywords(document);
            if (user.canEditPermissionsFor(oldDocument)) {
                this.updateDocumentRolePermissions(document, user, oldDocument);
                this.documentMapper.getDocumentPermissionSetMapper().saveRestrictedDocumentPermissionSets(document, user, oldDocument);
            }
            document.accept(new DocumentSavingVisitor(oldDocument, this.documentMapper.getDatabase(), this.documentMapper.getImcmsServices()));
        }
        finally {
            this.documentMapper.invalidateDocument(document);
        }
    }

    void checkDocumentsAddedWithoutPermission(TextDocumentDomainObject textDocument, TextDocumentDomainObject oldTextDocument, UserDomainObject user) throws NoPermissionToAddDocumentToMenuException {
        boolean documentsWereAddedWithoutPermission;
        Set documentsAddedWithoutPermission = this.getDocumentsAddedWithoutPermission(textDocument, oldTextDocument, user, this.documentMapper);
        boolean bl = documentsWereAddedWithoutPermission = !documentsAddedWithoutPermission.isEmpty();
        if (documentsWereAddedWithoutPermission) {
            Collection documentIds = CollectionUtils.collect((Collection)documentsAddedWithoutPermission, (Transformer)new Transformer(){

                public Object transform(Object object) {
                    DocumentDomainObject document = (DocumentDomainObject)object;
                    return "" + document.getId();
                }
            });
            throw new NoPermissionToAddDocumentToMenuException("User is not allowed to add documents " + documentIds + " to document " + textDocument.getId());
        }
    }

    private void sqlUpdateMeta(DocumentDomainObject document) {
        String headline = document.getHeadline();
        String text = document.getMenuText();
        StringBuffer sqlStr = new StringBuffer("update meta set ");
        ArrayList sqlUpdateColumns = new ArrayList();
        ArrayList<String> sqlUpdateValues = new ArrayList<String>();
        DocumentSaver.makeDateSqlUpdateClause("publication_start_datetime", document.getPublicationStartDatetime(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeDateSqlUpdateClause("publication_end_datetime", document.getPublicationEndDatetime(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeDateSqlUpdateClause("archived_datetime", document.getArchivedDatetime(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeDateSqlUpdateClause("date_created", document.getCreatedDatetime(), sqlUpdateColumns, sqlUpdateValues);
        String headlineThatFitsInDB = headline.substring(0, Math.min(headline.length(), 254));
        DocumentSaver.makeStringSqlUpdateClause("meta_headline", headlineThatFitsInDB, sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeStringSqlUpdateClause("meta_image", document.getMenuImage(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeDateSqlUpdateClause("date_modified", document.getModifiedDatetime(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeStringSqlUpdateClause("target", document.getTarget(), sqlUpdateColumns, sqlUpdateValues);
        String textThatFitsInDB = text.substring(0, Math.min(text.length(), 999));
        DocumentSaver.makeStringSqlUpdateClause("meta_text", textThatFitsInDB, sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeStringSqlUpdateClause("lang_prefix", document.getLanguageIso639_2(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeBooleanSqlUpdateClause("disable_search", document.isSearchDisabled(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeBooleanSqlUpdateClause("shared", document.isLinkableByOtherUsers(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeBooleanSqlUpdateClause("show_meta", document.isLinkedForUnauthorizedUsers(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeBooleanSqlUpdateClause("permissions", document.isRestrictedOneMorePrivilegedThanRestrictedTwo(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeIntSqlUpdateClause("publisher_id", document.getPublisherId(), sqlUpdateColumns, sqlUpdateValues);
        DocumentSaver.makeIntSqlUpdateClause("owner_id", new Integer(document.getCreatorId()), sqlUpdateColumns, sqlUpdateValues);
        Document.PublicationStatus publicationStatus = document.getPublicationStatus();
        int publicationStatusInt = DocumentSaver.convertPublicationStatusToInt(publicationStatus);
        DocumentSaver.makeIntSqlUpdateClause("status", new Integer(publicationStatusInt), sqlUpdateColumns, sqlUpdateValues);
        sqlStr.append(StringUtils.join(sqlUpdateColumns.iterator(), (String)","));
        sqlStr.append(" where meta_id = ?");
        sqlUpdateValues.add("" + document.getId());
        Object[] params = sqlUpdateValues.toArray(new String[sqlUpdateValues.size()]);
        ((Integer)this.documentMapper.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand(sqlStr.toString(), params))).intValue();
    }

    static int convertPublicationStatusToInt(Document.PublicationStatus publicationStatus) {
        int publicationStatusInt = 0;
        if (Document.PublicationStatus.APPROVED.equals(publicationStatus)) {
            publicationStatusInt = 2;
        } else if (Document.PublicationStatus.DISAPPROVED.equals(publicationStatus)) {
            publicationStatusInt = 1;
        }
        return publicationStatusInt;
    }

    private void updateDocumentSectionsCategoriesKeywords(DocumentDomainObject document) {
        this.updateDocumentSections(document.getId(), document.getSectionIds());
        this.documentMapper.getCategoryMapper().updateDocumentCategories(document);
        this.updateDocumentKeywords(document);
    }

    void saveNewDocument(UserDomainObject user, DocumentDomainObject document) throws NoPermissionToAddDocumentToMenuException {
        if (!user.canEdit(document)) {
            return;
        }
        this.checkDocumentForSave(document, null, user);
        document.loadAllLazilyLoaded();
        this.documentMapper.setCreatedAndModifiedDatetimes(document, new Date());
        int newMetaId = this.sqlInsertIntoMeta(document);
        if (!user.isSuperAdminOrHasFullPermissionOn(document)) {
            document.getPermissionSets().setRestricted1(document.getPermissionSetsForNewDocuments().getRestricted1());
            document.getPermissionSets().setRestricted2(document.getPermissionSetsForNewDocuments().getRestricted2());
        }
        document.setId(newMetaId);
        this.updateDocumentSectionsCategoriesKeywords(document);
        this.updateDocumentRolePermissions(document, user, null);
        this.documentMapper.getDocumentPermissionSetMapper().saveRestrictedDocumentPermissionSets(document, user, null);
        document.accept(new DocumentCreatingVisitor(this.documentMapper.getDatabase(), this.documentMapper.getImcmsServices()));
        this.documentMapper.invalidateDocument(document);
    }

    private void checkDocumentForSave(DocumentDomainObject document, DocumentDomainObject oldDocument, UserDomainObject user) throws NoPermissionToAddDocumentToMenuException {
        if (document instanceof TextDocumentDomainObject) {
            this.checkDocumentsAddedWithoutPermission((TextDocumentDomainObject)document, (TextDocumentDomainObject)oldDocument, user);
        }
        this.documentMapper.getCategoryMapper().checkMaxDocumentCategoriesOfType(document);
    }

    void updateDocumentRolePermissions(DocumentDomainObject document, UserDomainObject user, DocumentDomainObject oldDocument) {
        RoleIdToDocumentPermissionSetTypeMappings.Mapping mapping;
        int i;
        RoleIdToDocumentPermissionSetTypeMappings mappings = new RoleIdToDocumentPermissionSetTypeMappings();
        if (null != oldDocument) {
            RoleIdToDocumentPermissionSetTypeMappings.Mapping[] oldDocumentMappings = oldDocument.getRoleIdsMappedToDocumentPermissionSetTypes().getMappings();
            for (i = 0; i < oldDocumentMappings.length; ++i) {
                mapping = oldDocumentMappings[i];
                mappings.setPermissionSetTypeForRole(mapping.getRoleId(), DocumentPermissionSetTypeDomainObject.NONE);
            }
        }
        RoleIdToDocumentPermissionSetTypeMappings.Mapping[] documentMappings = document.getRoleIdsMappedToDocumentPermissionSetTypes().getMappings();
        for (i = 0; i < documentMappings.length; ++i) {
            mapping = documentMappings[i];
            mappings.setPermissionSetTypeForRole(mapping.getRoleId(), mapping.getDocumentPermissionSetType());
        }
        RoleIdToDocumentPermissionSetTypeMappings.Mapping[] mappingsArray = mappings.getMappings();
        for (int i2 = 0; i2 < mappingsArray.length; ++i2) {
            RoleIdToDocumentPermissionSetTypeMappings.Mapping mapping2 = mappingsArray[i2];
            RoleId roleId = mapping2.getRoleId();
            DocumentPermissionSetTypeDomainObject documentPermissionSetType = mapping2.getDocumentPermissionSetType();
            if (null != oldDocument && !user.canSetDocumentPermissionSetTypeForRoleIdOnDocument(documentPermissionSetType, roleId, oldDocument)) continue;
            Object[] params1 = new String[]{"" + roleId, "" + document.getId()};
            ((Integer)this.documentMapper.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand(SQL_DELETE_ROLE_DOCUMENT_PERMISSION_SET_ID, params1))).intValue();
            if (DocumentPermissionSetTypeDomainObject.NONE.equals(documentPermissionSetType)) continue;
            Object[] params = new String[]{"" + roleId.intValue(), "" + document.getId(), "" + documentPermissionSetType};
            ((Integer)this.documentMapper.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand(SQL_SET_ROLE_DOCUMENT_PERMISSION_SET_ID, params))).intValue();
        }
    }

    static void makeBooleanSqlUpdateClause(String columnName, boolean bool, List sqlUpdateColumns, List sqlUpdateValues) {
        sqlUpdateColumns.add(columnName + " = ?");
        sqlUpdateValues.add(bool ? "1" : "0");
    }

    static void makeDateSqlUpdateClause(String columnName, Date date, List sqlUpdateColumns, List sqlUpdateValues) {
        DocumentSaver.makeStringSqlUpdateClause(columnName, Utility.makeSqlStringFromDate(date), sqlUpdateColumns, sqlUpdateValues);
    }

    static void makeIntSqlUpdateClause(String columnName, Integer integer, ArrayList sqlUpdateColumns, ArrayList sqlUpdateValues) {
        if (null != integer) {
            sqlUpdateColumns.add(columnName + " = ?");
            sqlUpdateValues.add("" + integer);
        } else {
            sqlUpdateColumns.add(columnName + " = NULL");
        }
    }

    static void makeStringSqlUpdateClause(String columnName, String value, List sqlUpdateColumns, List sqlUpdateValues) {
        if (null != value) {
            sqlUpdateColumns.add(columnName + " = ?");
            sqlUpdateValues.add(value);
        } else {
            sqlUpdateColumns.add(columnName + " = NULL");
        }
    }

    private int sqlInsertIntoMeta(DocumentDomainObject document) {
        Number documentId = (Number)this.documentMapper.getDatabase().execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("meta", (Object[][])new String[][]{{"doc_type", document.getDocumentTypeId() + ""}, {"meta_headline", document.getHeadline()}, {"meta_text", document.getMenuText()}, {"meta_image", document.getMenuImage()}, {"owner_id", document.getCreatorId() + ""}, {"permissions", this.makeSqlStringFromBoolean(document.isRestrictedOneMorePrivilegedThanRestrictedTwo())}, {"shared", this.makeSqlStringFromBoolean(document.isLinkableByOtherUsers())}, {"show_meta", this.makeSqlStringFromBoolean(document.isLinkedForUnauthorizedUsers())}, {"lang_prefix", document.getLanguageIso639_2()}, {"date_created", Utility.makeSqlStringFromDate(document.getCreatedDatetime())}, {"date_modified", Utility.makeSqlStringFromDate(document.getModifiedDatetime())}, {"disable_search", this.makeSqlStringFromBoolean(document.isSearchDisabled())}, {"target", document.getTarget()}, {"activate", "1"}, {"archived_datetime", Utility.makeSqlStringFromDate(document.getArchivedDatetime())}, {"publisher_id", null != document.getPublisherId() ? document.getPublisherId() + "" : null}, {"status", "" + document.getPublicationStatus()}, {"publication_start_datetime", Utility.makeSqlStringFromDate(document.getPublicationStartDatetime())}, {"publication_end_datetime", Utility.makeSqlStringFromDate(document.getPublicationEndDatetime())}}));
        return documentId.intValue();
    }

    private String makeSqlStringFromBoolean(boolean bool) {
        return bool ? "1" : "0";
    }

    Set getDocumentsAddedWithoutPermission(TextDocumentDomainObject textDocument, TextDocumentDomainObject oldTextDocument, final UserDomainObject user, DocumentGetter documentGetter) {
        Set documentIdsAdded = this.getDocumentIdsAdded(textDocument, oldTextDocument);
        List documents = documentGetter.getDocuments(documentIdsAdded);
        Collection documentsAddedWithoutPermission = CollectionUtils.select((Collection)documents, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return !user.canAddDocumentToAnyMenu((DocumentDomainObject)object);
            }
        });
        return new HashSet(documentsAddedWithoutPermission);
    }

    private Set getDocumentIdsAdded(TextDocumentDomainObject textDocument, TextDocumentDomainObject oldTextDocument) {
        Set documentIdsAdded = null != oldTextDocument ? this.getChildDocumentIdsDifference(textDocument, oldTextDocument) : textDocument.getChildDocumentIds();
        return documentIdsAdded;
    }

    private Set getChildDocumentIdsDifference(TextDocumentDomainObject minuend, TextDocumentDomainObject subtrahend) {
        Set minuendChildDocumentIds = minuend.getChildDocumentIds();
        Set subtrahendChildDocumentIds = subtrahend.getChildDocumentIds();
        HashSet result = new HashSet(minuendChildDocumentIds);
        result.removeAll(subtrahendChildDocumentIds);
        return result;
    }

    void updateDocumentKeywords(DocumentDomainObject document) {
        int meta_id = document.getId();
        Set keywords = document.getKeywords();
        HashSet<String> allKeywords = new HashSet<String>(Arrays.asList(this.documentMapper.getAllKeywords()));
        this.deleteKeywordsFromDocument(meta_id);
        Iterator iterator = keywords.iterator();
        while (iterator.hasNext()) {
            String keyword = (String)iterator.next();
            boolean keywordExists = allKeywords.contains(keyword);
            if (!keywordExists) {
                this.addKeyword(keyword);
            }
            this.addExistingKeywordToDocument(meta_id, keyword);
        }
        this.deleteUnusedKeywords();
    }

    void updateDocumentSections(int metaId, Set sectionIds) {
        this.removeAllSectionsFromDocument(metaId);
        Iterator iterator = sectionIds.iterator();
        while (iterator.hasNext()) {
            Integer sectionId = (Integer)iterator.next();
            this.addSectionIdToDocument(metaId, sectionId);
        }
    }

    private void addSectionIdToDocument(int metaId, Integer sectionId) {
        Object[] params = new Integer[]{new Integer(metaId), sectionId};
        this.documentMapper.getDatabase().execute((DatabaseCommand)new SqlUpdateDatabaseCommand("INSERT INTO meta_section VALUES(?,?)", params));
    }

    private void deleteKeywordsFromDocument(int meta_id) {
        String sqlDeleteKeywordsFromDocument = "DELETE FROM meta_classification WHERE meta_id = ?";
        Object[] params = new String[]{"" + meta_id};
        ((Integer)this.documentMapper.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand(sqlDeleteKeywordsFromDocument, params))).intValue();
    }

    private void deleteUnusedKeywords() {
        Object[] params = new String[]{};
        ((Integer)this.documentMapper.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("DELETE FROM classification WHERE class_id NOT IN (SELECT class_id FROM meta_classification)", params))).intValue();
    }

    private void addKeyword(String keyword) {
        Object[] params = new String[]{keyword};
        ((Integer)this.documentMapper.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("INSERT INTO classification (code) VALUES(?)", params))).intValue();
    }

    private void removeAllSectionsFromDocument(int metaId) {
        Object[] params = new String[]{"" + metaId};
        ((Integer)this.documentMapper.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("DELETE FROM meta_section WHERE meta_id = ?", params))).intValue();
    }

    private void addExistingKeywordToDocument(int meta_id, String keyword) {
        Object[] params1 = new String[]{keyword};
        int keywordId = Integer.parseInt((String)this.documentMapper.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT class_id FROM classification WHERE code = ?", params1, Utility.SINGLE_STRING_HANDLER)));
        Object[] params = new String[]{"" + meta_id, "" + keywordId};
        ((Integer)this.documentMapper.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("INSERT INTO meta_classification (meta_id, class_id) VALUES(?,?)", params))).intValue();
    }
}

