/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentAlreadyInMenuException;
import com.imcode.imcms.api.MockContentManagementSystem;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import imcode.server.MockImcmsServices;
import imcode.server.document.DirectDocumentReference;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import java.util.Date;
import junit.framework.TestCase;

public class TestTextDocument
extends TestCase {
    TextDocument.Menu menu;
    private UserDomainObject internalUser;
    private TextDocumentDomainObject textDocumentDO;
    private TextDocumentDomainObject otherTextDocumentDO;
    private RoleId readRole;
    private RoleId editRole;
    private TextDocument textDocument;
    private MockContentManagementSystem contentManagementSystem;
    private TextDocument otherTextDocument;
    private MockImcmsServices imcmsServices;

    protected void setUp() throws Exception {
        super.setUp();
        this.internalUser = new UserDomainObject();
        this.readRole = new RoleId(3);
        this.editRole = new RoleId(4);
        this.textDocumentDO = new TextDocumentDomainObject();
        this.textDocumentDO.setId(1001);
        this.textDocumentDO.setDocumentPermissionSetTypeForRoleId(this.readRole, DocumentPermissionSetTypeDomainObject.READ);
        this.textDocumentDO.setDocumentPermissionSetTypeForRoleId(this.editRole, DocumentPermissionSetTypeDomainObject.FULL);
        this.otherTextDocumentDO = new TextDocumentDomainObject();
        this.otherTextDocumentDO.setId(1002);
        this.otherTextDocumentDO.setLinkableByOtherUsers(true);
        int menuIndex = 1;
        DirectDocumentReference documentReference = new DirectDocumentReference(this.otherTextDocumentDO);
        MenuDomainObject menuDO = this.textDocumentDO.getMenu(menuIndex);
        menuDO.addMenuItem(new MenuItemDomainObject(documentReference));
        this.contentManagementSystem = new MockContentManagementSystem();
        this.imcmsServices = new MockImcmsServices();
        this.contentManagementSystem.setInternal(this.imcmsServices);
        this.contentManagementSystem.setCurrentUser(new User(this.internalUser));
        this.textDocument = new TextDocument(this.textDocumentDO, (ContentManagementSystem)this.contentManagementSystem);
        this.otherTextDocument = new TextDocument(this.otherTextDocumentDO, (ContentManagementSystem)this.contentManagementSystem);
        this.menu = new TextDocument.Menu(this.textDocument, menuIndex);
    }

    public void testMenuGetDocumentsAndMenuItemsWithNothing() {
        this.assertGettersDoNotReturnDocuments();
    }

    public void testMenuGetDocumentsAndMenuItems() {
        this.internalUser.addRoleId(this.editRole);
        this.otherTextDocumentDO.setDocumentPermissionSetTypeForRoleId(this.editRole, DocumentPermissionSetTypeDomainObject.FULL);
        this.assertGettersReturnDocuments();
    }

    public void testMenuGetVisible() {
        this.internalUser.addRoleId(this.readRole);
        this.otherTextDocumentDO.setDocumentPermissionSetTypeForRoleId(this.readRole, DocumentPermissionSetTypeDomainObject.READ);
        this.publish(this.otherTextDocumentDO);
        this.assertGetVisibleReturnDocuments();
    }

    public void testMenuGetVisibleWithArchived() {
        this.internalUser.addRoleId(this.readRole);
        this.otherTextDocumentDO.setDocumentPermissionSetTypeForRoleId(this.readRole, DocumentPermissionSetTypeDomainObject.READ);
        this.publish(this.otherTextDocumentDO);
        this.otherTextDocumentDO.setArchivedDatetime(new Date(0L));
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithNothing() {
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithRole() {
        this.internalUser.addRoleId(this.readRole);
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithRoleAndPermission() {
        this.internalUser.addRoleId(this.readRole);
        this.otherTextDocumentDO.setDocumentPermissionSetTypeForRoleId(this.readRole, DocumentPermissionSetTypeDomainObject.READ);
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithApprovedStatus() {
        this.otherTextDocumentDO.setPublicationStatus(Document.PublicationStatus.APPROVED);
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithPublicationStart() {
        this.otherTextDocumentDO.setPublicationStartDatetime(new Date(0L));
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithPublished() {
        this.publish(this.otherTextDocumentDO);
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithVisibleInMenusForUnauthorizedUsers() {
        this.otherTextDocumentDO.setLinkedForUnauthorizedUsers(true);
        this.assertGetVisibleDoNotReturnDocuments();
    }

    public void testMenuGetVisibleWithPublishedAndVisibleInMenusForUnauthorizedUsers() {
        this.publish(this.otherTextDocumentDO);
        this.otherTextDocumentDO.setLinkedForUnauthorizedUsers(true);
        this.assertGetVisibleReturnDocuments();
    }

    private void assertGettersDoNotReturnDocuments() {
        TestTextDocument.assertFalse((this.menu.getDocuments().length > 0 ? 1 : 0) != 0);
        TestTextDocument.assertFalse((this.menu.getMenuItems().length > 0 ? 1 : 0) != 0);
    }

    private void assertGettersReturnDocuments() {
        TestTextDocument.assertTrue((this.menu.getDocuments().length > 0 ? 1 : 0) != 0);
        TestTextDocument.assertTrue((this.menu.getMenuItems().length > 0 ? 1 : 0) != 0);
    }

    private void assertGetVisibleReturnDocuments() {
        TestTextDocument.assertTrue((this.menu.getVisibleDocuments().length > 0 ? 1 : 0) != 0);
        TestTextDocument.assertTrue((this.menu.getVisibleMenuItems().length > 0 ? 1 : 0) != 0);
    }

    private void assertGetVisibleDoNotReturnDocuments() {
        TestTextDocument.assertFalse((this.menu.getVisibleDocuments().length > 0 ? 1 : 0) != 0);
        TestTextDocument.assertFalse((this.menu.getVisibleMenuItems().length > 0 ? 1 : 0) != 0);
    }

    public void testAddRemoveDocument() throws DocumentAlreadyInMenuException {
        this.menu.addDocument(this.otherTextDocument);
        TestTextDocument.assertEquals((int)0, (int)this.menu.getDocuments().length);
        this.otherTextDocumentDO.setDocumentPermissionSetTypeForRoleId(this.readRole, DocumentPermissionSetTypeDomainObject.READ);
        TestTextDocument.assertEquals((int)0, (int)this.menu.getDocuments().length);
        this.internalUser.addRoleId(this.readRole);
        TestTextDocument.assertEquals((int)0, (int)this.menu.getDocuments().length);
        this.publish(this.otherTextDocument);
        TestTextDocument.assertEquals((int)1, (int)this.menu.getDocuments().length);
        TestTextDocument.assertEquals((Object)this.otherTextDocument, (Object)this.menu.getDocuments()[0]);
        this.menu.removeDocument(this.otherTextDocument);
        TestTextDocument.assertEquals((int)0, (int)this.menu.getDocuments().length);
    }

    private void publish(Document document) {
        this.publish(document.getInternal());
    }

    private void publish(DocumentDomainObject document) {
        document.setPublicationStatus(Document.PublicationStatus.APPROVED);
        document.setPublicationStartDatetime(new Date(0L));
    }
}

