/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.io;

import com.imcode.util.FileTreeTraverser;
import imcode.server.WebAppGlobalConstants;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class FileUtility {
    private FileUtility() {
    }

    public static File getFileFromWebappRelativePath(String pathString) {
        if (null == pathString) {
            return null;
        }
        File path = new File(pathString);
        if (!path.isAbsolute()) {
            path = new File(WebAppGlobalConstants.getInstance().getAbsoluteWebAppPath(), pathString);
        }
        return path;
    }

    public static File relativizeFile(File ancestorDirectory, File file) {
        LinkedList<String> fileParents = new LinkedList<String>();
        File currentParent = file;
        while (!currentParent.equals(ancestorDirectory)) {
            fileParents.addFirst(currentParent.getName());
            currentParent = currentParent.getParentFile();
        }
        File relativeFile = new File((String)fileParents.removeFirst());
        Iterator iterator = fileParents.iterator();
        while (iterator.hasNext()) {
            relativeFile = new File(relativeFile, (String)iterator.next());
        }
        return relativeFile;
    }

    public static boolean directoryIsAncestorOfOrEqualTo(File dir, File file) {
        for (File currentFile = file; null != currentFile; currentFile = currentFile.getParentFile()) {
            if (!currentFile.equals(dir)) continue;
            return true;
        }
        return false;
    }

    public static String[] splitFile(File file) {
        LinkedList<String> list = new LinkedList<String>();
        for (File parent = file; null != parent; parent = parent.getParentFile()) {
            list.addFirst(parent.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String relativeFileToString(File file) {
        return StringUtils.join((Object[])FileUtility.splitFile(file), (char)'/');
    }

    public static Collection collectRelativeSubdirectoriesStartingWith(File directory) {
        Collection directories = CollectionUtils.transformedCollection(new ArrayList(), (Transformer)new FileRelativizingTransformer(directory.getParentFile()));
        FileTreeTraverser fileTreeTraverser = new FileTreeTraverser((FileFilter)new DirectoryCollectingFileFilter(directories));
        fileTreeTraverser.traverse(new File[]{directory});
        return directories;
    }

    public static String escapeFilename(String filename) {
        StringBuffer escapedFilename = new StringBuffer();
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (c > '\u007f' || !Character.isLetterOrDigit(c)) {
                escapedFilename.append('_').append(StringUtils.leftPad((String)Integer.toHexString(c), (int)4, (char)'0'));
                continue;
            }
            escapedFilename.append(c);
        }
        return escapedFilename.toString();
    }

    public static String unescapeFilename(String escapedFilename) {
        try {
            return Util.substitute((PatternMatcher)new Perl5Matcher(), (Pattern)new Perl5Compiler().compile("_([A-Fa-f0-9]{4})"), (Substitution)new UnescapeFilenameSubstitution(), (String)escapedFilename, (int)-1);
        }
        catch (MalformedPatternException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public static void backupRename(File source, File destination) throws IOException {
        if (!source.equals(destination)) {
            File oldDestination = new File(destination.getParentFile(), destination.getName() + ".old");
            if (oldDestination.exists()) {
                FileUtils.forceDelete((File)oldDestination);
            }
            if (destination.exists()) {
                FileUtility.fatalRename(destination, oldDestination);
            }
            FileUtility.fatalRename(source, destination);
            if (oldDestination.exists()) {
                FileUtils.deleteDirectory((File)oldDestination);
            }
        }
    }

    private static void fatalRename(File source, File destination) throws IOException {
        if (!source.renameTo(destination)) {
            throw new IOException("Failed to rename \"" + source + "\" to \"" + destination + "\".");
        }
    }

    private static class UnescapeFilenameSubstitution
    implements Substitution {
        private UnescapeFilenameSubstitution() {
        }

        public void appendSubstitution(StringBuffer stringBuffer, MatchResult matchResult, int i, PatternMatcherInput patternMatcherInput, PatternMatcher patternMatcher, Pattern pattern) {
            String hex = matchResult.group(1);
            char c = (char)Integer.parseInt(hex, 16);
            stringBuffer.append(c);
        }
    }

    private static class FileRelativizingTransformer
    implements Transformer {
        private final File directory;

        public FileRelativizingTransformer(File directory) {
            this.directory = directory;
        }

        public Object transform(Object input) {
            return FileUtility.relativizeFile(this.directory, (File)input);
        }
    }

    private static class DirectoryCollectingFileFilter
    implements FileFilter {
        private final Collection directories;

        private DirectoryCollectingFileFilter(Collection directories) {
            this.directories = directories;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                this.directories.add(file);
                return true;
            }
            return false;
        }
    }
}

