/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.IOUtils;

public class CachingFileLoader {
    private final int fileCacheSize = 100;
    private Map fileCache = Collections.synchronizedMap(new LRUMap(100));

    public String getCachedFileString(File file) throws IOException {
        String cachedContents = this.getCachedFileStringIfRecent(file);
        if (null == cachedContents) {
            cachedContents = IOUtils.toString((Reader)new BufferedReader(new FileReader(file)));
            this.cacheFile(file, cachedContents);
        }
        return cachedContents;
    }

    public void cacheFile(File file, String contents) {
        this.fileCache.put(file, new Object[]{contents, new Long(System.currentTimeMillis())});
    }

    public String getCachedFileStringIfRecent(File file) {
        Object[] file_and_date = (Object[])this.fileCache.get(file);
        if (file_and_date != null && file.lastModified() <= (Long)file_and_date[1]) {
            return (String)file_and_date[0];
        }
        return null;
    }
}

