/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import imcode.server.user.Authenticator;
import imcode.server.user.UserAndRoleRegistry;
import imcode.server.user.UserDomainObject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

public class LdapUserAndRoleRegistry
implements Authenticator,
UserAndRoleRegistry {
    private static final Logger log = Logger.getLogger((Class)LdapUserAndRoleRegistry.class);
    public static final String DEFAULT_LDAP_ROLE = "LDAP";
    public static final String AUTHENTICATION_TYPE_SIMPLE = "simple";
    private static final String DISTINGUISHED_NAME = "dn";
    private static final String PERSON_SURNAME = "sn";
    private static final String PERSON_TELEPHONE_NUMBER = "telephoneNumber";
    private static final String ORGANIZATIONALPERSON_TITLE = "title";
    private static final String ORGANIZATIONALPERSON_STATE_OR_PROVINCE_NAME = "st";
    private static final String ORGANIZATIONALPERSON_POSTAL_CODE = "postalCode";
    private static final String ORGANIZATIONALPERSON_STREET_ADRESS = "streetAddress";
    private static final String INETORGPERSON_GIVEN_NAME = "givenName";
    private static final String INETORGPERSON_MAIL = "mail";
    private static final String INETORGPERSON_HOME_PHONE = "homePhone";
    private static final String INETORGPERSON_MOBILE = "mobile";
    private static final String INETORGPERSON_LOCALITY_NAME = "l";
    private static final String INETORGPERSON_ORGANIZATION = "o";
    static final String INETORGPERSON_USER_IDENTITY = "uid";
    private DirContext ctx = null;
    private String ldapUrl;
    private String ldapAuthenticationType;
    private String ldapUserObjectClass = null;
    private String ldapBindDn;
    private String ldapPassword;
    private String[] ldapAttributesAutoMappedToRoles;
    private Properties userPropertyNameToLdapAttributeNameMap = new Properties();
    private static final Map DEFAULT_USER_PROPERTY_NAME_TO_LDAP_ATTRIBUTE_NAME_MAP = ArrayUtils.toMap((Object[])new String[][]{{"LoginName", "uid"}, {"FirstName", "givenName"}, {"LastName", "sn"}, {"Title", "title"}, {"Company", "o"}, {"Address", "streetAddress"}, {"City", "l"}, {"Zip", "postalCode"}, {"Province", "st"}, {"EmailAddress", "mail"}, {"WorkPhone", "telephoneNumber"}, {"MobilePhone", "mobile"}, {"HomePhone", "homePhone"}});
    private static final String LDAP_USER_OBJECTCLASS__INETORGPERSON = "inetOrgPerson";
    private static final String LDAP_USER_OBJECTCLASS_DEFAULT = "inetOrgPerson";

    public LdapUserAndRoleRegistry(Properties ldapConfig) throws LdapInitException {
        String ldapStringOfAttributesMappedToRoles = ldapConfig.getProperty("LdapAttributesMappedToRoles", "");
        String[] ldapAttributesMappedToRoles = LdapUserAndRoleRegistry.splitStringOnCommasAndSpaces(ldapStringOfAttributesMappedToRoles);
        Properties ldapUserAttributes = new Properties();
        ExtendedProperties ldapUserAttributesSubset = ExtendedProperties.convertProperties((Properties)ldapConfig).subset("LdapUserAttribute");
        if (null != ldapUserAttributesSubset) {
            ldapUserAttributes.putAll((Map<?, ?>)ldapUserAttributesSubset);
        }
        this.init(ldapConfig.getProperty("LdapUrl", "ldap://localhost/"), AUTHENTICATION_TYPE_SIMPLE, ldapConfig.getProperty("LdapUserObjectClass", "inetOrgPerson"), ldapConfig.getProperty("LdapBindDn", ""), ldapConfig.getProperty("LdapPassword", ""), ldapAttributesMappedToRoles, ldapUserAttributes);
    }

    public LdapUserAndRoleRegistry(String ldapUrl, String ldapAuthenticationType, String ldapUserObjectClass, String ldapUserName, String ldapPassword, String[] ldapAttributesMappedToRoles) throws LdapInitException {
        this.init(ldapUrl, ldapAuthenticationType, ldapUserObjectClass, ldapUserName, ldapPassword, ldapAttributesMappedToRoles, new Properties());
    }

    public String[] getAllRoleNames() {
        return new String[]{DEFAULT_LDAP_ROLE};
    }

    private void init(String ldapUrl, String ldapAuthenticationType, String ldapUserObjectClass, String ldapUserName, String ldapPassword, String[] ldapAttributesAutoMappedToRoles, Properties ldapUserAttributes) throws LdapInitException {
        this.ldapAttributesAutoMappedToRoles = ldapAttributesAutoMappedToRoles;
        this.initLdapUserAttributesMap(ldapUserAttributes);
        this.ldapUrl = ldapUrl;
        this.ldapUserObjectClass = ldapUserObjectClass;
        this.ldapAuthenticationType = ldapAuthenticationType;
        this.ldapBindDn = ldapUserName;
        this.ldapPassword = ldapPassword;
        this.setupInitialDirContext();
    }

    private void initLdapUserAttributesMap(Properties ldapUserAttributes) throws LdapInitException {
        this.userPropertyNameToLdapAttributeNameMap.putAll((Map<?, ?>)DEFAULT_USER_PROPERTY_NAME_TO_LDAP_ATTRIBUTE_NAME_MAP);
        this.userPropertyNameToLdapAttributeNameMap.putAll((Map<?, ?>)ldapUserAttributes);
        TreeSet<Object> badUserAttributes = new TreeSet<Object>(this.userPropertyNameToLdapAttributeNameMap.keySet());
        String[] capitalizedSettableUserPropertyNames = LdapUserAndRoleRegistry.getCapitalizedSettableBeanPropertyNames(UserDomainObject.class);
        badUserAttributes.removeAll(Arrays.asList(capitalizedSettableUserPropertyNames));
        if (!badUserAttributes.isEmpty()) {
            throw new LdapInitException("Unrecognized LdapUserAttributes: " + StringUtils.join(badUserAttributes.iterator(), (String)", "));
        }
    }

    private void setupInitialDirContext() throws LdapInitException {
        try {
            this.ctx = LdapUserAndRoleRegistry.loginAndGetInitialDirContext(this.ldapUrl, this.ldapAuthenticationType, this.ldapBindDn, this.ldapPassword);
        }
        catch (AuthenticationException ex) {
            throw new LdapInitException("Authentication failed, using login: '" + this.ldapBindDn + "'", ex);
        }
        catch (NameNotFoundException ex) {
            throw new LdapInitException("Root not found: " + this.ldapUrl, ex);
        }
        catch (NamingException ex) {
            throw new LdapInitException("Failed to create LDAP context " + this.ldapUrl + ": " + ex.getExplanation(), ex);
        }
    }

    public boolean authenticate(String loginName, String password) {
        boolean userAuthenticates = false;
        try {
            String userDistinguishedName;
            Properties userAttributes = this.searchForUserAttributes(loginName, new String[]{DISTINGUISHED_NAME});
            if (null != userAttributes && null != (userDistinguishedName = (String)userAttributes.get(DISTINGUISHED_NAME))) {
                LdapUserAndRoleRegistry.loginAndGetInitialDirContext(this.ldapUrl, this.ldapAuthenticationType, userDistinguishedName, password);
                userAuthenticates = true;
            }
        }
        catch (AuthenticationException ex) {
            userAuthenticates = false;
        }
        catch (NamingException ex) {
            log.warn((Object)"Failed to get ldap context.", (Throwable)ex);
            userAuthenticates = false;
        }
        return userAuthenticates;
    }

    public UserDomainObject getUser(String loginName) {
        UserDomainObject result = null;
        Properties attributeMap = this.searchForUserAttributes(loginName, null);
        if (null != attributeMap) {
            result = this.createUserFromLdapAttributes(attributeMap);
            result.setLoginName(loginName);
            result.setActive(true);
        }
        return result;
    }

    private Properties createMapFromSearchResult(SearchResult searchResult, String[] attributesToReturn) {
        NamingEnumeration<? extends Attribute> attribEnum = searchResult.getAttributes().getAll();
        Properties userAttributes = new Properties();
        try {
            if (!attribEnum.hasMore()) {
                boolean includeDistinguishedName;
                boolean bl = includeDistinguishedName = null == attributesToReturn || ArrayUtils.contains((Object[])attributesToReturn, (Object)DISTINGUISHED_NAME);
                if (includeDistinguishedName) {
                    DirContext dirContext = (DirContext)searchResult.getObject();
                    String distinguishedName = dirContext.getNameInNamespace();
                    userAttributes.put(DISTINGUISHED_NAME, distinguishedName);
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)e);
        }
        while (attribEnum.hasMoreElements()) {
            Attribute attribute = (Attribute)attribEnum.nextElement();
            String attributeName = attribute.getID();
            String attributeValue = null;
            try {
                attributeValue = attribute.get().toString();
            }
            catch (NamingException e) {
                log.error((Object)e);
            }
            userAttributes.setProperty(attributeName, attributeValue);
        }
        return userAttributes;
    }

    private UserDomainObject createUserFromLdapAttributes(Properties ldapAttributeValues) {
        UserDomainObject newlyFoundLdapUser = new UserDomainObject();
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)newlyFoundLdapUser);
        try {
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                String ldapAttributeValue;
                String uncapitalizedPropertyName;
                String capitalizedPropertyName;
                String ldapAttributeName;
                PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                if (null == propertyDescriptor.getWriteMethod() || null == (ldapAttributeName = this.userPropertyNameToLdapAttributeNameMap.getProperty(capitalizedPropertyName = StringUtils.capitalize((String)(uncapitalizedPropertyName = propertyDescriptor.getName())))) || null == (ldapAttributeValue = ldapAttributeValues.getProperty(ldapAttributeName))) continue;
                BeanUtils.setProperty((Object)newlyFoundLdapUser, (String)uncapitalizedPropertyName, (Object)ldapAttributeValue);
            }
        }
        catch (IllegalAccessException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new UnhandledException((Throwable)e);
        }
        return newlyFoundLdapUser;
    }

    private static DirContext loginAndGetInitialDirContext(String ldapUrl, String ldapAuthenticationType, String ldapUserName, String ldapPassword) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.security.authentication", ldapAuthenticationType);
        env.put("java.naming.security.principal", ldapUserName);
        env.put("java.naming.security.credentials", ldapPassword);
        InitialDirContext ctx = new InitialDirContext(env);
        return ctx;
    }

    public String[] getRoleNames(UserDomainObject user) {
        String loginName = user.getLoginName();
        Properties attributeMappedRoles = this.searchForUserAttributes(loginName, this.ldapAttributesAutoMappedToRoles);
        HashSet roles = new HashSet(attributeMappedRoles.values());
        String[] rolesArray = new String[roles.size() + 1];
        roles.toArray(rolesArray);
        rolesArray[rolesArray.length - 1] = DEFAULT_LDAP_ROLE;
        return rolesArray;
    }

    private Properties searchForUserAttributes(String loginName, String[] attributesToReturn) {
        Properties attributeMap = null;
        try {
            try {
                attributeMap = this.trySearchForUserAttributes(loginName, attributesToReturn);
            }
            catch (CommunicationException e) {
                log.warn((Object)"Problem communicating with LDAP server, reconnecting.", (Throwable)e);
                attributeMap = this.reconnectAndRetrySearchForUserAttributes(loginName, attributesToReturn);
            }
        }
        catch (NamingException e) {
            log.warn((Object)("Could not find user " + loginName), (Throwable)e);
        }
        return attributeMap;
    }

    private Properties reconnectAndRetrySearchForUserAttributes(String loginName, String[] attributesToReturn) throws NamingException {
        try {
            this.setupInitialDirContext();
        }
        catch (LdapInitException e) {
            log.fatal((Object)"Could not reconnect to LDAP server.", (Throwable)e);
        }
        return this.trySearchForUserAttributes(loginName, attributesToReturn);
    }

    private Properties trySearchForUserAttributes(String loginName, String[] attributesToReturn) throws NamingException {
        String ldapUserIdentifyingAttribute = this.userPropertyNameToLdapAttributeNameMap.getProperty("LoginName");
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(attributesToReturn);
        searchControls.setReturningObjFlag(true);
        String searchFilterExpr = "(&(objectClass={0})({1}={2}))";
        NamingEnumeration<SearchResult> enumeration = this.ctx.search("", searchFilterExpr, new Object[]{this.ldapUserObjectClass, ldapUserIdentifyingAttribute, loginName}, searchControls);
        boolean foundUser = enumeration != null && enumeration.hasMore();
        Properties attributeMap = null;
        if (foundUser) {
            SearchResult searchResult = (SearchResult)enumeration.nextElement();
            attributeMap = this.createMapFromSearchResult(searchResult, attributesToReturn);
        } else {
            log.debug((Object)("Could not find user " + loginName));
        }
        return attributeMap;
    }

    private static String[] splitStringOnCommasAndSpaces(String stringToSplit) {
        StringTokenizer attributesTokenizer = new StringTokenizer(stringToSplit, ", ");
        String[] tokens = new String[attributesTokenizer.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = attributesTokenizer.nextToken();
        }
        return tokens;
    }

    private static String[] getCapitalizedSettableBeanPropertyNames(Class beanClass) {
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Class)beanClass);
        ArrayList<String> settableBeanPropertyNames = new ArrayList<String>();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            if (null == propertyDescriptor.getWriteMethod()) continue;
            String uncapitalizedPropertyName = propertyDescriptor.getName();
            String capitalizedPropertyName = StringUtils.capitalize((String)uncapitalizedPropertyName);
            settableBeanPropertyNames.add(capitalizedPropertyName);
        }
        return settableBeanPropertyNames.toArray(new String[settableBeanPropertyNames.size()]);
    }

    public void setUserPropertyLdapAttribute(String userPropertyName, String ldapAttribute) {
        this.userPropertyNameToLdapAttributeNameMap.put(userPropertyName, ldapAttribute);
    }

    public class LdapInitException
    extends Exception {
        public LdapInitException(String message) {
            super(message);
        }

        private LdapInitException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

