/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.parser;

import imcode.server.parser.Element;
import imcode.server.parser.Node;
import imcode.server.parser.Text;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class SimpleElement
implements Element {
    private String name;
    private Properties attributes;
    private List children;

    public SimpleElement(String name, Properties attributes, List children) {
        this.name = name != null ? name : "";
        this.attributes = attributes != null ? attributes : new Properties();
        this.children = children != null ? children : new LinkedList();
    }

    public short getNodeType() {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public List getChildren() {
        return this.children;
    }

    public Element getChildElement(String name) {
        Iterator childrenIterator = this.children.iterator();
        while (childrenIterator.hasNext()) {
            Node childNode = (Node)childrenIterator.next();
            if (childNode.getNodeType() != 1 || !((Element)childNode).getName().equals(name)) continue;
            return (Element)childNode;
        }
        return null;
    }

    public String getTextContent() {
        StringBuffer result = new StringBuffer();
        this.getTextContent(this, result);
        return result.toString();
    }

    private void getTextContent(Node node, StringBuffer result) {
        if (node.getNodeType() == 0) {
            result.append(((Text)node).getContent());
            return;
        }
        if (node.getNodeType() == 1) {
            Iterator childIterator = ((Element)node).getChildren().iterator();
            while (childIterator.hasNext()) {
                this.getTextContent((Node)childIterator.next(), result);
            }
        }
    }

    public String toString() {
        StringBuffer string = new StringBuffer();
        string.append("<?imcms:").append(this.getName());
        Enumeration<?> enumeration = this.getAttributes().propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = this.getAttributes().getProperty(key);
            char quote = value.indexOf(34) == -1 ? (char)'\"' : '\'';
            string.append(' ').append(key).append('=').append(quote).append(value).append(quote);
        }
        string.append("?>");
        Iterator childIterator = this.children.iterator();
        while (childIterator.hasNext()) {
            string.append(childIterator.next().toString());
        }
        string.append("<?/imcms:").append(this.getName()).append("?>");
        return string.toString();
    }
}

