/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentReference;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.textdocument.ImageSource;
import imcode.util.Utility;
import imcode.util.io.EmptyInputStreamSource;
import imcode.util.io.InputStreamSource;
import java.util.Date;

public class FileDocumentImageSource
extends ImageSource {
    private DocumentReference fileDocumentReference;

    public FileDocumentImageSource(DocumentReference fileDocumentReference) {
        this.fileDocumentReference = fileDocumentReference;
        DocumentDomainObject document = fileDocumentReference.getDocument();
        if (!(document instanceof FileDocumentDomainObject)) {
            throw new IllegalArgumentException("Not a file document: " + document.getId());
        }
    }

    public InputStreamSource getInputStreamSource() {
        if (null == this.getFileDocument()) {
            return new EmptyInputStreamSource();
        }
        return this.getFileDocument().getDefaultFile().getInputStreamSource();
    }

    public FileDocumentDomainObject getFileDocument() {
        return (FileDocumentDomainObject)this.fileDocumentReference.getDocument();
    }

    public String getUrlPathRelativeToContextPath() {
        return Utility.getContextRelativePathToDocument(this.getFileDocument());
    }

    public String toStorageString() {
        if (this.isEmpty()) {
            return "";
        }
        return "" + this.getFileDocument().getId();
    }

    public int getTypeId() {
        return 1;
    }

    public Date getModifiedDatetime() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getFileDocument().getModifiedDatetime();
    }
}

