/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.UnhandledException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XmlDocumentBuilder {
    private Document xmlDocument;
    private Element documentsElement;

    public XmlDocumentBuilder() {
        try {
            this.xmlDocument = this.createXmlDocument();
            Element imcmsElement = this.xmlDocument.createElement("imcms");
            this.documentsElement = this.xmlDocument.createElement("documents");
            imcmsElement.appendChild(this.documentsElement);
            this.xmlDocument.appendChild(imcmsElement);
        }
        catch (ParserConfigurationException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private Document createXmlDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    public void addDocument(DocumentDomainObject document) {
        XmlBuildingDocumentVisitor documentVisitor = new XmlBuildingDocumentVisitor(this.xmlDocument);
        document.accept(documentVisitor);
        Element documentElement = documentVisitor.getDocumentElement();
        documentElement.setAttribute("id", "" + document.getId());
        this.documentsElement.appendChild(documentElement);
    }

    public Document getXmlDocument() {
        return this.xmlDocument;
    }

    private static class XmlBuildingDocumentVisitor
    extends DocumentVisitor {
        private Document xmlDocument;
        private Element documentElement;

        XmlBuildingDocumentVisitor(Document xmlDocument) {
            this.xmlDocument = xmlDocument;
        }

        public Element getDocumentElement() {
            return this.documentElement;
        }

        public void visitTextDocument(TextDocumentDomainObject textDocument) {
            Element documentElement = this.xmlDocument.createElement("textdocument");
            this.createTextElements(textDocument, documentElement);
            this.documentElement = documentElement;
        }

        private void createTextElements(TextDocumentDomainObject textDocument, Element textDocumentElement) {
            Map texts = textDocument.getTexts();
            Iterator iterator = texts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Integer textIndex = (Integer)entry.getKey();
                TextDomainObject text = (TextDomainObject)entry.getValue();
                Element textElement = this.createTextElement(textIndex, text);
                textDocumentElement.appendChild(textElement);
            }
        }

        private Element createTextElement(Integer textIndex, TextDomainObject text) {
            Element textElement = this.xmlDocument.createElement("text");
            textElement.setAttribute("index", "" + textIndex);
            textElement.setAttribute("type", 0 == text.getType() ? "text" : "html");
            Text textNode = this.xmlDocument.createTextNode(text.getText());
            textElement.appendChild(textNode);
            return textElement;
        }
    }
}

