/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseException;
import com.imcode.db.commands.InsertIntoTableDatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.handlers.CollectionHandler;
import com.imcode.db.handlers.RowTransformer;
import com.imcode.imcms.db.StringArrayArrayResultSetHandler;
import com.imcode.imcms.mapping.DocumentMapper;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.io.CopyUtils;

public class TemplateMapper {
    private static final String SPROC_GET_TEMPLATES_IN_GROUP = "GetTemplatesInGroup";
    private static final String SPROC_GET_TEMPLATE_GROUPS_FOR_USER = "GetTemplategroupsForUser";
    private static final String SPROC_GET_TEMPLATE_GROUPS = "GetTemplateGroups";
    private Database database;
    private ImcmsServices services;
    static /* synthetic */ Class class$java$lang$Integer;

    public TemplateMapper(ImcmsServices service) {
        this.database = service.getDatabase();
        this.services = service;
    }

    public void addTemplateToGroup(TemplateDomainObject template, TemplateGroupDomainObject templateGroup) {
        String sqlStr = "INSERT INTO templates_cref (group_id,template_id) VALUES(?,?)";
        Object[] parameters = new String[]{"" + templateGroup.getId(), "" + template.getId()};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters))).intValue();
    }

    public TemplateDomainObject[] getArrayOfAllTemplatesExceptOne(TemplateDomainObject template) {
        TemplateDomainObject[] allTemplates = this.getAllTemplates();
        ArrayList<TemplateDomainObject> allTemplatesExceptOne = new ArrayList<TemplateDomainObject>(allTemplates.length - 1);
        for (int i = 0; i < allTemplates.length; ++i) {
            if (template.equals(allTemplates[i])) continue;
            allTemplatesExceptOne.add(allTemplates[i]);
        }
        return allTemplatesExceptOne.toArray(new TemplateDomainObject[allTemplatesExceptOne.size()]);
    }

    public String createHtmlOptionListOfTemplateGroups(TemplateGroupDomainObject selectedTemplateGroup) {
        TemplateGroupDomainObject[] templateGroups = this.services.getTemplateMapper().getAllTemplateGroups();
        return this.createHtmlOptionListOfTemplateGroups(Arrays.asList(templateGroups), selectedTemplateGroup);
    }

    public String createHtmlOptionListOfTemplateGroups(Collection templateGroups, TemplateGroupDomainObject selectedTemplateGroup) {
        String temps = "";
        Iterator iterator = templateGroups.iterator();
        while (iterator.hasNext()) {
            TemplateGroupDomainObject templateGroup = (TemplateGroupDomainObject)iterator.next();
            boolean selected = null != selectedTemplateGroup && selectedTemplateGroup.equals(templateGroup);
            temps = temps + "<option value=\"" + templateGroup.getId() + "\"" + (selected ? " selected" : "") + ">" + templateGroup.getName() + "</option>";
        }
        return temps;
    }

    public String createHtmlOptionListOfTemplates(TemplateDomainObject[] templates, TemplateDomainObject selectedTemplate) {
        HashSet<String> demoTemplateIds = new HashSet<String>();
        demoTemplateIds.addAll(Arrays.asList(this.getDemoTemplateIds()));
        String temps = "";
        for (int i = 0; i < templates.length; ++i) {
            TemplateDomainObject template = templates[i];
            boolean selected = selectedTemplate != null && selectedTemplate.equals(template);
            boolean hasDemoTemplate = demoTemplateIds.contains("" + template.getId());
            temps = temps + "<option value=\"" + template.getId() + "\"" + (selected ? " selected" : "") + ">" + (hasDemoTemplate ? "*" : "") + template.getName() + "</option>";
        }
        return temps;
    }

    public String createHtmlOptionListOfTemplatesWithDocumentCount(UserDomainObject user) {
        String htmlStr = "";
        TemplateMapper templateMapper = this.services.getTemplateMapper();
        TemplateDomainObject[] templates = templateMapper.getAllTemplates();
        for (int i = 0; i < templates.length; ++i) {
            TemplateDomainObject template = templates[i];
            ArrayList<String> tags = new ArrayList<String>();
            tags.add("#template_name#");
            tags.add(template.getName());
            tags.add("#docs#");
            tags.add("" + templateMapper.getCountOfDocumentsUsingTemplate(template));
            tags.add("#template_id#");
            tags.add("" + template.getId());
            htmlStr = htmlStr + this.services.getAdminTemplate("template_list_row.html", user, tags);
        }
        return htmlStr;
    }

    public void deleteTemplate(TemplateDomainObject template) {
        Object[] parameters1 = new String[]{"" + template.getId()};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand("delete from templates_cref where template_id = ?", parameters1))).intValue();
        Object[] parameters = new String[]{"" + template.getId()};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand("delete from templates where template_id = ?", parameters))).intValue();
        File f = new File(this.services.getConfig().getTemplatePath() + "/text/" + template.getId() + ".html");
        if (f.exists()) {
            f.delete();
        }
    }

    public void deleteTemplateGroup(int grp_id) {
        Object[] parameters1 = new String[]{"" + grp_id};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand("delete from templates_cref where group_id = ?", parameters1))).intValue();
        Object[] parameters = new String[]{"" + grp_id};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand("delete from templategroups where group_id = ?", parameters))).intValue();
    }

    public TemplateGroupDomainObject[] getAllTemplateGroups() {
        Object[] parameters = new String[]{};
        String[][] sprocResult = (String[][])this.services.getProcedureExecutor().executeProcedure(SPROC_GET_TEMPLATE_GROUPS, parameters, new StringArrayArrayResultSetHandler());
        return this.createTemplateGroupsFromSqlResult(sprocResult);
    }

    public TemplateGroupDomainObject[] getAllTemplateGroupsAvailableForUserOnDocument(UserDomainObject user, int metaId) {
        String[][] sprocResult = this.sprocGetTemplateGroupsForUser(user, metaId);
        return this.createTemplateGroupsFromSqlResult(sprocResult);
    }

    public Set getAllTemplateGroupIds() {
        return (Set)this.database.execute((DatabaseCommand)new SqlQueryCommand("SELECT group_id FROM templategroups", null, (ResultSetHandler)new CollectionHandler(new HashSet(), (RowTransformer)new TemplateIdRowTransformer())));
    }

    public TemplateDomainObject[] getAllTemplates() {
        String sqlStr = "select template_id,template_name,simple_name from templates order by simple_name";
        Object[] parameters = new String[]{};
        String[][] queryResult = (String[][])this.database.execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
        return this.createTemplatesFromSqlResult(queryResult);
    }

    private int getCountOfDocumentsUsingTemplate(TemplateDomainObject template) {
        Object[] parameters = new String[]{"" + template.getId()};
        String queryResult = (String)this.database.execute((DatabaseCommand)new SqlQueryCommand("SELECT COUNT(meta_id) FROM text_docs WHERE template_id = ?", parameters, Utility.SINGLE_STRING_HANDLER));
        return Integer.parseInt(queryResult);
    }

    public DocumentDomainObject[] getDocumentsUsingTemplate(TemplateDomainObject template) {
        Object[] parameters = new String[]{"" + template.getId()};
        String[][] temp = (String[][])this.database.execute((DatabaseCommand)new SqlQueryCommand("select td.meta_id, meta_headline from text_docs td join meta m on td.meta_id = m.meta_id where template_id = ? order by td.meta_id", parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
        DocumentMapper documentMapper = this.services.getDocumentMapper();
        DocumentDomainObject[] documents = new DocumentDomainObject[temp.length];
        for (int i = 0; i < documents.length; ++i) {
            int documentId = Integer.parseInt(temp[i][0]);
            documents[i] = documentMapper.getDocument(documentId);
        }
        return documents;
    }

    public TemplateDomainObject getTemplateById(int template_id) {
        String sqlStr = "select template_id,template_name,simple_name from templates where template_id = ?";
        Object[] parameters = new String[]{"" + template_id};
        String[] queryResult = (String[])this.database.execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_HANDLER));
        return this.createTemplateFromSqlResultRow(queryResult);
    }

    public TemplateDomainObject getTemplateByName(String templateSimpleName) {
        String sqlStr = "select template_id,template_name,simple_name from templates where simple_name = ?";
        Object[] parameters = new String[]{templateSimpleName};
        String[] queryResult = (String[])this.database.execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_HANDLER));
        return this.createTemplateFromSqlResultRow(queryResult);
    }

    public TemplateGroupDomainObject getTemplateGroupById(int templateGroupId) {
        String sqlStr = "SELECT group_id,group_name FROM templategroups WHERE group_id = ?";
        Object[] parameters = new String[]{"" + templateGroupId};
        String[] queryResult = (String[])this.database.execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_HANDLER));
        return this.createTemplateGroupFromSqlResultRow(queryResult);
    }

    public TemplateGroupDomainObject getTemplateGroupByName(String name) {
        Object[] parameters = new String[]{name};
        String[] sqlResultRow = (String[])this.database.execute((DatabaseCommand)new SqlQueryCommand("select group_id, group_name from templategroups where group_name = ?", parameters, Utility.STRING_ARRAY_HANDLER));
        return this.createTemplateGroupFromSqlResultRow(sqlResultRow);
    }

    public TemplateDomainObject[] getTemplatesInGroup(TemplateGroupDomainObject templateGroup) {
        Object[] parameters = new String[]{"" + templateGroup.getId()};
        String[][] templateData = (String[][])this.services.getProcedureExecutor().executeProcedure(SPROC_GET_TEMPLATES_IN_GROUP, parameters, new StringArrayArrayResultSetHandler());
        TemplateDomainObject[] templates = new TemplateDomainObject[templateData.length];
        for (int i = 0; i < templateData.length; ++i) {
            int templateId = Integer.parseInt(templateData[i][0]);
            templates[i] = this.getTemplateById(templateId);
        }
        return templates;
    }

    public TemplateDomainObject[] getTemplatesNotInGroup(TemplateGroupDomainObject templateGroup) {
        List<TemplateDomainObject> templatesInGroup = Arrays.asList(this.getTemplatesInGroup(templateGroup));
        HashSet<TemplateDomainObject> allTemplates = new HashSet<TemplateDomainObject>(Arrays.asList(this.getAllTemplates()));
        allTemplates.removeAll(templatesInGroup);
        Object[] templatesNotInGroup = allTemplates.toArray(new TemplateDomainObject[allTemplates.size()]);
        Arrays.sort(templatesNotInGroup);
        return templatesNotInGroup;
    }

    public void removeTemplateFromGroup(TemplateDomainObject template, TemplateGroupDomainObject templateGroup) {
        String sqlStr = "DELETE FROM templates_cref WHERE group_id = ? AND template_id = ?";
        Object[] parameters = new String[]{"" + templateGroup.getId(), "" + template.getId()};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters))).intValue();
    }

    public boolean renameTemplate(TemplateDomainObject template, String newNameForTemplate) {
        try {
            String sqlStr = "UPDATE templates SET simple_name = ? WHERE template_id = ?";
            Object[] parameters = new String[]{newNameForTemplate, "" + template.getId()};
            ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters))).intValue();
            return true;
        }
        catch (DatabaseException e) {
            return false;
        }
    }

    public void renameTemplateGroup(TemplateGroupDomainObject templateGroup, String newName) {
        String sqlStr = "update templategroups\nset group_name = ?\nwhere group_id = ?\n";
        Object[] parameters = new String[]{newName, "" + templateGroup.getId()};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters))).intValue();
    }

    public void replaceAllUsagesOfTemplate(TemplateDomainObject template, TemplateDomainObject newTemplate) {
        if (null != template && null != newTemplate) {
            String sqlStr = "update text_docs set template_id = ? where template_id = ?";
            Object[] parameters = new String[]{"" + newTemplate.getId(), "" + template.getId()};
            ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters))).intValue();
        }
    }

    private String[][] sprocGetTemplateGroupsForUser(UserDomainObject user, int meta_id) {
        Object[] parameters = new String[]{String.valueOf(meta_id), String.valueOf(user.getId())};
        return (String[][])this.services.getProcedureExecutor().executeProcedure(SPROC_GET_TEMPLATE_GROUPS_FOR_USER, parameters, new StringArrayArrayResultSetHandler());
    }

    private TemplateDomainObject createTemplateFromSqlResultRow(String[] sqlResultRow) {
        if (0 == sqlResultRow.length) {
            return null;
        }
        int templateId = Integer.parseInt(sqlResultRow[0]);
        String templateName = sqlResultRow[1];
        String simpleName = sqlResultRow[2];
        return new TemplateDomainObject(templateId, simpleName, templateName);
    }

    private TemplateGroupDomainObject createTemplateGroupFromSqlResultRow(String[] sqlResultRow) {
        if (0 == sqlResultRow.length) {
            return null;
        }
        int templateGroupId = Integer.parseInt(sqlResultRow[0]);
        String templateGroupName = sqlResultRow[1];
        return new TemplateGroupDomainObject(templateGroupId, templateGroupName);
    }

    private TemplateGroupDomainObject[] createTemplateGroupsFromSqlResult(String[][] sprocResult) {
        TemplateGroupDomainObject[] templateGroups = new TemplateGroupDomainObject[sprocResult.length];
        for (int i = 0; i < sprocResult.length; ++i) {
            templateGroups[i] = this.createTemplateGroupFromSqlResultRow(sprocResult[i]);
        }
        return templateGroups;
    }

    private TemplateDomainObject[] createTemplatesFromSqlResult(String[][] queryResult) {
        TemplateDomainObject[] templates = new TemplateDomainObject[queryResult.length];
        for (int i = 0; i < queryResult.length; ++i) {
            templates[i] = this.createTemplateFromSqlResultRow(queryResult[i]);
        }
        return templates;
    }

    public void createTemplateGroup(String name) {
        this.database.execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("templategroups", (Object[][])new Object[][]{{"group_name", name}}));
    }

    public void saveDemoTemplate(int template_id, InputStream data, String suffix) throws IOException {
        this.deleteDemoTemplate(template_id);
        FileOutputStream fw = new FileOutputStream(this.services.getConfig().getTemplatePath() + "/text/demo/" + template_id + "." + suffix);
        CopyUtils.copy((InputStream)data, (OutputStream)fw);
        fw.flush();
        fw.close();
    }

    public void deleteDemoTemplate(int template_id) throws IOException {
        File demoTemplateDirectory = new File(new File(this.services.getConfig().getTemplatePath(), "text"), "demo");
        File[] demoTemplates = demoTemplateDirectory.listFiles();
        for (int i = 0; i < demoTemplates.length; ++i) {
            File demoTemplate = demoTemplates[i];
            String demoTemplateFileName = demoTemplate.getName();
            if (!demoTemplateFileName.startsWith(template_id + ".") || demoTemplate.delete()) continue;
            throw new IOException("fail to deleate");
        }
    }

    public int saveTemplate(String name, String file_name, InputStream templateData, boolean overwrite, String lang_prefix) {
        Object[] parameters;
        String sqlStr = "select template_id from templates where simple_name = ?";
        Object[] parameters1 = new String[]{name};
        String templateId = (String)this.database.execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters1, Utility.SINGLE_STRING_HANDLER));
        if (null == templateId) {
            parameters = new String[]{};
            templateId = (String)this.database.execute((DatabaseCommand)new SqlQueryCommand("select max(template_id) + 1 from templates\n", parameters, Utility.SINGLE_STRING_HANDLER));
            Object[] parameters2 = new String[]{templateId, file_name, name, lang_prefix};
            ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand("insert into templates values (?,?,?,?,0,0,0)", parameters2))).intValue();
        } else {
            if (!overwrite) {
                return -1;
            }
            parameters = new String[]{file_name, templateId};
            ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand("update templates set template_name = ? where template_id = ?", parameters))).intValue();
        }
        File f = new File(this.services.getConfig().getTemplatePath(), "text/" + templateId + ".html");
        try {
            FileOutputStream fw = new FileOutputStream(f);
            CopyUtils.copy((InputStream)templateData, (OutputStream)fw);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            return -2;
        }
        return 0;
    }

    public Object[] getDemoTemplate(int template_id) throws IOException {
        StringBuffer str = new StringBuffer();
        BufferedReader fr = null;
        String suffix = null;
        String[] suffixList = new String[]{"jpg", "jpeg", "gif", "png", "html", "htm"};
        for (int i = 0; i < suffixList.length; ++i) {
            File fileObj = new File(this.services.getConfig().getTemplatePath(), "/text/demo/" + template_id + "." + suffixList[i]);
            long date = 0L;
            long fileDate = fileObj.lastModified();
            if (!fileObj.exists() || fileDate <= date) continue;
            try {
                fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileObj), "8859_1"));
                suffix = suffixList[i];
                continue;
            }
            catch (IOException e) {
                return null;
            }
        }
        try {
            int read;
            char[] buffer = new char[4096];
            while ((read = fr.read(buffer, 0, 4096)) != -1) {
                str.append(buffer, 0, read);
            }
            fr.close();
        }
        catch (IOException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
        return new Object[]{suffix, str.toString().getBytes("8859_1")};
    }

    public String[] getDemoTemplateIds() {
        File demoDir = new File(this.services.getConfig().getTemplatePath() + "/text/demo/");
        File[] file_list = demoDir.listFiles(new NonEmptyFileFilter());
        String[] name_list = new String[file_list.length];
        if (file_list != null) {
            for (int i = 0; i < name_list.length; ++i) {
                String filename = file_list[i].getName();
                int dot = filename.indexOf(".");
                name_list[i] = dot > -1 ? filename.substring(0, dot) : filename;
            }
        } else {
            return new String[0];
        }
        return name_list;
    }

    public String getTemplateData(int template_id) throws IOException {
        return this.services.getFileCache().getCachedFileString(new File(this.services.getConfig().getTemplatePath(), "/text/" + template_id + ".html"));
    }

    public List getTemplateGroups(Set templateGroupIds) {
        ArrayList<TemplateGroupDomainObject> allowedTemplateGroups = new ArrayList<TemplateGroupDomainObject>(templateGroupIds.size());
        Iterator iterator = templateGroupIds.iterator();
        while (iterator.hasNext()) {
            Integer allowedTemplateGroupId = (Integer)iterator.next();
            TemplateGroupDomainObject templateGroup = this.getTemplateGroupById(allowedTemplateGroupId);
            if (null == templateGroup) continue;
            allowedTemplateGroups.add(templateGroup);
        }
        Collections.sort(allowedTemplateGroups);
        return allowedTemplateGroups;
    }

    public boolean templateGroupContains(TemplateGroupDomainObject templateGroup, TemplateDomainObject template) {
        TemplateDomainObject[] templates = this.getTemplatesInGroup(templateGroup);
        for (int i = 0; i < templates.length; ++i) {
            TemplateDomainObject t = templates[i];
            if (t.getId() != template.getId()) continue;
            return true;
        }
        return false;
    }

    private static class TemplateIdRowTransformer
    implements RowTransformer {
        private TemplateIdRowTransformer() {
        }

        public Object createObjectFromResultSetRow(ResultSet resultSet) throws SQLException {
            return new Integer(resultSet.getInt(1));
        }

        public Class getClassOfCreatedObjects() {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = TemplateMapper.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
    }

    private static class NonEmptyFileFilter
    implements FileFilter {
        private NonEmptyFileFilter() {
        }

        public boolean accept(File file) {
            return file.length() > 0L;
        }
    }
}

