/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.util.IdLocalizedNamePair;
import imcode.util.LocalizedMessage;
import java.util.HashSet;
import java.util.Set;

public class DocumentTypeDomainObject
extends IdLocalizedNamePair {
    public static final int TEXT_ID = 2;
    public static final int URL_ID = 5;
    public static final int BROWSER_ID = 6;
    public static final int HTML_ID = 7;
    public static final int FILE_ID = 8;
    private static final String DOCUMENT_TYPE_NAME_LOCALIZED_MESSAGE_PREFIX = "document_type/name/";
    public static final DocumentTypeDomainObject TEXT = new DocumentTypeDomainObject(2, new LocalizedMessage("document_type/name/text"));
    public static final DocumentTypeDomainObject URL = new DocumentTypeDomainObject(5, new LocalizedMessage("document_type/name/url"));
    public static final DocumentTypeDomainObject BROWSER = new DocumentTypeDomainObject(6, new LocalizedMessage("document_type/name/browser"));
    public static final DocumentTypeDomainObject HTML = new DocumentTypeDomainObject(7, new LocalizedMessage("document_type/name/html"));
    public static final DocumentTypeDomainObject FILE = new DocumentTypeDomainObject(8, new LocalizedMessage("document_type/name/file"));
    static final DocumentTypeDomainObject[] ALL_DOCUMENT_TYPES = new DocumentTypeDomainObject[]{BROWSER, FILE, HTML, TEXT, URL};

    public DocumentTypeDomainObject(int id, LocalizedMessage name) {
        super(id, name);
    }

    public static int[] getAllDocumentTypeIds() {
        int[] allDocumentTypeIds = new int[ALL_DOCUMENT_TYPES.length];
        for (int i = 0; i < ALL_DOCUMENT_TYPES.length; ++i) {
            DocumentTypeDomainObject documentType = ALL_DOCUMENT_TYPES[i];
            allDocumentTypeIds[i] = documentType.getId();
        }
        return allDocumentTypeIds;
    }

    public static Set getAllDocumentTypeIdsSet() {
        HashSet<Integer> set = new HashSet<Integer>();
        int[] allDocumentTypeIds = DocumentTypeDomainObject.getAllDocumentTypeIds();
        for (int i = 0; i < allDocumentTypeIds.length; ++i) {
            int documentTypeId = allDocumentTypeIds[i];
            set.add(new Integer(documentTypeId));
        }
        return set;
    }
}

