/*
 * Decompiled with CFR 0.152.
 */
package imcode.server;

import imcode.server.DefaultImcmsServices;
import imcode.server.ImcmsServices;
import imcode.util.Prefs;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

public class Imcms {
    private static final String SERVER_PROPERTIES_FILENAME = "server.properties";
    private static final Logger log = Logger.getLogger((String)Imcms.class.getName());
    private static ImcmsServices services;
    private static BasicDataSource apiDataSource;
    private static BasicDataSource dataSource;

    private Imcms() {
    }

    public static synchronized ImcmsServices getServices() {
        if (null == services) {
            Imcms.start();
        }
        return services;
    }

    public static void start() throws StartupException {
        try {
            services = Imcms.createServices();
        }
        catch (Exception e) {
            throw new StartupException("imCMS could not be started. Please see the log file in WEB-INF/logs for details.", e);
        }
    }

    private static synchronized ImcmsServices createServices() {
        Properties serverprops = Imcms.getServerProperties();
        log.debug((Object)"Creating main DataSource.");
        dataSource = Imcms.createDataSource(serverprops);
        return new DefaultImcmsServices((DataSource)dataSource, serverprops);
    }

    public static synchronized DataSource getApiDataSource() {
        if (null == apiDataSource) {
            Properties serverprops = Imcms.getServerProperties();
            log.debug((Object)"Creating API DataSource.");
            apiDataSource = Imcms.createDataSource(serverprops);
        }
        return apiDataSource;
    }

    private static Properties getServerProperties() {
        try {
            return Prefs.getProperties(SERVER_PROPERTIES_FILENAME);
        }
        catch (IOException e) {
            log.fatal((Object)"Failed to initialize imCMS", (Throwable)e);
            throw new UnhandledException((Throwable)e);
        }
    }

    private static BasicDataSource createDataSource(Properties props) {
        String jdbcDriver = props.getProperty("JdbcDriver");
        String jdbcUrl = props.getProperty("JdbcUrl");
        String user = props.getProperty("User");
        String password = props.getProperty("Password");
        int maxConnectionCount = Integer.parseInt(props.getProperty("MaxConnectionCount"));
        log.debug((Object)("JdbcDriver = " + jdbcDriver));
        log.debug((Object)("JdbcUrl = " + jdbcUrl));
        log.debug((Object)("User = " + user));
        log.debug((Object)("MaxConnectionCount = " + maxConnectionCount));
        return Imcms.createDataSource(jdbcDriver, jdbcUrl, user, password, maxConnectionCount);
    }

    public static synchronized void restart() {
        Imcms.stop();
        Imcms.start();
    }

    public static void stop() {
        if (null != apiDataSource) {
            try {
                log.debug((Object)"Closing API DataSource.");
                apiDataSource.close();
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if (null != dataSource) {
            try {
                log.debug((Object)"Closing main DataSource.");
                dataSource.close();
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        Prefs.flush();
    }

    private static void logDatabaseVersion(BasicDataSource basicDataSource) throws SQLException {
        Connection connection = basicDataSource.getConnection();
        DatabaseMetaData metaData = connection.getMetaData();
        log.info((Object)("Database product version = " + metaData.getDatabaseProductVersion()));
        connection.close();
    }

    public static BasicDataSource createDataSource(String jdbcDriver, String jdbcUrl, String user, String password, int maxConnectionCount) {
        try {
            BasicDataSource basicDataSource = new BasicDataSource();
            basicDataSource.setDriverClassName(jdbcDriver);
            basicDataSource.setUsername(user);
            basicDataSource.setPassword(password);
            basicDataSource.setUrl(jdbcUrl);
            basicDataSource.setMaxActive(maxConnectionCount);
            basicDataSource.setMaxIdle(maxConnectionCount);
            basicDataSource.setDefaultAutoCommit(true);
            basicDataSource.setPoolPreparedStatements(true);
            Imcms.logDatabaseVersion(basicDataSource);
            return basicDataSource;
        }
        catch (Exception ex) {
            log.fatal((Object)("Failed to create connection pool. Url: " + jdbcUrl + " Driver: " + jdbcDriver), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static class StartupException
    extends RuntimeException {
        public StartupException(String message, Exception e) {
            super(message, e);
        }
    }
}

