/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.util.MultipartHttpServletRequest;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.document.TemplateMapper;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class TemplateAdd
extends HttpServlet {
    private static final String REQUEST_PARAMETER__FILE = "file";
    private static final String REQUEST_PARAMETER__OVERWRITE = "overwrite";
    private static final String REQUEST_PARAMETER__NAME = "name";
    private static final String REQUEST_PARAMETER__ACTION = "action";
    private static final String REQUEST_PARAMETER__LANGUAGE = "language";
    private static final String REQUEST_PARAMETER__DEMO = "demo";
    private static final String REQUEST_PARAMETER__TEMPLATE = "template";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            Utility.redirectToStartDocument(req, res);
            return;
        }
        ServletOutputStream out = res.getOutputStream();
        TemplateMapper templateMapper = imcref.getTemplateMapper();
        if (req.getParameter(REQUEST_PARAMETER__ACTION) != null) {
            if (req.getParameter(REQUEST_PARAMETER__ACTION).equals("noCacheImageView")) {
                String mimeType;
                byte[] htmlStr;
                String templateIdString = req.getParameter(REQUEST_PARAMETER__TEMPLATE);
                Object[] suffixAndStream = templateMapper.getDemoTemplate(Integer.parseInt(templateIdString));
                byte[] temp = (byte[])suffixAndStream[1];
                if (temp == null || temp.length == 0) {
                    htmlStr = imcref.getAdminTemplate("no_demotemplate.html", user, null).getBytes("8859_1");
                    mimeType = "text/html";
                } else {
                    mimeType = this.getServletContext().getMimeType(templateIdString + "." + suffixAndStream[0]);
                    htmlStr = temp;
                }
                res.setContentType(mimeType);
                out.write(htmlStr);
            } else if (req.getParameter(REQUEST_PARAMETER__ACTION).equals("return")) {
                Utility.setDefaultHtmlContentType(res);
                ArrayList<String> vec = new ArrayList<String>();
                vec.add("#buttonName#");
                vec.add("return");
                vec.add("#formAction#");
                vec.add("TemplateAdmin");
                vec.add("#formTarget#");
                vec.add("_top");
                byte[] htmlStr = imcref.getAdminTemplate("back_button.html", user, vec).getBytes("8859_1");
                out.write(htmlStr);
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String htmlStr;
        boolean overwrite;
        MultipartHttpServletRequest.DataSourceFileItem file;
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            Utility.redirectToStartDocument(req, res);
            return;
        }
        TemplateMapper templateMapper = imcref.getTemplateMapper();
        PrintWriter out = res.getWriter();
        MultipartHttpServletRequest request = new MultipartHttpServletRequest(req);
        if (request.getParameter("cancel") != null) {
            res.sendRedirect("TemplateAdmin");
            return;
        }
        String language = request.getParameter(REQUEST_PARAMETER__LANGUAGE);
        boolean demo = request.getParameter(REQUEST_PARAMETER__DEMO) != null;
        String templateIdString = null;
        String simpleName = null;
        if (demo) {
            templateIdString = request.getParameter(REQUEST_PARAMETER__TEMPLATE);
            if (templateIdString == null || templateIdString.equals("")) {
                ArrayList<String> vec = new ArrayList<String>();
                vec.add("#language#");
                vec.add(language);
                String htmlStr2 = imcref.getAdminTemplate("templatedemo_upload_template_blank.html", user, vec);
                Utility.setDefaultHtmlContentType(res);
                out.print(htmlStr2);
                return;
            }
            if (request.getParameter("delete_demo") != null) {
                String htmlStr3;
                templateMapper.deleteDemoTemplate(Integer.parseInt(templateIdString));
                String[] list = templateMapper.getDemoTemplateIds();
                Object[] parameters = new String[]{language};
                String[] temp = (String[])imcref.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("select template_id, simple_name from templates where lang_prefix = ? order by simple_name", parameters, Utility.STRING_ARRAY_HANDLER));
                ArrayList<String> vec = new ArrayList<String>();
                vec.add("#language#");
                vec.add(language);
                if (temp.length > 0) {
                    String temps = "";
                    for (int i = 0; i < temp.length; i += 2) {
                        int tmp = Integer.parseInt(temp[i]);
                        for (int j = 0; j < list.length; ++j) {
                            if (Integer.parseInt(list[j]) != tmp) continue;
                            temp[i + 1] = "*" + temp[i + 1];
                            break;
                        }
                        temps = temps + "<option value=\"" + temp[i] + "\">" + temp[i + 1] + "</option>";
                    }
                    vec.add("#templates#");
                    vec.add(temps);
                    htmlStr3 = imcref.getAdminTemplate("templatedemo_upload.html", user, vec);
                } else {
                    htmlStr3 = imcref.getAdminTemplate("template_no_langtemplates.html", user, vec);
                }
                Utility.setDefaultHtmlContentType(res);
                out.print(htmlStr3);
                return;
            }
            if (request.getParameter("view_demo") != null) {
                Object[] suffixAndStream = templateMapper.getDemoTemplate(Integer.parseInt(templateIdString));
                Utility.setDefaultHtmlContentType(res);
                if (suffixAndStream == null) {
                    String htmlStr4 = imcref.getAdminTemplate("no_demotemplate.html", user, null);
                    out.print(htmlStr4);
                    return;
                }
                byte[] temp = (byte[])suffixAndStream[1];
                if (temp == null) {
                    String htmlStr5 = imcref.getAdminTemplate("no_demotemplate.html", user, null);
                    out.print(htmlStr5);
                    return;
                }
                String redirect = "TemplateAdd?action=noCacheImageView&template=" + templateIdString + "&bogus=" + (int)(1000.0 * Math.random());
                out.print("<html><head><title></title></head><frameset rows=\"80,*\" frameborder=\"NO\" border=\"0\" framespacing=\"0\"><frame name=\"topFrame\" scrolling=\"NO\" noresize src=\"TemplateAdd?action=return\"><frame name=\"mainFrame\" src=\"" + redirect + "\">" + "</frameset>" + "<noframes><body>" + redirect + "</body></noframes></html>");
            }
        } else {
            simpleName = request.getParameter(REQUEST_PARAMETER__NAME);
            if (simpleName == null || simpleName.equals("")) {
                ArrayList<String> vec = new ArrayList<String>();
                vec.add("#language#");
                vec.add(language);
                String htmlStr6 = imcref.getAdminTemplate("template_upload_name_blank.html", user, vec);
                Utility.setDefaultHtmlContentType(res);
                out.print(htmlStr6);
                return;
            }
        }
        if ((file = request.getParameterFileItem(REQUEST_PARAMETER__FILE)) == null || file.getSize() == 0L) {
            ArrayList<String> vec = new ArrayList<String>();
            vec.add("#language#");
            vec.add(language);
            String htmlStr7 = demo ? imcref.getAdminTemplate("templatedemo_upload_file_blank.html", user, vec) : imcref.getAdminTemplate("template_upload_file_blank.html", user, vec);
            Utility.setDefaultHtmlContentType(res);
            out.print(htmlStr7);
            return;
        }
        String filename = request.getParameterFileItem(REQUEST_PARAMETER__FILE).getName();
        File fn = new File(filename);
        filename = fn.getName();
        boolean bl = overwrite = request.getParameter(REQUEST_PARAMETER__OVERWRITE) != null;
        if (demo) {
            String suffix = StringUtils.substringAfterLast((String)filename, (String)".").toLowerCase();
            ArrayList<String> vec = new ArrayList<String>();
            if (!(suffix.equals("jpg") || suffix.equals("jpeg") || suffix.equals("png") || suffix.equals("gif") || suffix.equals("htm") || suffix.equals("html"))) {
                vec.add("#language#");
                vec.add(language);
                htmlStr = imcref.getAdminTemplate("templatedemo_upload_done.html", user, vec);
            } else {
                vec.add("#language#");
                vec.add(language);
                try {
                    imcref.getTemplateMapper().saveDemoTemplate(Integer.parseInt(templateIdString), file.getInputStream(), suffix);
                    htmlStr = imcref.getAdminTemplate("templatedemo_upload_done.html", user, vec);
                }
                catch (IOException ex) {
                    htmlStr = imcref.getAdminTemplate("templatedemo_upload_error.html", user, vec);
                }
            }
        } else {
            int result = imcref.getTemplateMapper().saveTemplate(simpleName, filename, file.getInputStream(), overwrite, language);
            if (result == -2) {
                ArrayList<String> vec = new ArrayList<String>();
                vec.add("#language#");
                vec.add(language);
                htmlStr = imcref.getAdminTemplate("template_upload_error.html", user, vec);
            } else if (result == -1) {
                ArrayList<String> vec = new ArrayList<String>();
                vec.add("#language#");
                vec.add(language);
                htmlStr = imcref.getAdminTemplate("template_upload_file_exists.html", user, vec);
            } else {
                TemplateDomainObject template = templateMapper.getTemplateByName(simpleName);
                String[] templateGroupIdStrings = request.getParameterValues("templategroup");
                if (templateGroupIdStrings != null) {
                    for (int i = 0; i < templateGroupIdStrings.length; ++i) {
                        int templateGroupId = Integer.parseInt(templateGroupIdStrings[i]);
                        TemplateGroupDomainObject templateGroup = templateMapper.getTemplateGroupById(templateGroupId);
                        templateMapper.removeTemplateFromGroup(template, templateGroup);
                        templateMapper.addTemplateToGroup(template, templateGroup);
                    }
                }
                ArrayList<String> vec = new ArrayList<String>();
                vec.add("#language#");
                vec.add(language);
                htmlStr = imcref.getAdminTemplate("template_upload_done.html", user, vec);
            }
        }
        Utility.setDefaultHtmlContentType(res);
        out.print(htmlStr);
    }
}

