/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.mapping.DocumentMapper;
import imcode.server.Imcms;
import imcode.server.document.DocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DocumentReferences
extends HttpServlet {
    public static final String REQUEST_PARAMETER__REFERENCED_DOCUMENT_ID = "id";
    public static final String REQUEST_PARAMETER__RETURNURL = "returnurl";
    public static final String REQUEST_PARAMETER__BUTTON_RETURN = "return";
    public static final String REQUEST_ATTRIBUTE__DOCUMENT_MENU_PAIRS = "documentMenuPairs";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        if (!user.isSuperAdmin()) {
            Utility.redirectToStartDocument(request, response);
            return;
        }
        if (null != request.getParameter(REQUEST_PARAMETER__BUTTON_RETURN)) {
            request.getRequestDispatcher(request.getParameter(REQUEST_PARAMETER__RETURNURL)).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (null != request.getParameter(REQUEST_PARAMETER__REFERENCED_DOCUMENT_ID)) {
            this.forwardToDocumentReferencesPage(request, response, user);
            return;
        }
    }

    private void forwardToDocumentReferencesPage(HttpServletRequest request, HttpServletResponse response, UserDomainObject user) throws IOException, ServletException {
        int documentId = Integer.parseInt(request.getParameter(REQUEST_PARAMETER__REFERENCED_DOCUMENT_ID));
        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
        DocumentDomainObject document = documentMapper.getDocument(documentId);
        DocumentMapper.TextDocumentMenuIndexPair[] documentMenuPairs = documentMapper.getDocumentMenuPairsContainingDocument(document);
        request.setAttribute(REQUEST_ATTRIBUTE__DOCUMENT_MENU_PAIRS, (Object)documentMenuPairs);
        request.getRequestDispatcher("/imcms/" + user.getLanguageIso639_2() + "/jsp/document_references.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

