/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import imcode.util.Utility;
import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MenuRss
extends HttpServlet {
    private static final String IMCMS_MENU_NAMESPACE_URI = "imcms:menu";
    private static final String DUBLIN_CORE_METADATA_TERMS_NAMESPACE_URI = "http://purl.org/dc/terms/";
    private static final String DUBLIN_CORE_METADATA_ELEMENTS_NAMESPACE_URI = "http://purl.org/dc/elements/1.1/";
    private static final String RFC822_DATE_PATTERN = "EEE, d MMM yyyy HH:mm:ss Z";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ContentManagementSystem cms = ContentManagementSystem.fromRequest((ServletRequest)request);
            int documentId = Integer.parseInt(request.getParameter("meta_id"));
            int menuIndex = Integer.parseInt(request.getParameter("menu_index"));
            DocumentService documentService = cms.getDocumentService();
            TextDocument document = documentService.getTextDocument(documentId);
            if (null == document) {
                response.sendError(404);
            } else {
                Document xmlDocument = this.createRssDocument(request, document, menuIndex);
                Utility.outputXmlDocument(response, xmlDocument);
            }
        }
        catch (NoPermissionException e) {
            response.sendError(403);
        }
        catch (ClassCastException nfe) {
            response.sendError(403);
        }
        catch (NumberFormatException nfe) {
            response.sendError(400);
        }
        catch (ParserConfigurationException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private Document createRssDocument(HttpServletRequest request, TextDocument document, int menuIndex) throws ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        Document xmlDocument = documentBuilder.newDocument();
        Element rssElement = this.createRssElement(xmlDocument, document, menuIndex, request);
        xmlDocument.appendChild(rssElement);
        return xmlDocument;
    }

    private Element createRssElement(Document xmlDocument, TextDocument document, int menuIndex, HttpServletRequest request) {
        Element rssElement = xmlDocument.createElement("rss");
        rssElement.setAttribute("xmlns:imcms", IMCMS_MENU_NAMESPACE_URI);
        rssElement.setAttribute("xmlns:dcterms", DUBLIN_CORE_METADATA_TERMS_NAMESPACE_URI);
        rssElement.setAttribute("xmlns:dc", DUBLIN_CORE_METADATA_ELEMENTS_NAMESPACE_URI);
        rssElement.setAttribute("version", "2.0");
        Element channelElement = this.createChannelElement(xmlDocument, document, menuIndex, request);
        rssElement.appendChild(channelElement);
        return rssElement;
    }

    private Element createChannelElement(Document xmlDocument, TextDocument document, int menuIndex, HttpServletRequest request) {
        Element channelElement = xmlDocument.createElement("channel");
        channelElement.appendChild(this.createTextElement(xmlDocument, "title", document.getHeadline()));
        channelElement.appendChild(this.createTextElement(xmlDocument, "link", this.getUrlToDocument(request, document)));
        channelElement.appendChild(this.createTextElement(xmlDocument, "description", document.getMenuText()));
        this.appendMenuItems(xmlDocument, channelElement, document, menuIndex, request);
        return channelElement;
    }

    private String getUrlToDocument(HttpServletRequest request, com.imcode.imcms.api.Document document) {
        String requestUrl = request.getRequestURL().toString();
        requestUrl = StringUtils.substringBefore((String)requestUrl, (String)"/servlet/") + Utility.getContextRelativePathToDocumentWithId(document.getId());
        return requestUrl;
    }

    private void appendMenuItems(Document xmlDocument, Element channelElement, TextDocument document, int menuIndex, HttpServletRequest request) {
        SimpleDateFormat rfc822DateFormat = new SimpleDateFormat(RFC822_DATE_PATTERN, Locale.ENGLISH);
        FastDateFormat iso8601DateFormat = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT;
        TextDocument.MenuItem[] visibleMenuItems = document.getMenu(menuIndex).getVisibleMenuItems();
        for (int i = 0; i < visibleMenuItems.length; ++i) {
            TextDocument.MenuItem menuItem = visibleMenuItems[i];
            Element itemElement = this.createItemElement(xmlDocument, menuItem, request, rfc822DateFormat, (Format)iso8601DateFormat);
            channelElement.appendChild(itemElement);
        }
    }

    private Element createItemElement(Document xmlDocument, TextDocument.MenuItem menuItem, HttpServletRequest request, DateFormat rfc822DateFormat, Format iso8601DateFormat) {
        Element itemElement = xmlDocument.createElement("item");
        com.imcode.imcms.api.Document itemDocument = menuItem.getDocument();
        Date modifiedDatetime = itemDocument.getModifiedDatetime();
        Date createdDatetime = itemDocument.getCreatedDatetime();
        Date publicationStartDatetime = itemDocument.getPublicationStartDatetime();
        User creator = itemDocument.getCreator();
        this.appendTextElement(itemElement, "title", itemDocument.getHeadline());
        this.appendTextElement(itemElement, "link", this.getUrlToDocument(request, itemDocument));
        this.appendTextElement(itemElement, "description", itemDocument.getMenuText());
        this.appendTextElement(itemElement, "pubDate", rfc822DateFormat.format(publicationStartDatetime));
        this.appendTextElement(itemElement, "author", creator.getEmailAddress());
        this.appendTextElementNS(itemElement, DUBLIN_CORE_METADATA_ELEMENTS_NAMESPACE_URI, "dc:creator", creator.getFirstName() + " " + creator.getLastName());
        this.appendTextElementNS(itemElement, DUBLIN_CORE_METADATA_TERMS_NAMESPACE_URI, "dcterms:created", iso8601DateFormat.format(createdDatetime));
        this.appendTextElementNS(itemElement, DUBLIN_CORE_METADATA_TERMS_NAMESPACE_URI, "dcterms:modified", iso8601DateFormat.format(modifiedDatetime));
        this.appendTextElementNS(itemElement, IMCMS_MENU_NAMESPACE_URI, "imcms:target", itemDocument.getTarget());
        this.appendTextElementNS(itemElement, IMCMS_MENU_NAMESPACE_URI, "imcms:treeKey", menuItem.getTreeKey().toString());
        return itemElement;
    }

    private void appendTextElementNS(Element parentElement, String namespaceUri, String qualifiedName, String text) {
        parentElement.appendChild(this.createTextElementNS(parentElement.getOwnerDocument(), namespaceUri, qualifiedName, text));
    }

    private void appendTextElement(Element parentElement, String tagName, String text) {
        parentElement.appendChild(this.createTextElement(parentElement.getOwnerDocument(), tagName, text));
    }

    private Element createTextElementNS(Document xmlDocument, String namespaceUri, String qualifiedName, String text) {
        Element treeKeyElement = xmlDocument.createElementNS(namespaceUri, qualifiedName);
        treeKeyElement.appendChild(xmlDocument.createTextNode(text));
        return treeKeyElement;
    }

    private Element createTextElement(Document xmlDocument, String tagName, String text) {
        Element element = xmlDocument.createElement(tagName);
        element.appendChild(xmlDocument.createTextNode(text));
        return element;
    }
}

