/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentGetterWrapper;
import imcode.util.CompositeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;

public class FragmentingDocumentGetter
extends DocumentGetterWrapper {
    private static final int DOCUMENTS_PER_FRAGMENT = 50;
    private static final Logger log = Logger.getLogger((Class)FragmentingDocumentGetter.class);

    public FragmentingDocumentGetter(DocumentGetter documentGetter) {
        super(documentGetter);
    }

    public List getDocuments(Collection documentIds) {
        if (documentIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList documentIdList = new ArrayList(documentIds);
        CompositeList compositeDocumentList = new CompositeList();
        for (int i = 0; i < documentIds.size(); i += 50) {
            int toIndex = Math.min(documentIds.size(), i + 50);
            List documentIdSubList = documentIdList.subList(i, toIndex);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            List documentList = super.getDocuments(documentIdSubList);
            stopWatch.stop();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Got " + documentList.size() + " documents in " + stopWatch.getTime() + "ms."));
            }
            compositeDocumentList.addList(documentList);
        }
        return compositeDocumentList;
    }
}

