/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseException;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentStoringVisitor;
import com.imcode.imcms.mapping.TextDocumentInitializer;
import imcode.server.document.BrowserDocumentDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.HtmlDocumentDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.util.Utility;
import imcode.util.io.FileInputStreamSource;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.UnhandledException;

class DocumentInitializingVisitor
extends DocumentVisitor {
    private DocumentMapper documentMapper;
    private final Database database;
    private static final String SQL__SELECT_FILE_DOCUMENT_FILES = "SELECT variant_name, filename, mime, created_as_image, default_variant FROM fileupload_docs WHERE meta_id = ? ORDER BY default_variant DESC, variant_name";
    private TextDocumentInitializer textDocumentInitializer;

    DocumentInitializingVisitor(DocumentGetter documentGetter, Collection documentIds, DocumentMapper documentMapper) {
        this.database = documentMapper.getDatabase();
        this.documentMapper = documentMapper;
        this.textDocumentInitializer = new TextDocumentInitializer(this.database, documentGetter, documentIds);
    }

    public void visitBrowserDocument(BrowserDocumentDomainObject document) {
        String[][] sqlResult;
        try {
            Object[] parameters = new String[]{"" + document.getId()};
            String sqlStr = "SELECT to_meta_id, browser_id FROM browser_docs WHERE meta_id = ?";
            sqlResult = (String[][])this.database.execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
        for (int i = 0; i < sqlResult.length; ++i) {
            String[] sqlRow = sqlResult[i];
            int toMetaId = Integer.parseInt(sqlRow[0]);
            int browserId = Integer.parseInt(sqlRow[1]);
            BrowserDocumentDomainObject.Browser browser = this.documentMapper.getBrowserById(browserId);
            document.setBrowserDocumentId(browser, toMetaId);
        }
    }

    public void visitFileDocument(final FileDocumentDomainObject document) {
        Object[] parameters = new String[]{"" + document.getId()};
        this.database.execute((DatabaseCommand)new SqlQueryCommand(SQL__SELECT_FILE_DOCUMENT_FILES, parameters, new ResultSetHandler(){

            public Object handle(ResultSet resultSet) throws SQLException {
                while (resultSet.next()) {
                    File oldlyNamedFileForFileDocument;
                    String fileId = resultSet.getString(1);
                    FileDocumentDomainObject.FileDocumentFile file = new FileDocumentDomainObject.FileDocumentFile();
                    file.setFilename(resultSet.getString(2));
                    file.setMimeType(resultSet.getString(3));
                    file.setCreatedAsImage(0 != resultSet.getInt(4));
                    File fileForFileDocument = DocumentStoringVisitor.getFileForFileDocumentFile(document.getId(), fileId);
                    if (!fileForFileDocument.exists() && (oldlyNamedFileForFileDocument = new File(fileForFileDocument.getParentFile(), fileForFileDocument.getName() + "_se")).exists()) {
                        fileForFileDocument = oldlyNamedFileForFileDocument;
                    }
                    file.setInputStreamSource(new FileInputStreamSource(fileForFileDocument));
                    document.addFile(fileId, file);
                    boolean isDefaultFile = 0 != resultSet.getInt(5);
                    if (!isDefaultFile) continue;
                    document.setDefaultFileId(fileId);
                }
                return null;
            }
        }));
    }

    public void visitHtmlDocument(HtmlDocumentDomainObject htmlDocument) {
        String html;
        try {
            Object[] parameters = new String[]{"" + htmlDocument.getId()};
            String sqlStr = "SELECT frame_set FROM frameset_docs WHERE meta_id = ?";
            html = (String)this.database.execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.SINGLE_STRING_HANDLER));
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
        htmlDocument.setHtml(html);
    }

    public void visitUrlDocument(UrlDocumentDomainObject document) {
        String url;
        try {
            Object[] parameters = new String[]{"" + document.getId()};
            url = (String)this.database.execute((DatabaseCommand)new SqlQueryCommand("SELECT url_ref FROM url_docs WHERE meta_id = ?", parameters, Utility.SINGLE_STRING_HANDLER));
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
        document.setUrl(url);
    }

    public void visitTextDocument(TextDocumentDomainObject document) {
        this.textDocumentInitializer.initialize(document);
    }
}

