/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.imcms.mapping.DocumentStoringVisitor;
import imcode.server.ImcmsServices;
import imcode.server.document.HtmlDocumentDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;

public class DocumentCreatingVisitor
extends DocumentStoringVisitor {
    public DocumentCreatingVisitor(Database database, ImcmsServices services) {
        super(database, services);
    }

    public void visitHtmlDocument(HtmlDocumentDomainObject document) {
        String[] htmlDocumentColumns = new String[]{"meta_id", "frame_set"};
        String sqlUrlDocsInsertStr = DocumentCreatingVisitor.makeSqlInsertString("frameset_docs", htmlDocumentColumns);
        Object[] parameters = new String[]{"" + document.getId(), document.getHtml()};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlUrlDocsInsertStr, parameters))).intValue();
    }

    public void visitUrlDocument(UrlDocumentDomainObject document) {
        String[] urlDocumentColumns = new String[]{"meta_id", "frame_name", "target", "url_ref", "url_txt", "lang_prefix"};
        String sqlUrlDocsInsertStr = DocumentStoringVisitor.makeSqlInsertString("url_docs", urlDocumentColumns);
        Object[] parameters = new String[]{"" + document.getId(), "", "", document.getUrl(), "", ""};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlUrlDocsInsertStr, parameters))).intValue();
    }

    public void visitTextDocument(TextDocumentDomainObject textDocument) {
        String sqlTextDocsInsertStr = "INSERT INTO text_docs (meta_id, template_id, group_id, default_template, default_template_1, default_template_2) VALUES (?,?,?,?,?,?)";
        int templateId = textDocument.getTemplateId();
        Integer defaultTemplate = textDocument.getDefaultTemplateId();
        Integer defaultTemplateForRestricted1 = textDocument.getDefaultTemplateIdForRestricted1();
        Integer defaultTemplateForRestricted2 = textDocument.getDefaultTemplateIdForRestricted2();
        int templateGroupId = textDocument.getTemplateGroupId();
        int textDocumentId = textDocument.getId();
        Object[] parameters = new String[]{"" + textDocumentId, "" + templateId, "" + templateGroupId, null != defaultTemplate ? "" + defaultTemplate : null, null != defaultTemplateForRestricted1 ? "" + defaultTemplateForRestricted1 : "-1", null != defaultTemplateForRestricted2 ? "" + defaultTemplateForRestricted2 : "-1"};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlTextDocsInsertStr, parameters))).intValue();
        this.updateTextDocumentTexts(textDocument);
        this.updateTextDocumentImages(textDocument);
        this.updateTextDocumentIncludes(textDocument);
        this.updateTextDocumentMenus(textDocument);
    }
}

