/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.flow;

import imcode.util.Html;
import imcode.util.HttpSessionAttribute;
import imcode.util.HttpSessionUtils;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class Page
implements Serializable,
HttpSessionAttribute {
    public static final String IN_REQUEST = "page";
    private String sessionAttributeName;

    public static String htmlHidden(HttpServletRequest request) {
        return Html.hidden(IN_REQUEST, Page.fromRequest(request).getSessionAttributeName());
    }

    public static Page fromRequest(HttpServletRequest request) {
        return (Page)HttpSessionUtils.getSessionAttributeWithNameInRequest(request, IN_REQUEST);
    }

    public void forward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSessionUtils.setSessionAttributeAndSetNameInRequestAttribute(this, request, IN_REQUEST);
        request.getRequestDispatcher(this.getPath(request)).forward((ServletRequest)request, (ServletResponse)response);
    }

    public String getSessionAttributeName() {
        return this.sessionAttributeName;
    }

    public void setSessionAttributeName(String sessionAttributeName) {
        this.sessionAttributeName = sessionAttributeName;
    }

    protected void removeFromSession(HttpServletRequest request) {
        HttpSessionUtils.removeSessionAttribute(request, this.getSessionAttributeName());
    }

    public abstract void dispatch(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

    public abstract String getPath(HttpServletRequest var1);
}

