/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.MockContentManagementSystem;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.TextDocument;
import imcode.server.MockImcmsServices;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.MockRoleGetter;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class TestDocument
extends TestCase {
    public void testGetAllRolesMappedToPermissions() {
        MockContentManagementSystem contentManagementSystem = new MockContentManagementSystem();
        contentManagementSystem.setCurrentInternalUser(new UserDomainObject());
        MockImcmsServices imcmsServices = new MockImcmsServices();
        contentManagementSystem.setInternal(imcmsServices);
        imcmsServices.setRoleGetter(new MockRoleGetter());
        TextDocumentDomainObject textDocument = new TextDocumentDomainObject();
        textDocument.setDocumentPermissionSetTypeForRoleId(RoleId.USERADMIN, DocumentPermissionSetTypeDomainObject.FULL);
        textDocument.setDocumentPermissionSetTypeForRoleId(RoleId.USERS, DocumentPermissionSetTypeDomainObject.FULL);
        textDocument.setDocumentPermissionSetTypeForRoleId(new RoleId(3), DocumentPermissionSetTypeDomainObject.FULL);
        TextDocument doc = new TextDocument(textDocument, (ContentManagementSystem)contentManagementSystem);
        Map allRolesMappedToPermissions = doc.getRolesMappedToPermissions();
        Set roles = allRolesMappedToPermissions.keySet();
        TestDocument.assertTrue((boolean)CollectionUtils.exists(roles, (Predicate)new RoleIdEqualsPredicate(RoleId.USERADMIN)));
        TestDocument.assertTrue((boolean)CollectionUtils.exists(roles, (Predicate)new RoleIdEqualsPredicate(RoleId.USERS)));
        TestDocument.assertTrue((boolean)CollectionUtils.exists(roles, (Predicate)new RoleIdEqualsPredicate(new RoleId(3))));
    }

    public void testSearchDisabled() {
        TextDocumentDomainObject documentDO = new TextDocumentDomainObject();
        TextDocument document = new TextDocument(documentDO, null);
        TestDocument.assertFalse((boolean)document.isSearchDisabled());
        documentDO.setSearchDisabled(true);
        TestDocument.assertTrue((boolean)document.isSearchDisabled());
        document.setSearchDisabled(false);
        TestDocument.assertFalse((boolean)documentDO.isSearchDisabled());
    }

    public void testKeywords() {
        TextDocumentDomainObject documentDO = new TextDocumentDomainObject();
        TextDocument document = new TextDocument(documentDO, null);
        HashSet<String> keywords = new HashSet<String>();
        keywords.add("foo");
        documentDO.setKeywords(keywords);
        TestDocument.assertTrue((boolean)document.getKeywords().contains("foo"));
    }

    public void testLinkableByOtherUsers() {
        TextDocumentDomainObject documentDO = new TextDocumentDomainObject();
        TextDocument document = new TextDocument(documentDO, null);
        TestDocument.assertFalse((boolean)document.isLinkableByOtherUsers());
        documentDO.setLinkableByOtherUsers(true);
        TestDocument.assertTrue((boolean)document.isLinkableByOtherUsers());
        document.setLinkableByOtherUsers(false);
        TestDocument.assertFalse((boolean)documentDO.isLinkableByOtherUsers());
    }

    private static class RoleIdEqualsPredicate
    implements Predicate {
        private final RoleId roleId;

        RoleIdEqualsPredicate(RoleId roleName) {
            this.roleId = roleName;
        }

        public boolean evaluate(Object o) {
            return ((Role)o).getId() == this.roleId.intValue();
        }
    }
}

