/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LazilyLoadedObject
implements Serializable,
Cloneable {
    private Loader loader;
    private Copyable object;

    public LazilyLoadedObject(Loader loader) {
        this.loader = loader;
    }

    public Object get() {
        this.load();
        return this.object;
    }

    public void load() {
        if (!this.isLoaded()) {
            this.object = this.loader.load().copy();
            this.setLoaded();
        }
    }

    private boolean isLoaded() {
        return null == this.loader;
    }

    public Object clone() throws CloneNotSupportedException {
        LazilyLoadedObject clone = (LazilyLoadedObject)super.clone();
        if (null != this.object) {
            clone.object = this.object.copy();
        }
        return clone;
    }

    public void set(Copyable o) {
        this.setLoaded();
        this.object = o;
    }

    private void setLoaded() {
        this.loader = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.load();
        out.defaultWriteObject();
    }

    public static interface Copyable
    extends Serializable {
        public Copyable copy();
    }

    public static interface Loader
    extends Serializable {
        public Copyable load();
    }
}

