/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import imcode.server.user.Authenticator;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserAlreadyExistsException;
import imcode.server.user.UserAndRoleRegistry;
import imcode.server.user.UserDomainObject;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class ExternalizedImcmsAuthenticatorAndUserRegistry
implements UserAndRoleRegistry,
Authenticator {
    private ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserMapperAndRole;
    private Authenticator externalAuthenticator;
    private UserAndRoleRegistry externalUserRegistry;
    private String defaultLanguage;
    private Logger log = Logger.getLogger((Class)ExternalizedImcmsAuthenticatorAndUserRegistry.class);

    public ExternalizedImcmsAuthenticatorAndUserRegistry(ImcmsAuthenticatorAndUserAndRoleMapper imcmsAndRole, Authenticator externalAuthenticator, UserAndRoleRegistry externalUserRegistry, String defaultLanguage) throws IllegalArgumentException {
        if (null == externalAuthenticator != (null == externalUserRegistry)) {
            throw new IllegalArgumentException("External authenticator and external usermapper should both be either set or not set.");
        }
        this.imcmsAuthenticatorAndUserMapperAndRole = imcmsAndRole;
        this.externalAuthenticator = externalAuthenticator;
        this.externalUserRegistry = externalUserRegistry;
        this.defaultLanguage = defaultLanguage;
    }

    public void synchRolesWithExternal() {
        if (null != this.externalUserRegistry) {
            String[] externalRoleNames = this.externalUserRegistry.getAllRoleNames();
            this.imcmsAuthenticatorAndUserMapperAndRole.addRoleNames(externalRoleNames);
        }
    }

    public boolean authenticate(String loginName, String password) {
        NDC.push((String)"authenticate");
        boolean userAuthenticatesInImcms = false;
        if (password.length() >= 4) {
            userAuthenticatesInImcms = this.imcmsAuthenticatorAndUserMapperAndRole.authenticate(loginName, password);
        }
        boolean userAuthenticatesInExternal = false;
        if (!userAuthenticatesInImcms && null != this.externalAuthenticator && password.length() > 0) {
            userAuthenticatesInExternal = this.externalAuthenticator.authenticate(loginName, password);
        }
        NDC.pop();
        return userAuthenticatesInImcms || userAuthenticatesInExternal;
    }

    public UserDomainObject getUser(String loginName) {
        NDC.push((String)"getUser");
        UserDomainObject imcmsUser = this.imcmsAuthenticatorAndUserMapperAndRole.getUser(loginName);
        boolean imcmsUserExists = null != imcmsUser;
        boolean imcmsUserIsInternal = imcmsUserExists && !imcmsUser.isImcmsExternal();
        UserDomainObject result = imcmsUserIsInternal ? imcmsUser : this.getExternalUser(loginName, imcmsUser);
        NDC.pop();
        return result;
    }

    private UserDomainObject getExternalUser(String loginName, UserDomainObject imcmsUser) {
        UserDomainObject result;
        boolean externalUserExists;
        UserDomainObject externalUser = this.getUserFromOtherUserMapper(loginName);
        boolean bl = externalUserExists = null != externalUser;
        if (externalUserExists) {
            result = this.synchExternalUserInImcms(loginName, externalUser, imcmsUser);
        } else {
            if (null != imcmsUser) {
                this.deactivateExternalUserInImcms(loginName, imcmsUser);
            }
            result = null;
        }
        return result;
    }

    private UserDomainObject getUserFromOtherUserMapper(String loginName) {
        UserDomainObject result = null;
        if (null != this.externalUserRegistry) {
            result = this.externalUserRegistry.getUser(loginName);
        }
        if (null != result && null == result.getLanguageIso639_2()) {
            result.setLanguageIso639_2(this.defaultLanguage);
        }
        return result;
    }

    private UserDomainObject synchExternalUserInImcms(String loginName, UserDomainObject externalUser, UserDomainObject imcmsUser) {
        externalUser.setImcmsExternal(true);
        this.addExternalRolesToUser(externalUser);
        if (null != imcmsUser) {
            externalUser.setRoleIds(imcmsUser.getRoleIds());
            this.imcmsAuthenticatorAndUserMapperAndRole.saveUser(loginName, externalUser, null);
        } else {
            try {
                this.imcmsAuthenticatorAndUserMapperAndRole.addUser(externalUser, null);
            }
            catch (UserAlreadyExistsException shouldNotBeThrown) {
                throw new UnhandledException((Throwable)shouldNotBeThrown);
            }
        }
        return this.imcmsAuthenticatorAndUserMapperAndRole.getUser(loginName);
    }

    private void addExternalRolesToUser(UserDomainObject user) {
        String[] externalRoleNames = this.externalUserRegistry.getRoleNames(user);
        for (int i = 0; i < externalRoleNames.length; ++i) {
            String externalRoleName = externalRoleNames[i];
            RoleDomainObject externalRole = this.imcmsAuthenticatorAndUserMapperAndRole.getRoleByName(externalRoleName);
            if (null == externalRole) {
                externalRole = this.imcmsAuthenticatorAndUserMapperAndRole.addRole(externalRoleName);
            }
            if (externalRole.isAdminRole()) continue;
            user.addRoleId(externalRole.getId());
        }
    }

    private void deactivateExternalUserInImcms(String loginName, UserDomainObject imcmsUser) {
        imcmsUser.setActive(false);
        this.imcmsAuthenticatorAndUserMapperAndRole.saveUser(loginName, imcmsUser, null);
    }

    public String[] getRoleNames(UserDomainObject user) {
        String[] imcmsRoleNames = this.imcmsAuthenticatorAndUserMapperAndRole.getRoleNames(user);
        String[] externalRoleNames = this.externalUserRegistry.getRoleNames(user);
        String[] result = this.mergeAndDeleteDuplicates(imcmsRoleNames, externalRoleNames);
        this.log.debug((Object)("Roles from imcms and external: " + Arrays.asList(result)));
        return result;
    }

    private String[] mergeAndDeleteDuplicates(String[] imcmsRoleNames, String[] externalRoleNames) {
        HashSet<String> roleNames = new HashSet<String>(Arrays.asList(imcmsRoleNames));
        roleNames.addAll(Arrays.asList(externalRoleNames));
        return roleNames.toArray(new String[roleNames.size()]);
    }

    public String[] getAllRoleNames() {
        String[] imcmsRoleNames = this.imcmsAuthenticatorAndUserMapperAndRole.getAllRoleNames();
        String[] externalRoleNames = this.externalUserRegistry.getAllRoleNames();
        return this.mergeAndDeleteDuplicates(imcmsRoleNames, externalRoleNames);
    }
}

