/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import com.imcode.imcms.mapping.DocumentMenusMap;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.textdocument.CopyableHashMap;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.util.LazilyLoadedObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.UnhandledException;

public class TextDocumentDomainObject
extends DocumentDomainObject {
    private LazilyLoadedObject texts = new LazilyLoadedObject(new CopyableHashMapLoader());
    private LazilyLoadedObject images = new LazilyLoadedObject(new CopyableHashMapLoader());
    private LazilyLoadedObject includes = new LazilyLoadedObject(new CopyableHashMapLoader());
    private LazilyLoadedObject menus = new LazilyLoadedObject(new LazilyLoadedObject.Loader(){

        public LazilyLoadedObject.Copyable load() {
            return new DocumentMenusMap();
        }
    });
    private LazilyLoadedObject templateIds = new LazilyLoadedObject(new LazilyLoadedObject.Loader(){

        public LazilyLoadedObject.Copyable load() {
            return new TemplateIds();
        }
    });

    public TextDocumentDomainObject() {
        this(0);
    }

    public TextDocumentDomainObject(int documentId) {
        this.setId(documentId);
    }

    public void loadAllLazilyLoaded() {
        super.loadAllLazilyLoaded();
        this.texts.load();
        this.images.load();
        this.includes.load();
        this.menus.load();
        this.templateIds.load();
    }

    public Object clone() throws CloneNotSupportedException {
        TextDocumentDomainObject clone = (TextDocumentDomainObject)super.clone();
        clone.texts = (LazilyLoadedObject)this.texts.clone();
        clone.images = (LazilyLoadedObject)this.images.clone();
        clone.includes = (LazilyLoadedObject)this.includes.clone();
        clone.menus = (LazilyLoadedObject)this.menus.clone();
        clone.templateIds = (LazilyLoadedObject)this.templateIds.clone();
        return clone;
    }

    public DocumentTypeDomainObject getDocumentType() {
        return DocumentTypeDomainObject.TEXT;
    }

    public Set getChildDocumentIds() {
        HashSet<Integer> childDocuments = new HashSet<Integer>();
        Iterator iterator = this.getMenus().values().iterator();
        while (iterator.hasNext()) {
            MenuDomainObject menu = (MenuDomainObject)iterator.next();
            MenuItemDomainObject[] menuItems = menu.getMenuItems();
            for (int i = 0; i < menuItems.length; ++i) {
                MenuItemDomainObject menuItem = menuItems[i];
                childDocuments.add(new Integer(menuItem.getDocumentId()));
            }
        }
        return childDocuments;
    }

    public ImageDomainObject getImage(int imageIndex) {
        ImageDomainObject image = (ImageDomainObject)this.getImagesMap().get(new Integer(imageIndex));
        if (null == image) {
            image = new ImageDomainObject();
        }
        return image;
    }

    private Map getImagesMap() {
        return (Map)this.images.get();
    }

    public Integer getIncludedDocumentId(int includeIndex) {
        return (Integer)this.getIncludesMap().get(new Integer(includeIndex));
    }

    private Map getIncludesMap() {
        return (Map)this.includes.get();
    }

    public MenuDomainObject getMenu(int menuIndex) {
        Map menusMap = (Map)this.menus.get();
        MenuDomainObject menu = (MenuDomainObject)menusMap.get(new Integer(menuIndex));
        if (null == menu) {
            menu = new MenuDomainObject();
            this.setMenu(menuIndex, menu);
        }
        return menu;
    }

    public TextDomainObject getText(int textFieldIndex) {
        return (TextDomainObject)this.getTextsMap().get(new Integer(textFieldIndex));
    }

    private Map getTextsMap() {
        return (Map)this.texts.get();
    }

    public void accept(DocumentVisitor documentVisitor) {
        documentVisitor.visitTextDocument(this);
    }

    public void removeAllImages() {
        this.getImagesMap().clear();
    }

    public void removeAllIncludes() {
        this.getIncludesMap().clear();
    }

    public void removeAllMenus() {
        this.getMenusMap().clear();
    }

    private Map getMenusMap() {
        return (Map)this.menus.get();
    }

    public void removeAllTexts() {
        this.getTextsMap().clear();
    }

    public void setInclude(int includeIndex, int includedDocumentId) {
        this.getIncludesMap().put(new Integer(includeIndex), new Integer(includedDocumentId));
    }

    public void setMenu(int menuIndex, MenuDomainObject menu) {
        this.getMenusMap().put(new Integer(menuIndex), menu);
    }

    public void setText(int textIndex, TextDomainObject text) {
        this.getTextsMap().put(new Integer(textIndex), text);
    }

    public Map getImages() {
        return Collections.unmodifiableMap(this.getImagesMap());
    }

    public Map getIncludes() {
        return Collections.unmodifiableMap(this.getIncludesMap());
    }

    public Map getMenus() {
        return Collections.unmodifiableMap(this.getMenusMap());
    }

    public int getTemplateId() {
        return this.getTemplateIds().getTemplateId();
    }

    private TemplateIds getTemplateIds() {
        return (TemplateIds)this.templateIds.get();
    }

    public int getTemplateGroupId() {
        return this.getTemplateIds().getTemplateGroupId();
    }

    public Map getTexts() {
        return Collections.unmodifiableMap(this.getTextsMap());
    }

    public void setTemplateId(int v) {
        this.getTemplateIds().setTemplateId(v);
    }

    public void setTemplateGroupId(int v) {
        this.getTemplateIds().setTemplateGroupId(v);
    }

    public void setImage(int imageIndex, ImageDomainObject image) {
        this.getImagesMap().put(new Integer(imageIndex), image);
    }

    public Integer getDefaultTemplateId() {
        return this.getTemplateIds().getDefaultTemplateId();
    }

    public void setDefaultTemplateId(Integer defaultTemplateId) {
        this.getTemplateIds().setDefaultTemplateId(defaultTemplateId);
    }

    public void removeInclude(int includeIndex) {
        this.getIncludesMap().remove(new Integer(includeIndex));
    }

    public void setLazilyLoadedMenus(LazilyLoadedObject menus) {
        this.menus = menus;
    }

    public void setLazilyLoadedImages(LazilyLoadedObject images) {
        this.images = images;
    }

    public void setLazilyLoadedIncludes(LazilyLoadedObject includes) {
        this.includes = includes;
    }

    public void setLazilyLoadedTexts(LazilyLoadedObject texts) {
        this.texts = texts;
    }

    public Integer getDefaultTemplateIdForRestricted1() {
        return this.getTemplateIds().getDefaultTemplateIdForRestricted1();
    }

    public Integer getDefaultTemplateIdForRestricted2() {
        return this.getTemplateIds().getDefaultTemplateIdForRestricted2();
    }

    public void setDefaultTemplateIdForRestricted1(Integer defaultTemplateIdForRestricted1) {
        this.getTemplateIds().setDefaultTemplateIdForRestricted1(defaultTemplateIdForRestricted1);
    }

    public void setDefaultTemplateIdForRestricted2(Integer defaultTemplateIdForRestricted2) {
        this.getTemplateIds().setDefaultTemplateIdForRestricted2(defaultTemplateIdForRestricted2);
    }

    public void setLazilyLoadedTemplateIds(LazilyLoadedObject templateIds) {
        this.templateIds = templateIds;
    }

    public static class TemplateIds
    implements LazilyLoadedObject.Copyable,
    Cloneable {
        private int templateId;
        private int templateGroupId;
        private Integer defaultTemplateId;
        private Integer defaultTemplateIdForRestricted1;
        private Integer defaultTemplateIdForRestricted2;

        public LazilyLoadedObject.Copyable copy() {
            return (LazilyLoadedObject.Copyable)this.clone();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        public int getTemplateId() {
            return this.templateId;
        }

        public void setTemplateId(int templateId) {
            this.templateId = templateId;
        }

        public int getTemplateGroupId() {
            return this.templateGroupId;
        }

        public void setTemplateGroupId(int templateGroupId) {
            this.templateGroupId = templateGroupId;
        }

        public Integer getDefaultTemplateId() {
            return this.defaultTemplateId;
        }

        public void setDefaultTemplateId(Integer defaultTemplateId) {
            this.defaultTemplateId = defaultTemplateId;
        }

        public Integer getDefaultTemplateIdForRestricted1() {
            return this.defaultTemplateIdForRestricted1;
        }

        public void setDefaultTemplateIdForRestricted1(Integer defaultTemplateIdForRestricted1) {
            this.defaultTemplateIdForRestricted1 = defaultTemplateIdForRestricted1;
        }

        public Integer getDefaultTemplateIdForRestricted2() {
            return this.defaultTemplateIdForRestricted2;
        }

        public void setDefaultTemplateIdForRestricted2(Integer defaultTemplateIdForRestricted2) {
            this.defaultTemplateIdForRestricted2 = defaultTemplateIdForRestricted2;
        }
    }

    private static class CopyableHashMapLoader
    implements LazilyLoadedObject.Loader {
        private CopyableHashMapLoader() {
        }

        public LazilyLoadedObject.Copyable load() {
            return new CopyableHashMap();
        }
    }
}

