/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import com.imcode.util.ImageSize;
import imcode.server.document.textdocument.ImageSource;
import imcode.server.document.textdocument.NullImageSource;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class ImageDomainObject
implements Serializable {
    private ImageSource source;
    private String name = "";
    private int width;
    private int height;
    private int border;
    private String align = "";
    private String alternateText = "";
    private String lowResolutionUrl = "";
    private int verticalSpace;
    private int horizontalSpace;
    private String target = "";
    private String linkUrl = "";

    public String getName() {
        return this.name;
    }

    public ImageSize getDisplayImageSize() {
        ImageSize realImageSize = this.getRealImageSize();
        int wantedWidth = this.getWidth();
        int wantedHeight = this.getHeight();
        if (0 == wantedWidth && 0 != wantedHeight && 0 != realImageSize.getHeight()) {
            wantedWidth = (int)((double)realImageSize.getWidth() * ((double)wantedHeight / (double)realImageSize.getHeight()));
        } else if (0 == wantedHeight && 0 != wantedWidth && 0 != realImageSize.getWidth()) {
            wantedHeight = (int)((double)realImageSize.getHeight() * ((double)wantedWidth / (double)realImageSize.getWidth()));
        } else if (0 == wantedWidth && 0 == wantedHeight) {
            wantedWidth = realImageSize.getWidth();
            wantedHeight = realImageSize.getHeight();
        }
        return new ImageSize(wantedWidth, wantedHeight);
    }

    public ImageSize getRealImageSize() {
        ImageSize imageSize = new ImageSize(0, 0);
        if (!this.isEmpty()) {
            try {
                imageSize = this.source.getImageSize();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return imageSize;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBorder() {
        return this.border;
    }

    public String getAlign() {
        return this.align;
    }

    public String getAlternateText() {
        return this.alternateText;
    }

    public String getLowResolutionUrl() {
        return this.lowResolutionUrl;
    }

    public int getVerticalSpace() {
        return this.verticalSpace;
    }

    public int getHorizontalSpace() {
        return this.horizontalSpace;
    }

    public String getTarget() {
        return this.target;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public void setName(String image_name) {
        this.name = image_name;
    }

    public void setWidth(int image_width) {
        this.width = image_width;
    }

    public void setHeight(int image_height) {
        this.height = image_height;
    }

    public void setBorder(int image_border) {
        this.border = image_border;
    }

    public void setAlign(String image_align) {
        this.align = image_align;
    }

    public void setAlternateText(String alt_text) {
        this.alternateText = alt_text;
    }

    public void setLowResolutionUrl(String low_scr) {
        this.lowResolutionUrl = low_scr;
    }

    public void setVerticalSpace(int v_space) {
        this.verticalSpace = v_space;
    }

    public void setHorizontalSpace(int h_space) {
        this.horizontalSpace = h_space;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setLinkUrl(String image_ref_link) {
        this.linkUrl = image_ref_link;
    }

    public void setSourceAndClearSize(ImageSource source) {
        this.setSource(source);
        this.setWidth(0);
        this.setHeight(0);
    }

    public void setSource(ImageSource source) {
        this.source = source;
    }

    public boolean isEmpty() {
        return null == this.source || this.source.isEmpty();
    }

    public String getUrlPath(String contextPath) {
        String urlPathRelativeToContextPath = this.getUrlPathRelativeToContextPath();
        if (StringUtils.isBlank((String)urlPathRelativeToContextPath)) {
            return "";
        }
        return contextPath + urlPathRelativeToContextPath;
    }

    public String getUrlPathRelativeToContextPath() {
        if (this.isEmpty()) {
            return "";
        }
        return this.source.getUrlPathRelativeToContextPath();
    }

    public long getSize() {
        if (this.isEmpty()) {
            return 0L;
        }
        try {
            return this.source.getInputStreamSource().getSize();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public ImageSource getSource() {
        if (this.isEmpty()) {
            return new NullImageSource();
        }
        return this.source;
    }
}

