/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.test.casual;

import com.imcode.util.FileTreeTraverser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.PatternMatcherInput;

public class TestLanguagePropertiesInUse
extends TestCase {
    private Perl5Util perl5Util = new Perl5Util();

    public void testLanguagePropertiesInUse() throws IOException {
        File[] propertiesFiles = new File[]{new File("imcms_swe.properties"), new File("imcms_eng.properties")};
        Set propertyKeysInUse = this.getPropertyKeysInUse();
        this.checkPropertiesFiles(propertiesFiles, propertyKeysInUse);
    }

    private Set getPropertyKeysInUse() {
        StringCollectingFileFilter stringCollectingFilter = new StringCollectingFileFilter("m/<\\? (\\S+) \\?>/");
        FileTreeTraverser fileTreeTraverser = new FileTreeTraverser((FileFilter)stringCollectingFilter);
        fileTreeTraverser.traverseDirectory(new File("sql"));
        fileTreeTraverser.traverseDirectory(new File("web"));
        stringCollectingFilter.setStringPattern("m/\"(\\S+)\"/");
        fileTreeTraverser.traverseDirectory(new File("server"));
        Set propertyKeysInUse = stringCollectingFilter.getCollectedStrings();
        return propertyKeysInUse;
    }

    private void checkPropertiesFiles(File[] propertiesFiles, Set propertyKeysInUse) throws IOException {
        for (int i = 0; i < propertiesFiles.length; ++i) {
            File propertiesFile = propertiesFiles[i];
            this.checkPropertiesFile(propertiesFile, propertyKeysInUse);
        }
    }

    private void checkPropertiesFile(File propertiesFile, Set propertyKeysInUse) throws IOException {
        Properties properties = this.loadPropertiesFile(propertiesFile);
        HashSet<Object> superfluousPropertyKeys = new HashSet<Object>(properties.keySet());
        superfluousPropertyKeys.removeAll(propertyKeysInUse);
        if (!superfluousPropertyKeys.isEmpty()) {
            String listOfLineNumbersOfPropertyKeysInFile = this.createListOfLineNumbersOfPropertyKeysInFile(superfluousPropertyKeys, propertiesFile);
            TestLanguagePropertiesInUse.fail((String)(superfluousPropertyKeys.size() + " of " + properties.keySet().size() + " keys are superfluous: " + SystemUtils.LINE_SEPARATOR + listOfLineNumbersOfPropertyKeysInFile));
        }
    }

    private Properties loadPropertiesFile(File propertiesFile) throws IOException {
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(propertiesFile)));
        return properties;
    }

    private String createListOfLineNumbersOfPropertyKeysInFile(Set propertyKeys, File propertiesFile) throws IOException {
        String line;
        propertyKeys = new HashSet(propertyKeys);
        String propertiesFileCanonicalPath = propertiesFile.getCanonicalPath();
        StringBuffer listBuffer = new StringBuffer();
        LineNumberReader reader = new LineNumberReader(new FileReader(propertiesFile));
        while (null != (line = reader.readLine())) {
            PatternMatcherInput lineToMatch = new PatternMatcherInput(line);
            while (this.perl5Util.match("m/^(\\S+)\\s*[:=]/", lineToMatch)) {
                String propertyKey = this.perl5Util.group(1);
                if (!propertyKeys.remove(propertyKey)) continue;
                listBuffer.append(TestLanguagePropertiesInUse.formatFileLineNumber(propertiesFileCanonicalPath, reader.getLineNumber(), propertyKey));
            }
        }
        Iterator iterator = propertyKeys.iterator();
        while (iterator.hasNext()) {
            String propertyKey = (String)iterator.next();
            listBuffer.append(TestLanguagePropertiesInUse.formatFileLineNumber(propertiesFileCanonicalPath, 0, propertyKey));
        }
        return listBuffer.toString();
    }

    private static String formatFileLineNumber(String canonicalFilePath, int lineNumber, String message) {
        return canonicalFilePath + ':' + lineNumber + ": " + message + SystemUtils.LINE_SEPARATOR;
    }

    public static class StringCollectingFileFilter
    implements FileFilter {
        private Perl5Util perl5Util = new Perl5Util();
        private Set collectedStrings = new HashSet();
        private String stringPattern;

        public StringCollectingFileFilter(String stringPattern) {
            this.stringPattern = stringPattern;
        }

        public boolean accept(File file) {
            try {
                this.collectStringsInFile(file);
            }
            catch (IOException e) {
                throw new UnhandledException((Throwable)e);
            }
            return true;
        }

        private void collectStringsInFile(File file) throws IOException {
            String line;
            if (!file.isFile()) {
                return;
            }
            LineNumberReader reader = new LineNumberReader(new FileReader(file));
            while (null != (line = reader.readLine())) {
                this.collectStringsInLine(line);
            }
        }

        private void collectStringsInLine(String line) {
            PatternMatcherInput lineToMatch = new PatternMatcherInput(line);
            while (this.perl5Util.match(this.stringPattern, lineToMatch)) {
                String propertyKey = this.perl5Util.group(1);
                this.collectedStrings.add(propertyKey);
            }
        }

        public Set getCollectedStrings() {
            return this.collectedStrings;
        }

        public void setStringPattern(String stringPattern) {
            this.stringPattern = stringPattern;
        }
    }
}

