/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class TestLanguagePropertyFilesInSync
extends TestCase {
    public void testLanguagePropertyFiles() throws IOException {
        String dir = ".";
        this.compareLanguagePropertyFiles(dir, "eng", "swe");
        this.compareLanguagePropertyFiles(dir, "swe", "eng");
    }

    private void compareLanguagePropertyFiles(String dir, String lang1, String lang2) throws IOException {
        String testedFileName = "imcms_" + lang1 + ".properties";
        Properties lang1Properties = this.loadPropertyFile(dir, testedFileName);
        Properties lang2Properties = this.loadPropertyFile(dir, "imcms_" + lang2 + ".properties");
        Properties testedProperties = new Properties();
        testedProperties.putAll((Map<?, ?>)lang1Properties);
        this.removeKeysFromProperties(testedProperties, lang2Properties.keySet());
        TestLanguagePropertyFilesInSync.assertTrue((String)("Extra keys in file " + dir + '/' + testedFileName + ": " + testedProperties.keySet().toString()), (boolean)testedProperties.isEmpty());
    }

    private Properties loadPropertyFile(String dir, String fileName) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(new File(dir, fileName)));
        return properties;
    }

    private void removeKeysFromProperties(Properties propertiesToRemoveFrom, Set keysToRemove) {
        Iterator iterator = keysToRemove.iterator();
        while (iterator.hasNext()) {
            propertiesToRemoveFrom.remove(iterator.next());
        }
    }
}

