/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.db.StringArrayArrayResultSetHandler;
import com.imcode.imcms.servlet.superadmin.AdminRoles;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.SettingsAccessor;
import imcode.util.Utility;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

public class AdminRoleBelongings
extends HttpServlet {
    private static final Logger log = Logger.getLogger((String)AdminRoleBelongings.class.getName());
    private static final String HTML_ADMIN_ROLE_BELONGING = "AdminRoleBelongings.html";
    private static final String HTML_ADMIN_ROLE_BELONGING_EDIT = "AdminRoleBelongings_edit.html";
    private static final String HTML_ADMIN_ROLE_BELONGING_ACTIVATE = "AdminRoleBelongings_activate.html";
    private static final String TEMPLATE_ERROR = "Error.html";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            return;
        }
        Object[] parameters = new String[]{};
        String[][] queryResult = (String[][])imcref.getProcedureExecutor().executeProcedure("RoleAdminGetAll", parameters, new StringArrayArrayResultSetHandler());
        String optionList = this.createListOfOptions(queryResult);
        HashMap<String, String> vm = new HashMap<String, String>();
        vm.put("ROLES_MENU", optionList);
        AdminRoles.sendHtml(req, res, vm, HTML_ADMIN_ROLE_BELONGING);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String[] userIds;
        String[] userIds2;
        String userOptionListTag;
        String roleId;
        ImcmsServices imcref = Imcms.getServices();
        String eMailServerMaster = imcref.getSystemData().getServerMasterAddress();
        String errorHeader = "AdminRoleBelongings";
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            String header = "Error in AdminRoleBelongings.";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
            log.debug((Object)(header + "- user is not an administrator"));
            AdminRoles.printErrorMessage(req, res, header, msg);
            return;
        }
        if (req.getParameter("CANCEL") != null) {
            res.sendRedirect("AdminRoles");
            return;
        }
        if (req.getParameter("BELONGING_CANCEL") != null) {
            this.doGet(req, res);
        }
        if (req.getParameter("VIEW_USER_BELONGING_ROLE") != null) {
            roleId = req.getParameter("ROLE_ID");
            if (roleId == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 100, res);
            } else {
                userOptionListTag = this.getUserOptionListTag(roleId, imcref);
                String curentRoleId = roleId;
                try {
                    Integer.parseInt(curentRoleId);
                }
                catch (NumberFormatException e) {
                    curentRoleId = "0";
                }
                Object[] parameters = new String[]{curentRoleId};
                String[][] roleQueryResult = (String[][])imcref.getProcedureExecutor().executeProcedure("RoleGetAllApartFromRole", parameters, new StringArrayArrayResultSetHandler());
                String roleOptionList = this.createListOfOptions(roleQueryResult);
                String curentRoleName = this.getRoleName(roleId, imcref);
                HashMap<String, String> vm = new HashMap<String, String>();
                vm.put("CURENT_ROLE_ID", roleId);
                vm.put("CURENT_ROLE_NAME", curentRoleName);
                vm.put("USER_MENU", userOptionListTag);
                vm.put("ROLES_MENU", roleOptionList);
                AdminRoles.sendHtml(req, res, vm, HTML_ADMIN_ROLE_BELONGING_EDIT);
            }
        }
        if (req.getParameter("VIEW_USER_ACTIVATE") != null) {
            roleId = req.getParameter("ROLE_ID");
            if (roleId == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 100, res);
            } else {
                userOptionListTag = this.getUserOptionListTag(roleId, imcref);
                String curentRoleName = this.getRoleName(roleId, imcref);
                HashMap<String, String> vm = new HashMap<String, String>();
                vm.put("CURENT_ROLE_ID", roleId);
                vm.put("CURENT_ROLE_NAME", curentRoleName);
                vm.put("USER_MENU", userOptionListTag);
                AdminRoles.sendHtml(req, res, vm, HTML_ADMIN_ROLE_BELONGING_ACTIVATE);
            }
        }
        if (req.getParameter("BELONGING_REMOVE_ROLE") != null) {
            String curentRoleId = req.getParameter("CURENT_ROLE_ID");
            userIds2 = req.getParameterValues("USER_ID");
            if (curentRoleId == null || userIds2 == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 101, res);
                return;
            }
            for (int i = 0; i < userIds2.length; ++i) {
                this.removeUserFromRole(userIds2[i], curentRoleId, imcref);
            }
            this.doGet(req, res);
        }
        if (req.getParameter("BELONGING_ADD_ROLE") != null) {
            roleId = req.getParameter("ROLE_ID");
            userIds2 = req.getParameterValues("USER_ID");
            if (roleId == null || userIds2 == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 102, res);
                return;
            }
            for (int i = 0; i < userIds2.length; ++i) {
                this.addUserToRole(userIds2[i], roleId, imcref);
            }
            this.doGet(req, res);
        }
        if (req.getParameter("BELONGING_MOVE_ROLE") != null) {
            roleId = req.getParameter("ROLE_ID");
            String curentRoleId = req.getParameter("CURENT_ROLE_ID");
            String[] userIds3 = req.getParameterValues("USER_ID");
            if (roleId == null || userIds3 == null || curentRoleId == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 102, res);
                return;
            }
            for (int i = 0; i < userIds3.length; ++i) {
                this.removeUserFromRole(userIds3[i], curentRoleId, imcref);
                this.addUserToRole(userIds3[i], roleId, imcref);
            }
            this.doGet(req, res);
        }
        if (req.getParameter("BELONGING_DEACTIVATE") != null) {
            userIds = req.getParameterValues("USER_ID");
            if (userIds == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 101, res);
                return;
            }
            for (int i = 0; i < userIds.length; ++i) {
                this.setUsersActive(userIds[i], "0", imcref);
            }
            this.doGet(req, res);
        }
        if (req.getParameter("BELONGING_ACTIVATE") != null) {
            userIds = req.getParameterValues("USER_ID");
            if (userIds == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 101, res);
                return;
            }
            for (int i = 0; i < userIds.length; ++i) {
                this.setUsersActive(userIds[i], "1", imcref);
            }
            this.doGet(req, res);
        }
    }

    private String createListOfOptions(String[][] options) {
        StringBuffer optionList = new StringBuffer();
        for (int i = 0; i < options.length; ++i) {
            boolean selected = options[i].length == 3;
            optionList.append(this.createOption(options[i][0], options[i][1], selected));
        }
        return optionList.toString();
    }

    private String createListOfOptions(UserDomainObject[] users, boolean selected) {
        StringBuffer optionList = new StringBuffer();
        for (int i = 0; i < users.length; ++i) {
            optionList.append(this.createOption("" + users[i].getId(), users[i].getLastName() + ", " + users[i].getFirstName(), selected));
        }
        return optionList.toString();
    }

    private String createOption(String elementValue, String elementName, boolean selected) {
        StringBuffer option = new StringBuffer();
        option.append("<option value=\"" + elementValue + "\"");
        if (selected) {
            option.append(" selected");
        }
        option.append(">" + elementName + "</option>");
        return option.toString();
    }

    private void addUserToRole(String userId, String roleId, ImcmsServices imcref) {
        this.removeUserFromRole(userId, roleId, imcref);
        Object[] parameters = new String[]{userId, roleId};
        imcref.getProcedureExecutor().executeUpdateProcedure("AddUserRole", parameters);
    }

    private void removeUserFromRole(String userId, String roleId, ImcmsServices imcref) {
        Object[] parameters = new String[]{userId, roleId};
        imcref.getProcedureExecutor().executeUpdateProcedure("RemoveUserFromRole", parameters);
    }

    private String getUserOptionListTag(String roleId, ImcmsServices imcref) {
        String userOptionList;
        if ("ALL_USERS".equals(roleId)) {
            userOptionList = Html.createUsersOptionList(imcref);
        } else {
            ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapper = imcref.getImcmsAuthenticatorAndUserAndRoleMapper();
            RoleDomainObject role = imcmsAuthenticatorAndUserAndRoleMapper.getRoleById(Integer.parseInt(roleId));
            UserDomainObject[] allUsersWithRole = imcmsAuthenticatorAndUserAndRoleMapper.getAllUsersWithRole(role);
            userOptionList = this.createListOfOptions(allUsersWithRole, true);
        }
        return userOptionList;
    }

    private String getRoleName(String roleId, ImcmsServices imcref) {
        RoleDomainObject role;
        String roleName = "";
        if (!roleId.equalsIgnoreCase("ALL_USERS") && null != (role = imcref.getImcmsAuthenticatorAndUserAndRoleMapper().getRoleById(Integer.parseInt(roleId)))) {
            roleName = role.getName();
        }
        return roleName;
    }

    private void setUsersActive(String userId, String state, ImcmsServices imcref) {
        String sqlD = "ChangeUserActiveStatus";
        Object[] parameters = new String[]{userId, state};
        imcref.getProcedureExecutor().executeUpdateProcedure(sqlD, parameters);
    }

    private void sendErrorMessage(ImcmsServices imcref, String eMailServerMaster, UserDomainObject user, String errorHeader, int errorCode, HttpServletResponse response) throws IOException {
        String errorMessage = "";
        try {
            SettingsAccessor setObj = new SettingsAccessor("errmsg.ini", user, "admin");
            setObj.setDelimiter("=");
            setObj.loadSettings();
            errorMessage = setObj.getSetting("" + errorCode);
            if (errorMessage == null) {
                errorMessage = "Missing Errorcode";
            }
        }
        catch (Exception e) {
            throw new UnhandledException((Throwable)e);
        }
        Utility.setDefaultHtmlContentType(response);
        ServletOutputStream out = response.getOutputStream();
        Vector<String> tagParsList = new Vector<String>();
        tagParsList.add("#ERROR_HEADER#");
        tagParsList.add(errorHeader);
        tagParsList.add("#ERROR_MESSAGE#");
        tagParsList.add(errorMessage);
        tagParsList.add("#EMAIL_SERVER_MASTER#");
        tagParsList.add(eMailServerMaster);
        out.print(imcref.getAdminTemplate(TEMPLATE_ERROR, user, tagParsList));
    }
}

