/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.servlet.admin.AdminDoc;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.ConcurrentDocumentModificationException;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.NoPermissionToEditDocumentException;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TreeSortKeyDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.ShouldHaveCheckedPermissionsEarlierException;
import imcode.util.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class SaveSort
extends HttpServlet {
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        ImcmsServices imcref = Imcms.getServices();
        int documentId = Integer.parseInt(req.getParameter("meta_id"));
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        TextDocumentDomainObject document = (TextDocumentDomainObject)documentMapper.getDocument(documentId);
        TextDocumentPermissionSetDomainObject documentPermissionSet = (TextDocumentPermissionSetDomainObject)user.getPermissionSetFor(document);
        if (!documentPermissionSet.getEditMenus()) {
            String output = AdminDoc.adminDoc(documentId, user, req, res);
            if (output != null) {
                ((Writer)out).write(output);
            }
            return;
        }
        Object[] selectedChildrenIds = req.getParameterValues("archiveDelBox");
        int menuIndex = Integer.parseInt(req.getParameter("doc_menu_no"));
        MenuDomainObject menu = document.getMenu(menuIndex);
        try {
            ArrayList<String> logMessages = new ArrayList<String>();
            if (req.getParameter("sort") != null) {
                int sortOrder = Integer.parseInt(req.getParameter("sort_order"));
                if (menu.getSortOrder() != sortOrder) {
                    menu.setSortOrder(sortOrder);
                } else {
                    MenuItemDomainObject[] menuItems = menu.getMenuItems();
                    for (int i = 0; i < menuItems.length; ++i) {
                        MenuItemDomainObject menuItem = menuItems[i];
                        String newSortKey = req.getParameter("" + menuItem.getDocument().getId());
                        if (2 == sortOrder) {
                            try {
                                menuItem.setSortKey(new Integer(newSortKey));
                            }
                            catch (NumberFormatException ignored) {}
                            continue;
                        }
                        if (4 != sortOrder) continue;
                        menuItem.setTreeSortKey(new TreeSortKeyDomainObject(newSortKey));
                    }
                }
                logMessages.add("Child sort order for [" + documentId + "] updated by user: [" + user.getFullName() + "]");
            } else if (req.getParameter("delete") != null) {
                if (selectedChildrenIds != null) {
                    for (int i = 0; i < selectedChildrenIds.length; ++i) {
                        int childId = Integer.parseInt(selectedChildrenIds[i]);
                        menu.removeMenuItemByDocumentId(childId);
                        imcref.updateMainLog("Link from [" + document.getId() + "] in menu [" + menuIndex + "] to [" + childId + "] removed by user: [" + user.getFullName() + "]");
                    }
                }
            } else if (req.getParameter("archive") != null) {
                if (selectedChildrenIds != null) {
                    Date now = new Date();
                    for (int i = 0; i < selectedChildrenIds.length; ++i) {
                        int childId = Integer.parseInt(selectedChildrenIds[i]);
                        DocumentDomainObject child = documentMapper.getDocument(childId);
                        child.setArchivedDatetime(now);
                        documentMapper.saveDocument(child, user);
                    }
                    logMessages.add("Childs [" + StringUtils.join((Object[])selectedChildrenIds, (String)", ") + "] from " + "[" + documentId + "] archived by user: [" + user.getFullName() + "]");
                }
            } else if (req.getParameter("copy") != null && selectedChildrenIds != null) {
                for (int i = 0; i < selectedChildrenIds.length; ++i) {
                    String selectedChildIdStr = selectedChildrenIds[i];
                    int selectedChildId = Integer.parseInt(selectedChildIdStr);
                    DocumentDomainObject selectedChild = documentMapper.getDocument(selectedChildId);
                    documentMapper.copyDocument(selectedChild, user);
                    menu.addMenuItem(new MenuItemDomainObject(documentMapper.getDocumentReference(selectedChild)));
                }
            }
            documentMapper.saveDocument(document, user);
            Iterator iterator = logMessages.iterator();
            while (iterator.hasNext()) {
                String logMessage = (String)iterator.next();
                imcref.updateMainLog(logMessage);
            }
            res.sendRedirect("AdminDoc?meta_id=" + documentId + "&flags=" + 262144 + "&editmenu=" + menuIndex);
        }
        catch (NoPermissionToEditDocumentException e) {
            throw new ShouldHaveCheckedPermissionsEarlierException(e);
        }
        catch (NoPermissionToAddDocumentToMenuException e) {
            throw new ConcurrentDocumentModificationException(e);
        }
    }
}

