/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.servlet.admin.ChangeImage;
import com.imcode.imcms.servlet.admin.ImageBrowser;
import com.imcode.util.HumanReadable;
import com.imcode.util.MultipartHttpServletRequest;
import imcode.server.Imcms;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.HttpSessionUtils;
import imcode.util.ImageExtensionFilenameFilter;
import imcode.util.LocalizedMessage;
import imcode.util.ToStringPairTransformer;
import imcode.util.Utility;
import imcode.util.io.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

public class ImageBrowse
extends HttpServlet {
    private static final Logger log = Logger.getLogger((String)ImageBrowse.class.getName());
    private static final String JSP__IMAGE_BROWSE = "ImageBrowse.jsp";
    public static final String REQUEST_PARAMETER__OK_BUTTON = "ImageBrowse.button.ok";
    public static final String REQUEST_PARAMETER__PREVIEW_BUTTON = "ImageBrowse.button.preview";
    public static final String REQUEST_PARAMETER__CANCEL_BUTTON = "ImageBrowse.button.cancel";
    public static final String REQUEST_PARAMETER__CHANGE_DIRECTORY_BUTTON = "ImageBrowse.button.change";
    public static final String REQUEST_PARAMETER__IMAGE_URL = "imglist";
    public static final String REQUEST_PARAMETER__IMAGE_DIRECTORY = "dirlist";
    public static final String REQUEST_PARAMETER__LABEL = "label";
    public static final String REQUEST_PARAMETER__UPLOAD_BUTTON = "upload";
    public static final String REQUEST_PARAMETER__FILE = "file";
    private static final LocalizedMessage ERROR_MESSAGE__FILE_EXISTS = new LocalizedMessage("error/servlet/images/image_file_exists");

    public void doPost(HttpServletRequest req, HttpServletResponse response) throws IOException, ServletException {
        MultipartHttpServletRequest request = new MultipartHttpServletRequest(req);
        ImageBrowser imageBrowser = (ImageBrowser)HttpSessionUtils.getSessionAttributeWithNameInRequest((HttpServletRequest)request, "imageBrowser");
        String imageUrl = request.getParameter(REQUEST_PARAMETER__IMAGE_URL);
        if (null != request.getParameter(REQUEST_PARAMETER__CANCEL_BUTTON)) {
            imageBrowser.cancel((HttpServletRequest)request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__OK_BUTTON) && null != imageUrl) {
            imageBrowser.selectImageUrl(imageUrl, (HttpServletRequest)request, response);
        } else {
            ImageBrowse.browse(imageUrl, (HttpServletRequest)request, response);
        }
    }

    public static void browse(String imageUrl, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File imageDirectory;
        File selectedDirectory;
        File image;
        File imagesRoot = Imcms.getServices().getConfig().getImagePath();
        boolean changeDirectoryButtonWasPressed = null != request.getParameter(REQUEST_PARAMETER__CHANGE_DIRECTORY_BUTTON);
        File selectedImage = null;
        if (null != imageUrl && !changeDirectoryButtonWasPressed && FileUtility.directoryIsAncestorOfOrEqualTo(imagesRoot, (image = new File(imagesRoot, imageUrl)).getParentFile())) {
            selectedImage = image;
        }
        String imageDirectoryString = request.getParameter(REQUEST_PARAMETER__IMAGE_DIRECTORY);
        File file = selectedDirectory = null != selectedImage ? selectedImage.getParentFile() : imagesRoot;
        if (null != imageDirectoryString && FileUtility.directoryIsAncestorOfOrEqualTo(imagesRoot, imageDirectory = new File(imagesRoot.getParentFile(), imageDirectoryString))) {
            selectedDirectory = imageDirectory;
        }
        ImageBrowserPage page = new ImageBrowserPage(selectedDirectory, selectedImage);
        if (null != request.getParameter(REQUEST_PARAMETER__UPLOAD_BUTTON)) {
            ImageBrowse.upload(request, selectedDirectory, page);
        }
        page.setLabel(StringUtils.defaultString((String)request.getParameter(REQUEST_PARAMETER__LABEL)));
        page.forward(request, response);
    }

    private static void upload(HttpServletRequest request, File selectedDirectory, ImageBrowserPage page) {
        File imagesRoot = Imcms.getServices().getConfig().getImagePath();
        MultipartHttpServletRequest.DataSourceFileItem fileItem = ((MultipartHttpServletRequest)request).getParameterFileItem(REQUEST_PARAMETER__FILE);
        if (null != fileItem) {
            File destinationFile = new File(selectedDirectory, fileItem.getName());
            boolean underImagesRoot = FileUtility.directoryIsAncestorOfOrEqualTo(imagesRoot, destinationFile.getParentFile());
            boolean hasImageExtension = new ImageExtensionFilenameFilter().accept(destinationFile, destinationFile.getName());
            if (!hasImageExtension) {
                page.setErrorMessage(ChangeImage.ERROR_MESSAGE__ONLY_ALLOWED_TO_UPLOAD_IMAGES);
            } else if (destinationFile.exists()) {
                page.setErrorMessage(ERROR_MESSAGE__FILE_EXISTS);
            } else if (underImagesRoot) {
                try {
                    fileItem.write(destinationFile);
                    page.setCurrentImage(destinationFile);
                }
                catch (Exception e) {
                    throw new UnhandledException("Failed to write file " + destinationFile + ". Possible permissions problem?", (Throwable)e);
                }
            } else {
                log.info((Object)("User " + Utility.getLoggedOnUser(request) + " was denied uploading to file " + destinationFile));
            }
        }
    }

    public static class ImageBrowserPage {
        private static final String REQUEST_ATTRIBUTE__IMAGE_BROWSE_PAGE = "imagebrowsepage";
        private String label;
        private String imageUrl;
        private LocalizedMessage errorMessage;
        private File currentDirectory;
        private File currentImage;

        public ImageBrowserPage(File currentDirectory, File currentImage) {
            this.currentDirectory = currentDirectory;
            this.currentImage = currentImage;
        }

        public String getLabel() {
            return this.label;
        }

        private void setLabel(String label) {
            this.label = label;
        }

        public String getDirectoriesOptionList() {
            File imagesRoot = Imcms.getServices().getConfig().getImagePath();
            Collection imageDirectories = Utility.collectImageDirectories();
            File currentDirectoryRelativeToImageRootParent = FileUtility.relativizeFile(imagesRoot.getParentFile(), this.currentDirectory);
            return Html.createOptionList(imageDirectories, currentDirectoryRelativeToImageRootParent, new ToStringPairTransformer(){

                public String[] transformToStringPair(Object input) {
                    File file = (File)input;
                    return new String[]{FileUtility.relativeFileToString(file), FileUtility.relativeFileToString(file)};
                }
            });
        }

        public String getImagesOptionList() {
            final File imagesRoot = Imcms.getServices().getConfig().getImagePath();
            if (null != this.currentImage) {
                this.imageUrl = FileUtility.relativeFileToString(FileUtility.relativizeFile(imagesRoot, this.currentImage));
            }
            Object[] images = this.currentDirectory.listFiles(new ImageExtensionFilenameFilter());
            Arrays.sort(images);
            List<Object> imageList = Arrays.asList(images);
            return Html.createOptionList(imageList, this.currentImage, new ToStringPairTransformer(){

                public String[] transformToStringPair(Object input) {
                    File file = (File)input;
                    String formattedFileSize = HumanReadable.getHumanReadableByteSize((long)file.length());
                    return new String[]{FileUtility.relativeFileToString(FileUtility.relativizeFile(imagesRoot, file)), file.getName() + "\t[" + formattedFileSize + "]"};
                }
            });
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public void forward(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            request.setAttribute(REQUEST_ATTRIBUTE__IMAGE_BROWSE_PAGE, (Object)this);
            UserDomainObject user = Utility.getLoggedOnUser(request);
            String forwardPath = "/imcms/" + user.getLanguageIso639_2() + "/jsp/" + ImageBrowse.JSP__IMAGE_BROWSE;
            request.getRequestDispatcher(forwardPath).forward((ServletRequest)request, (ServletResponse)response);
        }

        public static ImageBrowserPage fromRequest(HttpServletRequest request) {
            return (ImageBrowserPage)request.getAttribute(REQUEST_ATTRIBUTE__IMAGE_BROWSE_PAGE);
        }

        public void setErrorMessage(LocalizedMessage errorMessage) {
            this.errorMessage = errorMessage;
        }

        public LocalizedMessage getErrorMessage() {
            return this.errorMessage;
        }

        public void setCurrentImage(File currentImage) {
            this.currentImage = currentImage;
        }
    }
}

