/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.servlet.GetDoc;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class Help
extends HttpServlet {
    private static final Logger log = Logger.getLogger((String)GetDoc.class.getName());

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String helpDocName = req.getParameter("name");
        String lang = req.getParameter("lang");
        try {
            Properties helpProp = this.loadProperties("/WEB-INF/help/helpdoc_" + lang + ".properties");
            try {
                int helpdoc = Integer.parseInt(helpProp.getProperty(helpDocName));
                res.sendRedirect(helpdoc + "");
            }
            catch (NumberFormatException e) {
                log.error((Object)("Help link error, help doc name: " + helpDocName + ",  no corresponding meta_id found."));
                res.sendError(404);
            }
        }
        catch (NullPointerException e) {
            log.error((Object)("Help link error, help doc name: " + helpDocName + ", 'lang' parameter is wrong."));
            res.sendError(404);
        }
    }

    private Properties loadProperties(String path) throws IOException {
        InputStream resourceAsStream = this.getServletConfig().getServletContext().getResourceAsStream(path);
        Properties properties = new Properties();
        properties.load(resourceAsStream);
        return properties;
    }
}

