/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import imcode.server.Imcms;
import imcode.server.WebAppGlobalConstants;
import imcode.util.Prefs;
import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class ContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        File realPathToWebApp = new File(servletContext.getRealPath("/"));
        WebAppGlobalConstants.init(realPathToWebApp);
        File configPath = new File(realPathToWebApp, "WEB-INF/conf");
        Prefs.setConfigPath(configPath);
        this.configureLogging(servletContext, realPathToWebApp, configPath);
        Logger log = Logger.getLogger((Class)ContextListener.class);
        try {
            Imcms.start();
            log.info((Object)"imCMS initialized.");
        }
        catch (RuntimeException e) {
            log.fatal((Object)"Failed to initialize imCMS.", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        Logger log = Logger.getLogger((Class)ContextListener.class);
        log.debug((Object)"Stopping imCMS.");
        Imcms.stop();
        log.debug((Object)"Shutting down logging.");
        LogManager.shutdown();
        LogFactory.releaseAll();
    }

    private void configureLogging(ServletContext servletContext, File root, File configPath) {
        System.setProperty("com.imcode.imcms.path", root.toString());
        File configFile = new File(configPath, "log4j.xml");
        DOMConfigurator.configure((String)configFile.toString());
        Logger log = Logger.getLogger((Class)ContextListener.class);
        log.info((Object)"Logging started");
        this.logPlatformInfo(servletContext, log);
    }

    private void logPlatformInfo(ServletContext application, Logger log) {
        log.info((Object)("Servlet Engine: " + application.getServerInfo()));
        String[] systemPropertyNames = new String[]{"java.version", "java.vendor", "java.class.path", "os.name", "os.arch", "os.version"};
        for (int i = 0; i < systemPropertyNames.length; ++i) {
            String systemPropertyName = systemPropertyNames[i];
            log.info((Object)(systemPropertyName + ": " + System.getProperty(systemPropertyName)));
        }
    }
}

