/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.mock.MockDatabase;
import com.imcode.imcms.mapping.DocumentPermissionSetMapper;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import junit.framework.TestCase;

public class TestDocumentPermissionSetMapper
extends TestCase {
    private DocumentPermissionSetMapper documentPermissionSetMapper;
    private TextDocumentPermissionSetDomainObject textDocumentPermissionSet;
    private MockDatabase database;
    private TextDocumentDomainObject textDocument;

    public void setUp() throws Exception {
        super.setUp();
        this.database = new MockDatabase();
        this.documentPermissionSetMapper = new DocumentPermissionSetMapper((Database)this.database);
        this.textDocument = new TextDocumentDomainObject();
        this.textDocumentPermissionSet = new TextDocumentPermissionSetDomainObject(DocumentPermissionSetTypeDomainObject.RESTRICTED_1);
    }

    public void testSetTextDocumentPermissionSetFromBits() throws Exception {
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.StartsWithSqlCallPredicate("SELECT meta_id, set_id, permission_data FROM "), null);
        this.textDocumentPermissionSet.setEditDocumentInformation(false);
        this.textDocumentPermissionSet.setEditPermissions(false);
        this.textDocumentPermissionSet.setEdit(true);
        this.textDocumentPermissionSet.setEditTexts(true);
        this.textDocumentPermissionSet.setEditImages(false);
        this.textDocumentPermissionSet.setEditMenus(false);
        this.textDocumentPermissionSet.setEditIncludes(false);
        this.textDocumentPermissionSet.setEditTemplates(false);
        TestDocumentPermissionSetMapper.assertTrue((boolean)this.textDocumentPermissionSet.getEditTexts());
    }

    public void testSaveRestrictedTextDocumentPermissionSet() {
        this.documentPermissionSetMapper.saveRestrictedDocumentPermissionSet(this.textDocument, this.textDocumentPermissionSet, false);
        this.database.assertCalled((MockDatabase.SqlCallPredicate)new MockDatabase.InsertIntoTableWithParameterSqlCallPredicate("doc_permission_sets", "0"));
        this.textDocumentPermissionSet.setEditTexts(true);
        this.documentPermissionSetMapper.saveRestrictedDocumentPermissionSet(this.textDocument, this.textDocumentPermissionSet, false);
        this.database.assertCalled((MockDatabase.SqlCallPredicate)new MockDatabase.InsertIntoTableWithParameterSqlCallPredicate("doc_permission_sets", "65536"));
    }
}

